/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.containers.inventory;

import com.gildedgames.util.core.nbt.NBT;
import com.gildedgames.util.core.nbt.NBTHelper;
import io.netty.buffer.ByteBuf;
import net.aetherteam.aether.data.ByteDecoder;
import net.aetherteam.aether.data.ByteEncoder;
import net.aetherteam.aether.data.IEncodableByte;
import net.aetherteam.aether.items.ItemAccessory;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryAccessories
implements IInventory,
NBT,
IEncodableByte {
    public EntityPlayer player;
    public PlayerAether playerAether;
    public ItemStack[] stacks = new ItemStack[8];
    public boolean inventoryChanged;
    public static ItemAccessory.AccessoryType[] slotTypes = new ItemAccessory.AccessoryType[]{ItemAccessory.AccessoryType.PENDANT, ItemAccessory.AccessoryType.COMPANION, ItemAccessory.AccessoryType.SHIELD, ItemAccessory.AccessoryType.MISC, ItemAccessory.AccessoryType.RING, ItemAccessory.AccessoryType.RING, ItemAccessory.AccessoryType.GLOVE, ItemAccessory.AccessoryType.MISC};

    public InventoryAccessories(PlayerAether playerAether, EntityPlayer player) {
        this.player = player;
        this.playerAether = playerAether;
    }

    public void dropAllItems() {
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null) continue;
            this.player.func_146097_a(this.stacks[i], true, false);
            this.stacks[i] = null;
        }
    }

    public int clearInventory(Item par1, int par2) {
        int count = 0;
        for (int i = 0; i < this.stacks.length; ++i) {
            ItemStack itemstack = this.stacks[i];
            if (itemstack == null || par1 == null && itemstack.func_77973_b() != par1 || par2 > -1 && itemstack.func_77960_j() != par2) continue;
            count += itemstack.field_77994_a;
            this.stacks[i] = null;
        }
        return count;
    }

    public int breakItem(Item item, ItemAccessory.AccessoryType AccessoryType2) {
        int count = 0;
        for (int i = 0; i < this.stacks.length; ++i) {
            ItemStack itemstack = this.stacks[i];
            if (itemstack == null || itemstack != this.getStackFromType(AccessoryType2) || item == null && itemstack.func_77973_b() != item) continue;
            if (itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74767_n("Unbreakable")) {
                return count;
            }
            count += itemstack.field_77994_a;
            this.stacks[i] = null;
        }
        return count;
    }

    public void onUpdate() {
        for (ItemStack stack : this.stacks) {
            if (stack == null) continue;
            stack.func_77973_b().func_77663_a(stack, this.player.field_70170_p, (Entity)this.player, -1, false);
        }
    }

    public int func_70302_i_() {
        return this.stacks.length;
    }

    public boolean setInventoryAccessory(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemAccessory) {
            ItemAccessory accessoryItem = (ItemAccessory)stack.func_77973_b();
            ItemAccessory.AccessoryType type = accessoryItem.getType();
            int stackIndex = 0;
            for (ItemAccessory.AccessoryType accessoryType : slotTypes) {
                if (type == accessoryType && this.stacks[stackIndex] == null) {
                    accessoryItem.onEquip(stack, this.player);
                    this.playerAether.markDirty();
                    this.stacks[stackIndex] = stack;
                    return true;
                }
                ++stackIndex;
            }
        }
        return false;
    }

    public void func_70299_a(int slotID, ItemStack stack) {
        if (slotID < this.stacks.length) {
            if (stack != null && stack.func_77973_b() instanceof ItemAccessory) {
                ((ItemAccessory)stack.func_77973_b()).onEquip(stack, this.player);
                this.playerAether.markDirty();
            }
            this.stacks[slotID] = stack;
        }
    }

    public ItemStack func_70301_a(int slotID) {
        if (slotID < this.stacks.length) {
            return this.stacks[slotID];
        }
        return null;
    }

    public ItemStack getStackFromType(ItemAccessory.AccessoryType type) {
        for (ItemStack stack : this.stacks) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemAccessory) || !((ItemAccessory)stack.func_77973_b()).getType().equals((Object)type)) continue;
            return stack;
        }
        return null;
    }

    public ItemStack getStackFromID(Item itemID) {
        for (ItemStack stack : this.stacks) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemAccessory) || stack.func_77973_b() != itemID) continue;
            return stack;
        }
        return null;
    }

    public ItemStack func_70298_a(int slotID, int decreaseSize) {
        ItemStack[] accessories = this.stacks;
        if (accessories[slotID] != null) {
            if (accessories[slotID].field_77994_a <= decreaseSize) {
                ItemStack itemstack = accessories[slotID];
                if (itemstack.func_77973_b() instanceof ItemAccessory) {
                    ((ItemAccessory)itemstack.func_77973_b()).onUnequip(itemstack, this.player);
                }
                accessories[slotID] = null;
                return itemstack;
            }
            ItemStack itemstack = accessories[slotID].func_77979_a(decreaseSize);
            if (accessories[slotID].field_77994_a == 0) {
                if (itemstack.func_77973_b() instanceof ItemAccessory) {
                    ((ItemAccessory)itemstack.func_77973_b()).onUnequip(itemstack, this.player);
                }
                accessories[slotID] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slotID) {
        ItemStack[] accessories = this.stacks;
        if (accessories[slotID] != null) {
            ItemStack itemstack = accessories[slotID];
            accessories[slotID] = null;
            return itemstack;
        }
        return null;
    }

    public String func_145825_b() {
        return "accessories";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        this.inventoryChanged = true;
        this.playerAether.markDirty();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !this.player.field_70128_L && player.func_70068_e((Entity)this.player) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotID, ItemStack stack) {
        return true;
    }

    public void write(NBTTagCompound tag) {
        tag.func_74782_a("accessories", (NBTBase)NBTHelper.encodeStackList((ItemStack[])this.stacks));
    }

    public void read(NBTTagCompound tag) {
        this.stacks = NBTHelper.decodeStackList((NBTTagList)tag.func_150295_c("accessories", 10));
    }

    @Override
    public void writeData(ByteBuf dataOutput) {
        ByteEncoder.encodeItemStackArray(dataOutput, this.stacks);
    }

    @Override
    public void readData(ByteBuf dataInput) {
        this.stacks = ByteDecoder.decodeItemStackArray(dataInput);
    }
}

