/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.data;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.aetherteam.aether.data.IEncodableByte;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class ByteDecoder {
    public static IEncodableByte decode(Class<? extends IEncodableByte> clazz, byte[] bytes) {
        IEncodableByte object = null;
        try {
            object = clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (object != null) {
            ByteBuf bytebuf = Unpooled.wrappedBuffer((byte[])bytes);
            object.readData(bytebuf);
        }
        return object;
    }

    public static ArrayList decodeArrayList(ByteBuf dataInput, Class<? extends IEncodableByte> clazz) {
        try {
            int objectCount = dataInput.readInt();
            ArrayList<IEncodableByte> list = new ArrayList<IEncodableByte>(objectCount);
            for (int i = 0; i < objectCount; ++i) {
                IEncodableByte object = clazz.newInstance();
                object.readData(dataInput);
                list.add(object);
            }
            return list;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return new ArrayList();
    }

    public static ArrayList decodeArrayList(Class<? extends IEncodableByte> clazz, byte[] bytes) {
        ByteBuf bytebuf = Unpooled.wrappedBuffer((byte[])bytes);
        return ByteDecoder.decodeArrayList(bytebuf, clazz);
    }

    public static ArrayList<String> decodeStringList(ByteBuf dataInput) {
        int stringCount = dataInput.readInt();
        ArrayList<String> list = new ArrayList<String>(stringCount);
        for (int i = 0; i < stringCount; ++i) {
            list.add(ByteBufUtils.readUTF8String((ByteBuf)dataInput));
        }
        return list;
    }

    public static ArrayList<PlayerAether> decodePlayerList(ByteBuf dataInput) {
        int playerCount = dataInput.readInt();
        ArrayList<PlayerAether> list = new ArrayList<PlayerAether>(playerCount);
        for (int i = 0; i < playerCount; ++i) {
            list.add(PlayerAether.get(new UUID(dataInput.readLong(), dataInput.readLong())));
        }
        return list;
    }

    public static ItemStack[] decodeItemStackArray(ByteBuf dataInput) {
        int amount = dataInput.readInt();
        ItemStack[] stackArray = new ItemStack[amount];
        for (int i = 0; i < amount; ++i) {
            PacketBuffer pb = new PacketBuffer(dataInput);
            try {
                stackArray[i] = pb.func_150791_c();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return stackArray;
    }

    public static ArrayList<String> decodeStringList(byte[] bytes) {
        ByteBuf bytebuff = Unpooled.wrappedBuffer((byte[])bytes);
        return ByteDecoder.decodeStringList(bytebuff);
    }

    public static ArrayList<PlayerAether> decodePlayerList(byte[] bytes) {
        ByteBuf bytebuf = Unpooled.wrappedBuffer((byte[])bytes);
        return ByteDecoder.decodePlayerList(bytebuf);
    }

    public static int[] decodeIntArray(ByteBuf dataInput) {
        int arraySize = dataInput.readInt();
        int[] intArray = new int[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            intArray[i] = dataInput.readInt();
        }
        return intArray;
    }

    public static HashMap<String, Integer> decodeStringIntMap(ByteBuf dataInput) {
        ArrayList<String> keys = ByteDecoder.decodeStringList(dataInput);
        int[] values = ByteDecoder.decodeIntArray(dataInput);
        HashMap<String, Integer> stringIntMap = new HashMap<String, Integer>();
        for (int i = 0; i < keys.size(); ++i) {
            stringIntMap.put(keys.get(i), values[i]);
        }
        return stringIntMap;
    }

    public static HashMap<String, Integer> decodeStringIntMap(byte[] bytes) {
        ByteBuf bytebuf = Unpooled.wrappedBuffer((byte[])bytes);
        return ByteDecoder.decodeStringIntMap(bytebuf);
    }

    public static HashMap<? extends IEncodableByte, Integer> decodeIntMap(Class<? extends IEncodableByte> clazz, byte[] bytes) {
        ByteBuf bytebuf = Unpooled.wrappedBuffer((byte[])bytes);
        ArrayList keys = ByteDecoder.decodeArrayList(bytebuf, clazz);
        int[] values = ByteDecoder.decodeIntArray(bytebuf);
        HashMap<IEncodableByte, Integer> map = new HashMap<IEncodableByte, Integer>();
        for (int i = 0; i < keys.size(); ++i) {
            map.put((IEncodableByte)keys.get(i), values[i]);
        }
        return map;
    }
}

