/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.dungeons.worldgen.rooms;

import java.util.Random;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.blocks.util.Rotation;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoom;
import net.aetherteam.aether.entities.bosses.slider.EntitySlider;
import net.aetherteam.aether.tile_entities.util.TileEntityMultiBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class DungeonRoomSliderBoss
extends DungeonRoom {
    int yOffset = 3;
    int entranceOffset = 8;

    public DungeonRoomSliderBoss(Dungeon dungeon, int componentType, StructureComponent previousStructure, Random rand, int maxX, int maxZ) {
        super(dungeon, componentType, previousStructure, rand, maxX, maxZ);
        this.field_74887_e = new StructureBoundingBox(maxX, 30 - this.yOffset, maxZ, maxX + 24, 40, maxZ + 15);
        this.entrances.clear();
        this.addEntranceToAllFourWalls();
    }

    @Override
    public void addEntranceToAllFourWalls() {
        this.entrances.add(new StructureBoundingBox(this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 1 + this.yOffset, this.field_74887_e.field_78896_c - 2, this.field_74887_e.field_78897_a + this.entranceOffset, this.field_74887_e.field_78894_e - 1, this.field_74887_e.field_78896_c));
        this.entrances.add(new StructureBoundingBox(this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 1 + this.yOffset, this.field_74887_e.field_78892_f, this.field_74887_e.field_78897_a + this.entranceOffset, this.field_74887_e.field_78894_e - 1, this.field_74887_e.field_78892_f + 2));
        this.entrances.add(new StructureBoundingBox(this.field_74887_e.field_78897_a - 2, this.field_74887_e.field_78895_b + 1 + this.yOffset, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 1, this.field_74887_e.field_78892_f - 1));
    }

    @Override
    public boolean func_74875_a(World world, Random rand, StructureBoundingBox chunkBox) {
        TileEntityMultiBlock tileEntity;
        for (int var12 = this.field_74887_e.field_78895_b; var12 <= this.field_74887_e.field_78894_e; ++var12) {
            for (int var13 = this.field_74887_e.field_78897_a; var13 <= this.field_74887_e.field_78893_d; ++var13) {
                for (int var14 = this.field_74887_e.field_78896_c; var14 <= this.field_74887_e.field_78892_f; ++var14) {
                    this.func_151550_a(world, rand.nextInt(20) == 1 ? AetherBlocks.DivineLightDungeonStone : AetherBlocks.DivineDungeonStone, 0, var13, var12, var14, chunkBox);
                }
            }
        }
        int minX = this.field_74887_e.field_78897_a + this.entranceOffset + (this.field_74887_e.field_78893_d - (this.field_74887_e.field_78897_a + this.entranceOffset)) / 2 - 1;
        int minY = this.field_74887_e.field_78895_b + this.yOffset + 1;
        int minZ = this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 - 1;
        int maxX = this.field_74887_e.field_78897_a + this.entranceOffset + (this.field_74887_e.field_78893_d - (this.field_74887_e.field_78897_a + this.entranceOffset)) / 2 + 2;
        int maxY = this.field_74887_e.field_78895_b + this.yOffset + 1;
        int maxZ = this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 + 2;
        this.fillWithBlocksWithNotify(world, chunkBox, this.field_74887_e.field_78897_a + 1 + this.entranceOffset, minY, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e - 1, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.fillWithBlocksWithNotify(world, chunkBox, this.field_74887_e.field_78897_a + 1, minY, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78897_a - 1 + this.entranceOffset, this.field_74887_e.field_78894_e - 1, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.fillWithBlocksWithNotify(world, chunkBox, minX, minY - 3, minZ, maxX, maxY, maxZ, AetherBlocks.DivineDungeonStone, Blocks.field_150350_a, false);
        if (chunkBox.func_78890_b(this.field_74887_e.field_78897_a + this.entranceOffset + (this.field_74887_e.field_78893_d - (this.field_74887_e.field_78897_a + this.entranceOffset)) / 2 + 1, maxY + 2, this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 + 1)) {
            EntitySlider slider = new EntitySlider(world, this.field_74887_e.field_78897_a + this.entranceOffset + (this.field_74887_e.field_78893_d - (this.field_74887_e.field_78897_a + this.entranceOffset)) / 2 + 1, maxY + 2, this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 + 1);
            world.func_72838_d((Entity)slider);
        }
        this.fillWithBlocksWithNotify(world, chunkBox, minX + 1, minY - 2, minZ + 1, maxX - 1, maxY - 1, maxZ - 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.fillBlocksAndRegister(world, chunkBox, this.field_74887_e.field_78897_a + this.entranceOffset, minY, this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 - 2, this.field_74887_e.field_78897_a + this.entranceOffset, minY + 3, this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 + 2, Blocks.field_150350_a, Blocks.field_150350_a, false, this.dungeonInstance);
        this.func_151550_a(world, AetherBlocks.SliderLabyrinthDoor, 0, this.field_74887_e.field_78897_a + this.entranceOffset, minY, this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2, chunkBox);
        TileEntity tile = world.func_147438_o(this.field_74887_e.field_78897_a + this.entranceOffset, minY, this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2);
        int tileX = this.field_74887_e.field_78897_a + this.entranceOffset;
        int tileY = minY;
        int tileZ = this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2;
        if (tile instanceof TileEntityMultiBlock && (tileEntity = (TileEntityMultiBlock)tile).getCurrentRotation(world, tileX, tileY, tileZ) != Rotation.EAST) {
            tileEntity.setRotationAndRefresh(Rotation.EAST);
        }
        this.cutHolesForEntrances(world, rand, chunkBox);
        return true;
    }

    protected void fillWithBlocksWithNotify(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int par6, int par7, int par8, Block par9, Block par10, boolean par11) {
        for (int var12 = par4; var12 <= par7; ++var12) {
            for (int var13 = par3; var13 <= par6; ++var13) {
                for (int var14 = par5; var14 <= par8; ++var14) {
                    if (par11 && this.func_151548_a(par1World, var13, var12, var14, par2StructureBoundingBox) == Blocks.field_150350_a) continue;
                    if (var12 != par4 && var12 != par7 && var13 != par3 && var13 != par6 && var14 != par5 && var14 != par8) {
                        this.func_151550_a(par1World, par10, 0, var13, var12, var14, par2StructureBoundingBox);
                        continue;
                    }
                    this.func_151550_a(par1World, par9, 0, var13, var12, var14, par2StructureBoundingBox);
                }
            }
        }
    }

    protected void fillBlocksAndRegister(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int par6, int par7, int par8, Block par9, Block par10, boolean par11, Dungeon dungeon) {
        for (int var12 = par4; var12 <= par7; ++var12) {
            for (int var13 = par3; var13 <= par6; ++var13) {
                for (int var14 = par5; var14 <= par8; ++var14) {
                    if (par11 && this.func_151548_a(par1World, var13, var12, var14, par2StructureBoundingBox) == Blocks.field_150350_a) continue;
                    if (var12 != par4 && var12 != par7 && var13 != par3 && var13 != par6 && var14 != par5 && var14 != par8) {
                        this.func_151550_a(par1World, par10, 0, var13, var12, var14, par2StructureBoundingBox);
                        continue;
                    }
                    this.func_151550_a(par1World, par9, 0, var13, var12, var14, par2StructureBoundingBox);
                }
            }
        }
    }
}

