/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.entities;

import com.gildedgames.util.spawning.ScheduledSpawn;
import com.gildedgames.util.spawning.SpawnCondition;
import com.gildedgames.util.spawning.SpawnEntry;
import com.gildedgames.util.spawning.SpawnManager;
import com.gildedgames.util.spawning.SpawnSettings;
import com.gildedgames.util.spawning.SpawningCore;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.AetherConfig;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.entities.EntityAechorPlant;
import net.aetherteam.aether.entities.EntityAetherCoin;
import net.aetherteam.aether.entities.EntityAetherLightning;
import net.aetherteam.aether.entities.EntityBattleSentry;
import net.aetherteam.aether.entities.EntityCarrionSprout;
import net.aetherteam.aether.entities.EntityCockatrice;
import net.aetherteam.aether.entities.EntityFloatingBlock;
import net.aetherteam.aether.entities.EntityLightningKnife;
import net.aetherteam.aether.entities.EntityMimic;
import net.aetherteam.aether.entities.EntityPoisonNeedle;
import net.aetherteam.aether.entities.EntitySentry;
import net.aetherteam.aether.entities.EntitySentryGolem;
import net.aetherteam.aether.entities.EntitySheepuff;
import net.aetherteam.aether.entities.EntityTNTPresent;
import net.aetherteam.aether.entities.EntityTempest;
import net.aetherteam.aether.entities.EntityTrackingGolem;
import net.aetherteam.aether.entities.EntityZephyr;
import net.aetherteam.aether.entities.EntityZephyroo;
import net.aetherteam.aether.entities.altar.EntityFakeItem;
import net.aetherteam.aether.entities.bosses.EntityCog;
import net.aetherteam.aether.entities.bosses.EntityHostEye;
import net.aetherteam.aether.entities.bosses.EntityLabyrinthEye;
import net.aetherteam.aether.entities.bosses.EntitySentryGuardian;
import net.aetherteam.aether.entities.bosses.EntitySliderHostMimic;
import net.aetherteam.aether.entities.bosses.slider.EntitySlider;
import net.aetherteam.aether.entities.companion.EntityEtherealWisp;
import net.aetherteam.aether.entities.companion.EntityFangrin;
import net.aetherteam.aether.entities.companion.EntityFleetingWisp;
import net.aetherteam.aether.entities.companion.EntityFrostboundSprite;
import net.aetherteam.aether.entities.companion.EntityFrostpineTotem;
import net.aetherteam.aether.entities.companion.EntityKraisith;
import net.aetherteam.aether.entities.companion.EntityNexSpirit;
import net.aetherteam.aether.entities.companion.EntityPinkSwet;
import net.aetherteam.aether.entities.companion.EntityShadeOfArkenzus;
import net.aetherteam.aether.entities.companion.EntitySoaringWisp;
import net.aetherteam.aether.entities.dungeon.EntityRewardItemStack;
import net.aetherteam.aether.entities.mounts.EntityAerbunny;
import net.aetherteam.aether.entities.mounts.EntityFlyingCow;
import net.aetherteam.aether.entities.mounts.EntityParachute;
import net.aetherteam.aether.entities.mounts.EntityPhyg;
import net.aetherteam.aether.entities.mounts.EntitySwet;
import net.aetherteam.aether.entities.mounts.moa.EntityMoa;
import net.aetherteam.aether.entities.projectile.EntityContinuumBomb;
import net.aetherteam.aether.entities.projectile.EntityDaggerfrostSnowball;
import net.aetherteam.aether.entities.projectile.EntityDartEnchanted;
import net.aetherteam.aether.entities.projectile.EntityDartGolden;
import net.aetherteam.aether.entities.projectile.EntityDartPhoenix;
import net.aetherteam.aether.entities.projectile.EntityDartPoison;
import net.aetherteam.aether.entities.projectile.EntityHammerProjectile;
import net.aetherteam.aether.entities.projectile.EntityProjectileSentry;
import net.aetherteam.aether.entities.projectile.EntityTempestBall;
import net.aetherteam.aether.entities.spawning.AetherDayMob;
import net.aetherteam.aether.entities.spawning.AetherNightMob;
import net.aetherteam.aether.entities.spawning.AnimalChances;
import net.aetherteam.aether.entities.spawning.EnemyChances;
import net.aetherteam.aether.entities.util.AetherSpawnEggInfo;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;

public class AetherEntities {
    public static HashMap<Integer, AetherSpawnEggInfo> entityEggs = new LinkedHashMap<Integer, AetherSpawnEggInfo>();
    public static Map<String, Class<? extends Entity>> stringToClassMapping = new HashMap<String, Class<? extends Entity>>();
    public static Map<Class<? extends Entity>, String> classToStringMapping = new HashMap<Class<? extends Entity>, String>();
    public static Map<Integer, Class<? extends Entity>> IDtoClassMapping = new HashMap<Integer, Class<? extends Entity>>();

    public static void init() {
        AetherEntities.registerEntity(EntityPhyg.class, "phyg", 2, 0xCCFFFF, 0xFF9999);
        AetherEntities.registerEntity(EntityAerbunny.class, "aerbunny", 3, 0xCCFFFF, 26316);
        AetherEntities.registerEntity(EntitySheepuff.class, "sheepuff", 4, 0xCCFFFF, 0xCCCCFF);
        AetherEntities.registerEntity(EntityCockatrice.class, "cockatrice", 5, 0xCCFFFF, 5156188);
        AetherEntities.registerEntity(EntityMoa.class, "moa", 6, 0xCCFFFF, 0x33CCCC);
        AetherEntities.registerEntity(EntityFlyingCow.class, "flyingCow", 7, 0xCCFFFF, 15784766);
        AetherEntities.registerEntity(EntityAechorPlant.class, "aechorPlant", 8, 0xCCFFFF, 13144035);
        AetherEntities.registerEntity(EntitySwet.class, "swet", 9, 0xCCFFFF, 4107504);
        AetherEntities.registerEntity(EntityCarrionSprout.class, "carrionSprout", 10, 0xCCFFFF, 6130619);
        AetherEntities.registerEntity(EntityTempest.class, "tempest", 11, 0xCCFFFF, 3950156);
        AetherEntities.registerEntity(EntityZephyr.class, "zephyr", 12, 0xCCFFFF, 12105131);
        AetherEntities.registerEntity(EntityZephyroo.class, "zephyroo", 13, 0xCCFFFF, 8824009);
        AetherEntities.registerEntity(EntitySentry.class, "sentry", 14, 9541788, 0x4F99F9);
        AetherEntities.registerEntity(EntityBattleSentry.class, "battleSentry", 15, 9541788, 2548224);
        AetherEntities.registerEntity(EntityMimic.class, "mimic", 16, 9541788, 7566423);
        AetherEntities.registerEntity(EntityTrackingGolem.class, "trackingGolem", 17, 9541788, 14093084);
        AetherEntities.registerEntity(EntitySentryGolem.class, "sentryGolem", 18, 9541788, 776057);
        AetherEntities.registerEntity(EntitySentryGuardian.class, "sentryGuardian", 19, 3294281, 2913232);
        AetherEntities.registerEntity(EntitySliderHostMimic.class, "sliderHostMimic", 20, 3294281, 13644844);
        AetherEntities.registerEntity(EntitySlider.class, "slider", 21, 3294281, 0x4F99F9);
        AetherEntities.registerEntity(EntityLabyrinthEye.class, "labyrinthEye", 22, 3294281, 2906832);
        AetherEntities.registerEntity(EntityFloatingBlock.class, "floatingBlock", 23, 160, 20, true);
        AetherEntities.registerEntity(EntityPoisonNeedle.class, "poisonNeedle", 24, 64, 20, true);
        AetherEntities.registerEntity(EntityDartGolden.class, "goldenDart", 25, 64, 20, true);
        AetherEntities.registerEntity(EntityDartEnchanted.class, "enchantedDart", 26, 64, 20, true);
        AetherEntities.registerEntity(EntityDartPoison.class, "poisonDart", 27, 64, 20, true);
        AetherEntities.registerEntity(EntityDartPhoenix.class, "phoenixDart", 28, 64, 20, true);
        AetherEntities.registerEntity(EntityLightningKnife.class, "lightningKnife", 29, 64, 20, true);
        AetherEntities.registerEntity(EntityHammerProjectile.class, "hammerProjectile", 30, 64, 20, true);
        AetherEntities.registerEntity(EntityTNTPresent.class, "presentTNT", 31);
        AetherEntities.registerEntity(EntityAetherLightning.class, "aetherLightning", 32);
        AetherEntities.registerEntity(EntityHostEye.class, "hostEye", 33);
        AetherEntities.registerEntity(EntityProjectileSentry.class, "sentryProjectile", 34, 64, 20, true);
        AetherEntities.registerEntity(EntityAetherCoin.class, "aetherCoin", 35, 160, 20, true);
        AetherEntities.registerEntity(EntityCog.class, "looseCog", 36, 64, 20, true);
        AetherEntities.registerEntity(EntityLabyrinthEye.class, "labyrinthEye", 37);
        AetherEntities.registerEntity(EntityTempestBall.class, "tempestBall", 38, 64, 20, true);
        AetherEntities.registerEntity(EntityFakeItem.class, "fakeItem", 39, 64, 20, true);
        AetherEntities.registerEntity(EntityRewardItemStack.class, "rewardItem", 40, 64, 20, true);
        AetherEntities.registerEntity(EntitySoaringWisp.class, "soaringWisp", 41);
        AetherEntities.registerEntity(EntityFleetingWisp.class, "fleetingWisp", 42);
        AetherEntities.registerEntity(EntityEtherealWisp.class, "etherealWisp", 43);
        AetherEntities.registerEntity(EntityShadeOfArkenzus.class, "shadeOfArkenzus", 44);
        AetherEntities.registerEntity(EntityFangrin.class, "fangrin", 45);
        AetherEntities.registerEntity(EntityPinkSwet.class, "babyPinkSwet", 46);
        AetherEntities.registerEntity(EntityKraisith.class, "kraisith", 47);
        AetherEntities.registerEntity(EntityNexSpirit.class, "nexSpirit", 48);
        AetherEntities.registerEntity(EntityParachute.class, "parachute", 49);
        AetherEntities.registerEntity(EntityDaggerfrostSnowball.class, "daggerfrostSnowball", 50, 64, 20, true);
        AetherEntities.registerEntity(EntityContinuumBomb.class, "continuumBomb", 51, 64, 20, true);
        AetherEntities.registerEntity(EntityFrostpineTotem.class, "frostpineTotem", 52);
        AetherEntities.registerEntity(EntityFrostboundSprite.class, "frostboundSprite", 53);
        AetherEntities.registerSpawningRules();
    }

    private static void registerSpawningRules() {
        SpawningCore.registerBlacklistedBlock((Block)AetherBlocks.Aercloud);
        SpawnManager animals = SpawningCore.createAndRegisterSpawnManager((int)Aether.getDimensionID(), (SpawnSettings)new AnimalChances());
        AetherEntities.registerEntry(animals, EntityPhyg.class, AetherConfig.phygConfig);
        AetherEntities.registerEntry(animals, EntitySheepuff.class, AetherConfig.sheepuffConfig);
        AetherEntities.registerEntry(animals, EntityAerbunny.class, AetherConfig.aerbunnyConfig);
        AetherEntities.registerEntry(animals, EntityZephyroo.class, AetherConfig.zephyrooConfig);
        AetherEntities.registerEntry(animals, EntityFlyingCow.class, AetherConfig.flyingCowConfig);
        AetherEntities.registerEntry(animals, EntityCarrionSprout.class, AetherConfig.carrionSproutConfig);
        AetherEntities.registerEntry(animals, EntityMoa.class, AetherConfig.moaConfig);
        SpawnManager enemies = SpawningCore.createAndRegisterSpawnManager((int)Aether.getDimensionID(), (SpawnSettings)new EnemyChances());
        AetherConfig.SpawningConfig config = AetherConfig.zephyrConfig;
        enemies.registerPerTickEntry((SpawnEntry)new AetherDayMob(EntityZephyr.class, config.minGroupSize(), config.maxGroupSize(), config.avgAmountOfGroups(), false));
        config = AetherConfig.cockatriceConfig;
        enemies.registerPerTickEntry((SpawnEntry)new AetherNightMob(EntityCockatrice.class, config.minGroupSize(), config.maxGroupSize(), config.avgAmountOfGroups()));
        config = AetherConfig.tempestConfig;
        enemies.registerPerTickEntry((SpawnEntry)new AetherNightMob(EntityTempest.class, config.minGroupSize(), config.maxGroupSize(), config.avgAmountOfGroups()));
        AetherEntities.registerEntry(enemies, EntityAechorPlant.class, AetherConfig.aechorPlantConfig);
        AetherEntities.registerEntry(enemies, EntitySwet.class, AetherConfig.swetConfig);
        SpawnCondition genericCondition = new SpawnCondition(){

            public boolean canSpawn(int areaSize, ScheduledSpawn scheduledSpawn, Entity entity) {
                return true;
            }
        };
        animals.registerSpawnCondition(genericCondition);
        enemies.registerSpawnCondition(genericCondition);
    }

    private static void registerEntry(SpawnManager spawnManager, Class<? extends EntityLiving> clazz, AetherConfig.SpawningConfig config) {
        spawnManager.registerEntry(new SpawnEntry(clazz, config.minGroupSize(), config.maxGroupSize(), config.avgAmountOfGroups()));
    }

    private static void registerEntity(Class<? extends Entity> clazz, String name, int id) {
        AetherEntities.registerEntity(clazz, name, id, 80, 3, true);
    }

    private static void registerEntity(Class<? extends Entity> clazz, String name, int id, int bgEggColor, int fgEggColor) {
        AetherEntities.registerEntity(clazz, name, id, 80, 3, false, bgEggColor, fgEggColor);
    }

    private static void registerEntity(Class<? extends Entity> clazz, String name, int id, int trackingRange, int updateFrequency, boolean sendVelocityUpdates, int bgEggColor, int fgEggColor) {
        AetherEntities.registerEntity(clazz, name, id, trackingRange, updateFrequency, sendVelocityUpdates);
        entityEggs.put(id, new AetherSpawnEggInfo(id, bgEggColor, fgEggColor));
        IDtoClassMapping.put(id, clazz);
        classToStringMapping.put(clazz, name);
        stringToClassMapping.put(name, clazz);
    }

    private static void registerEntity(Class<? extends Entity> clazz, String name, int id, int trackingRange, int updateFrequency, boolean sendVelocityUpdates) {
        EntityRegistry.registerModEntity(clazz, (String)name, (int)id, (Object)Aether.getInstance(), (int)trackingRange, (int)updateFrequency, (boolean)sendVelocityUpdates);
    }

    public static Class getClassFromID(int id) {
        return IDtoClassMapping.get(id);
    }

    public static String getStringFromID(int id) {
        Class clazz = AetherEntities.getClassFromID(id);
        return clazz != null ? classToStringMapping.get(clazz) : null;
    }
}

