/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.aetherteam.aether.entities.EntityAetherAnimal;
import net.aetherteam.aether.entities.ai.AIEntityEatAetherGrass;
import net.aetherteam.aether.items.AetherItems;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntitySheepuff
extends EntityAetherAnimal {
    private AIEntityEatAetherGrass aiEatGrass = new AIEntityEatAetherGrass((EntityLiving)this);
    private int sheepTimer;

    public EntitySheepuff(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.3f);
        this.setFleeceColor(EntitySheepuff.getRandomFleeceColor(this.field_70146_Z));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_70606_j(20.0f);
        float f = 0.23f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, (double)0.38f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, (double)f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.25, AetherItems.BlueBerry, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.25, AetherItems.Orange, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 0.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiEatGrass);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, (double)f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.aiEatGrass.getEatGrassTick();
        super.func_70619_bc();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    protected void func_70628_a(boolean var1, int var2) {
        if (!this.getSheared()) {
            this.func_70099_a(new ItemStack(Blocks.field_150325_L, 1 + this.field_70146_Z.nextInt(2), this.getFleeceColor()), 0.0f);
        }
    }

    public boolean isWheat(ItemStack itemstack) {
        return itemstack.func_77973_b() == Items.field_151015_O;
    }

    @Override
    public boolean func_70877_b(ItemStack itemstack) {
        return itemstack.func_77973_b() == AetherItems.BlueBerry || itemstack.func_77973_b() == AetherItems.Orange;
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack != null && (this.isWheat(itemstack) || this.func_70877_b(itemstack) || itemstack.func_77973_b() == Items.field_151057_cb || itemstack.func_77973_b() == Items.field_151063_bx)) {
            return super.func_70085_c(entityplayer);
        }
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151097_aZ && !this.getSheared()) {
            if (!this.field_70170_p.field_72995_K) {
                int i;
                if (this.getPuffed()) {
                    this.setPuffed(false);
                    this.setSheared(true);
                    i = 2 + this.field_70146_Z.nextInt(3);
                    for (int j = 0; j < i; ++j) {
                        EntityItem entityitem = this.func_70099_a(new ItemStack(Blocks.field_150325_L, 1, this.getFleeceColor()), 1.0f);
                        entityitem.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.05f);
                        entityitem.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                        entityitem.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                    }
                } else {
                    this.setSheared(true);
                    i = 2 + this.field_70146_Z.nextInt(3);
                    for (int j = 0; j < i; ++j) {
                        EntityItem entityitem = this.func_70099_a(new ItemStack(Blocks.field_150325_L, 1, this.getFleeceColor()), 1.0f);
                        entityitem.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.05f);
                        entityitem.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                        entityitem.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                    }
                }
            }
            itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
        }
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151100_aR && !this.getSheared()) {
            int colour = BlockColored.func_150032_b((int)itemstack.func_77960_j());
            if (this.getFleeceColor() != colour) {
                if (this.getPuffed() && itemstack.field_77994_a >= 2) {
                    this.setFleeceColor(colour);
                    itemstack.field_77994_a -= 2;
                } else if (!this.getPuffed()) {
                    this.setFleeceColor(colour);
                    --itemstack.field_77994_a;
                }
            }
        }
        return false;
    }

    protected void func_70664_aZ() {
        if (this.getPuffed()) {
            this.field_70181_x = 0.8;
            this.field_70159_w += this.field_70146_Z.nextGaussian() * 0.5;
            this.field_70179_y += this.field_70146_Z.nextGaussian() * 0.5;
        } else {
            this.field_70181_x = 0.42f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(par1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70894_j(float par1) {
        return this.sheepTimer <= 0 ? 0.0f : (this.sheepTimer >= 4 && this.sheepTimer <= 36 ? 1.0f : (this.sheepTimer < 4 ? ((float)this.sheepTimer - par1) / 4.0f : -((float)(this.sheepTimer - 40) - par1) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70890_k(float par1) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f1 = ((float)(this.sheepTimer - 4) - par1) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f1 * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A / 57.295776f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        if (this.getPuffed()) {
            this.field_70143_R = 0.0f;
            if (this.field_70181_x < -0.05) {
                this.field_70181_x = -0.05;
            }
        }
        if (this.field_70122_E) {
            this.setPuffed(false);
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Sheared", this.getSheared());
        nbttagcompound.func_74757_a("Puffed", this.getPuffed());
        nbttagcompound.func_74774_a("Color", (byte)this.getFleeceColor());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setSheared(nbttagcompound.func_74767_n("Sheared"));
        this.setPuffed(nbttagcompound.func_74767_n("Puffed"));
        this.setFleeceColor(nbttagcompound.func_74771_c("Color"));
    }

    public void func_70615_aA() {
        if (this.func_70631_g_()) {
            int i = this.func_70874_b() + 1200;
            if (i > 0) {
                i = 0;
            }
            this.func_70873_a(i);
        } else {
            this.setSheared(false);
            this.setPuffed(true);
            this.func_70664_aZ();
        }
    }

    protected String func_70639_aQ() {
        return "mob.sheep.say";
    }

    protected String func_70621_aR() {
        return "mob.sheep.say";
    }

    protected String func_70673_aS() {
        return "mob.sheep.say";
    }

    public int getFleeceColor() {
        return this.field_70180_af.func_75683_a(16) & 0xF;
    }

    public void setFleeceColor(int i) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xF0 | i & 0xF)));
    }

    public boolean getSheared() {
        return (this.field_70180_af.func_75683_a(16) & 0x10) != 0;
    }

    public void setSheared(boolean flag) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        if (flag) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 | 0x10)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xFFFFFFEF)));
        }
    }

    public boolean getPuffed() {
        return (this.field_70180_af.func_75683_a(16) & 0x20) != 0;
    }

    public void setPuffed(boolean flag) {
        byte byte0 = this.field_70180_af.func_75683_a(16);
        if (flag) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 | 0x20)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(byte0 & 0xFFFFFFDF)));
        }
    }

    public static int getRandomFleeceColor(Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return 3;
        }
        if (i < 10) {
            return 9;
        }
        if (i < 15) {
            return 5;
        }
        if (i < 18) {
            return 6;
        }
        return random.nextInt(500) != 0 ? 0 : 10;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return new EntitySheepuff(this.field_70170_p);
    }

    @Override
    public int spawnEggID() {
        return 4;
    }
}

