/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.entities.mounts;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.aetherteam.aether.achievements.AetherAchievements;
import net.aetherteam.aether.entities.util.EntitySaddleMount;
import net.aetherteam.aether.items.AetherItems;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityPhyg
extends EntitySaddleMount {
    @SideOnly(value=Side.CLIENT)
    public float wingFold;
    @SideOnly(value=Side.CLIENT)
    public float wingAngle;
    public int maxJumps;
    public int jumpsRemaining;

    public EntityPhyg(World world) {
        super(world);
        this.func_70661_as().func_75491_a(true);
        this.canJumpMidAir = true;
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, AetherItems.BlueBerry, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, AetherItems.Orange, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.func_70105_a(0.9f, 1.3f);
        this.jumpsRemaining = 0;
        this.maxJumps = 1;
        this.field_70138_W = 1.0f;
        this.field_70158_ak = true;
        this.func_70606_j(10.0f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.tickAnimation();
        }
        this.func_70069_a(0.0f);
        this.field_70143_R = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void tickAnimation() {
        float aimingForFold;
        boolean blockBeneath;
        boolean bl = blockBeneath = !this.field_70170_p.func_147437_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
        if (blockBeneath) {
            this.wingAngle *= 0.8f;
            aimingForFold = 0.1f;
        } else {
            aimingForFold = 1.0f;
        }
        if (this.field_70153_n instanceof EntityPlayer && this.isSaddled()) {
            ((EntityPlayer)this.field_70153_n).func_71029_a((StatBase)AetherAchievements.flyingPig);
        }
        this.wingAngle = this.wingFold * (float)Math.sin((float)this.field_70173_aa / 31.830988f);
        this.wingFold += (aimingForFold - this.wingFold) / 5.0f;
    }

    protected String func_70673_aS() {
        return "mob.pig.death";
    }

    protected String func_70621_aR() {
        return "mob.pig.say";
    }

    protected String func_70639_aQ() {
        return "mob.pig.say";
    }

    public double func_70042_X() {
        return 0.75;
    }

    @Override
    public float getMountedMoveSpeed() {
        return 0.3f;
    }

    protected void func_70664_aZ() {
        if (this.field_70153_n == null) {
            super.func_70664_aZ();
        }
    }

    protected Item getDropItemId() {
        return this.func_70027_ad() ? Items.field_151157_am : Items.field_151147_al;
    }

    @Override
    protected void func_70628_a(boolean par1, int par2) {
        int j = this.field_70146_Z.nextInt(3) + 1 + this.field_70146_Z.nextInt(1 + par2);
        for (int k = 0; k < j; ++k) {
            if (this.func_70027_ad()) {
                this.func_145779_a(Items.field_151157_am, 1);
                continue;
            }
            this.func_145779_a(Items.field_151147_al, 1);
        }
        if (this.isSaddled()) {
            this.func_145779_a(Items.field_151141_av, 1);
        }
    }

    protected void func_70069_a(float f) {
        boolean blockBeneath;
        boolean bl = blockBeneath = !this.field_70170_p.func_147437_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
        if (!this.field_70122_E && !this.field_70703_bu) {
            if (this.field_70181_x < 0.0 && !this.isRiderSneaking()) {
                this.field_70181_x *= 0.6;
            }
            if (blockBeneath && !this.field_70170_p.field_72995_K) {
                this.jumpsRemaining = this.maxJumps;
            }
        }
    }

    @Override
    protected double getMountJumpStrength() {
        return 5.0;
    }

    @Override
    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.field_70170_p.func_72956_a((Entity)this, "mob.pig.step", 0.15f, 1.0f);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.maxJumps = nbttagcompound.func_74765_d("Jumps");
        this.jumpsRemaining = nbttagcompound.func_74765_d("Remaining");
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return new EntityPhyg(this.field_70170_p);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74777_a("Jumps", (short)this.maxJumps);
        nbttagcompound.func_74777_a("Remaining", (short)this.jumpsRemaining);
    }

    @Override
    public int spawnEggID() {
        return 2;
    }
}

