/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.entities.projectile;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.aetherteam.aether.entities.util.CustomDamageSource;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public abstract class EntityProjectileBase
extends Entity {
    public float speed;
    public float slowdown;
    public float curvature;
    public float precision;
    public float hitBox;
    public int dmg;
    public ItemStack item;
    public int ttlInGround;
    public int xTile = -1;
    public int yTile = -1;
    public int zTile = -1;
    public Block inTile;
    public int inData;
    public boolean inGround;
    public int arrowShake;
    public EntityLivingBase shooter;
    public int ticksInGround;
    public int ticksFlying;
    public boolean shotByPlayer;
    public int canBePickedUp;

    public EntityProjectileBase(World world) {
        super(world);
    }

    public EntityProjectileBase(World world, double d, double d1, double d2) {
        this(world);
        this.func_70080_a(d, d1 - 1.0, d2, this.field_70177_z, this.field_70125_A);
    }

    public EntityProjectileBase(World world, EntityLivingBase entityliving) {
        this(world);
        this.shooter = entityliving;
        this.shotByPlayer = entityliving instanceof EntityPlayer;
        this.func_70012_b(entityliving.field_70165_t, entityliving.field_70163_u + (double)entityliving.func_70047_e(), entityliving.field_70161_v, entityliving.field_70177_z, entityliving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.setArrowHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.speed, this.precision);
    }

    protected void func_70088_a() {
        this.xTile = -1;
        this.yTile = -1;
        this.zTile = -1;
        this.inTile = Blocks.field_150350_a;
        this.inGround = false;
        this.arrowShake = 0;
        this.ticksFlying = 0;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70129_M = 0.0f;
        this.hitBox = 0.3f;
        this.speed = 1.0f;
        this.slowdown = 0.99f;
        this.curvature = 0.03f;
        this.dmg = 4;
        this.precision = 1.0f;
        this.ttlInGround = 1200;
        this.item = null;
    }

    public void func_70106_y() {
        this.shooter = null;
        super.func_70106_y();
    }

    public void setArrowHeading(double d, double d1, double d2, float f, float f1) {
        float f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        d += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f1;
        d1 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f1;
        d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)f1;
        this.field_70159_w = d *= (double)f;
        this.field_70181_x = d1 *= (double)f;
        this.field_70179_y = d2 *= (double)f;
        float f3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(d * d + d2 * d2));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d1, f) * 180.0 / 3.1415927410125732);
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70071_h_() {
        Block var16;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var1) * 180.0 / Math.PI);
        }
        if ((var16 = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile)) != Blocks.field_150350_a) {
            var16.func_149719_a((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB var2 = var16.func_149668_a(this.field_70170_p, this.xTile, this.yTile, this.zTile);
            if (var2 != null && var2.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.inGround = true;
            }
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            Block var18 = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
            int var19 = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
            if (var18 == this.inTile && var19 == this.inData) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200 && !this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                }
            } else {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksFlying = 0;
            }
        } else {
            ++this.ticksFlying;
            Vec3 var17 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 var3 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition var4 = this.field_70170_p.func_72901_a(var17, var3, true);
            var17 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            var3 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (var4 != null) {
                var3 = Vec3.func_72443_a((double)var4.field_72307_f.field_72450_a, (double)var4.field_72307_f.field_72448_b, (double)var4.field_72307_f.field_72449_c);
            }
            Entity var5 = null;
            List var6 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double var7 = 0.0;
            for (Entity var10 : var6) {
                double var14;
                float var11;
                AxisAlignedBB var12;
                MovingObjectPosition var13;
                if (!var10.func_70067_L() || var10 == this.shooter && this.ticksFlying < 5 || (var13 = (var12 = var10.field_70121_D.func_72314_b((double)(var11 = 0.3f), (double)var11, (double)var11)).func_72327_a(var17, var3)) == null || !((var14 = var17.func_72438_d(var13.field_72307_f)) < var7) && var7 != 0.0) continue;
                var5 = var10;
                var7 = var14;
            }
            if (var5 != null) {
                var4 = new MovingObjectPosition(var5);
            }
            if (var4 != null) {
                if (var4.field_72308_g != null) {
                    if (var4.field_72308_g instanceof EntityEnderman) {
                        var4.field_72313_a = MovingObjectPosition.MovingObjectType.MISS;
                        EntityEnderman enderman = (EntityEnderman)var4.field_72308_g;
                        double d0 = enderman.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
                        double d1 = enderman.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
                        double d2 = enderman.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
                        this.teleportEndermanTo(enderman, d0, d1, d2);
                        this.func_70106_y();
                    }
                    if (this.shooter != null && var4.field_72308_g == this.shooter) {
                        return;
                    }
                    DamageSource damageSource = this.shooter == null ? new CustomDamageSource("dart", var4.field_72308_g, var4.field_72308_g).setDeathSuffix(" died covered in darts.").func_76349_b() : new CustomDamageSource("dart", var4.field_72308_g, (Entity)this.shooter).setDeathSuffix(" died covered in " + this.shooter.func_70005_c_() + "'s darts.").func_76349_b();
                    if (!(var4.field_72308_g instanceof EntityEnderman) && this.onHitTarget(var4.field_72308_g) && (this.dmg <= 0 || var4.field_72308_g.func_70097_a(damageSource, (float)this.dmg))) {
                        if (this.func_70027_ad()) {
                            var4.field_72308_g.func_70015_d(5);
                        }
                        this.field_70170_p.func_72956_a((Entity)this, "random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                        if (!this.field_70170_p.field_72995_K) {
                            this.func_70106_y();
                        }
                    }
                } else if (this.onHitBlock(var4)) {
                    this.xTile = var4.field_72311_b;
                    this.yTile = var4.field_72312_c;
                    this.zTile = var4.field_72309_d;
                    this.inTile = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
                    this.inData = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
                    this.field_70159_w = (float)(var4.field_72307_f.field_72450_a - this.field_70165_t);
                    this.field_70181_x = (float)(var4.field_72307_f.field_72448_b - this.field_70163_u);
                    this.field_70179_y = (float)(var4.field_72307_f.field_72449_c - this.field_70161_v);
                    float var20 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    this.field_70165_t -= this.field_70159_w / (double)var20 * (double)0.05f;
                    this.field_70163_u -= this.field_70181_x / (double)var20 * (double)0.05f;
                    this.field_70161_v -= this.field_70179_y / (double)var20 * (double)0.05f;
                    this.field_70170_p.func_72956_a((Entity)this, "random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    this.inGround = true;
                    this.arrowShake = 7;
                }
            }
            this.handleMotionUpdate();
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.1415927410125732);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / 3.1415927410125732);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            if (this.func_70090_H()) {
                for (int var26 = 0; var26 < 4; ++var26) {
                    float var27 = 0.25f;
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)var27, this.field_70163_u - this.field_70181_x * (double)var27, this.field_70161_v - this.field_70179_y * (double)var27, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            this.handleMotionUpdate();
            this.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.func_145775_I();
        }
    }

    public void handleMotionUpdate() {
        float slow = this.slowdown;
        if (this.func_70072_I()) {
            for (int k = 0; k < 4; ++k) {
                float f6 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f6, this.field_70163_u - this.field_70181_x * (double)f6, this.field_70161_v - this.field_70179_y * (double)f6, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            slow *= 0.8f;
        }
        this.field_70159_w *= (double)slow;
        this.field_70181_x *= (double)slow;
        this.field_70179_y *= (double)slow;
        this.field_70181_x -= (double)this.curvature;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74777_a("xTile", (short)this.xTile);
        nbttagcompound.func_74777_a("yTile", (short)this.yTile);
        nbttagcompound.func_74777_a("zTile", (short)this.zTile);
        nbttagcompound.func_74768_a("inTile", (int)((byte)Block.func_149682_b((Block)this.inTile)));
        nbttagcompound.func_74774_a("inData", (byte)this.inData);
        nbttagcompound.func_74774_a("shake", (byte)this.arrowShake);
        nbttagcompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        nbttagcompound.func_74757_a("player", this.shotByPlayer);
        nbttagcompound.func_74774_a("pickup", (byte)this.canBePickedUp);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        this.xTile = nbttagcompound.func_74765_d("xTile");
        this.yTile = nbttagcompound.func_74765_d("yTile");
        this.zTile = nbttagcompound.func_74765_d("zTile");
        this.inTile = Block.func_149729_e((int)nbttagcompound.func_74762_e("inTile"));
        this.inData = nbttagcompound.func_74771_c("inData") & 0xFF;
        this.arrowShake = nbttagcompound.func_74771_c("shake") & 0xFF;
        this.inGround = nbttagcompound.func_74771_c("inGround") == 1;
        this.shotByPlayer = nbttagcompound.func_74767_n("player");
        this.canBePickedUp = nbttagcompound.func_74771_c("pickup");
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.field_70170_p.field_72995_K && this.inGround && this.arrowShake <= 0) {
            boolean var2;
            boolean bl = var2 = this.canBePickedUp == 1 || this.canBePickedUp == 2 && par1EntityPlayer.field_71075_bZ.field_75098_d;
            if (this.canBePickedUp == 1 && !par1EntityPlayer.field_71071_by.func_70441_a(this.item.func_77946_l())) {
                var2 = false;
            }
            if (var2) {
                this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                par1EntityPlayer.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    public boolean canBeShot(Entity ent) {
        if (ent instanceof EntityLivingBase && ent == this.shooter) {
            return false;
        }
        return ent.func_70067_L() && (!(ent instanceof EntityLivingBase) || ((EntityLivingBase)ent).field_70725_aQ <= 0);
    }

    public boolean onHitTarget(Entity target) {
        this.field_70170_p.func_72956_a((Entity)this, "random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        return true;
    }

    public boolean onHitBlock(MovingObjectPosition mop) {
        return this.onHitBlock();
    }

    public boolean onHitBlock() {
        this.field_70170_p.func_72956_a((Entity)this, "random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        return true;
    }

    public float func_70053_R() {
        return 0.0f;
    }

    protected boolean teleportEndermanTo(EntityEnderman enderman, double x, double y, double z) {
        int k;
        int j;
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)enderman, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = enderman.field_70165_t;
        double d4 = enderman.field_70163_u;
        double d5 = enderman.field_70161_v;
        enderman.field_70165_t = event.targetX;
        enderman.field_70163_u = event.targetY;
        enderman.field_70161_v = event.targetZ;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)enderman.field_70165_t);
        if (enderman.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)enderman.field_70163_u), k = MathHelper.func_76128_c((double)enderman.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = enderman.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                enderman.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                enderman.func_70107_b(enderman.field_70165_t, enderman.field_70163_u, enderman.field_70161_v);
                if (enderman.field_70170_p.func_72945_a((Entity)enderman, enderman.field_70121_D).isEmpty() && !enderman.field_70170_p.func_72953_d(enderman.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            enderman.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)enderman.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)enderman.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)enderman.field_70130_N * 2.0;
            enderman.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        enderman.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        enderman.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }
}

