/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.containers.SlotAccessory;
import net.aetherteam.aether.items.AetherItems;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ItemAccessory
extends Item {
    protected final AccessoryType accessoryType;
    public ResourceLocation texture;

    protected ItemAccessory(AccessoryType accessoryType) {
        this.accessoryType = accessoryType;
        this.func_77656_e(accessoryType.getMaxDamage());
        this.field_77777_bU = 1;
        this.texture = new ResourceLocation("aether", "textures/armor/Accessories.png");
    }

    public ItemAccessory(ResourceLocation path, AccessoryType accessoryType) {
        this(accessoryType);
        this.texture = path;
    }

    public void func_94581_a(IIconRegister iconReg) {
        AccessoryType.RING.setIcon(iconReg.func_94245_a("aether:Ring Slot"));
        AccessoryType.PENDANT.setIcon(iconReg.func_94245_a("aether:Pendant Slot"));
        AccessoryType.COMPANION.setIcon(iconReg.func_94245_a("aether:Companion Slot"));
        AccessoryType.MISC.setIcon(iconReg.func_94245_a("aether:Misc Slot"));
        AccessoryType.SHIELD.setIcon(iconReg.func_94245_a("aether:Shield Slot"));
        AccessoryType.GLOVE.setIcon(iconReg.func_94245_a("aether:Glove Slot"));
        super.func_94581_a(iconReg);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        PlayerAether playerAether = PlayerAether.get(player);
        if (playerAether.accessories.setInventoryAccessory(stack.func_77946_l())) {
            stack.field_77994_a = 0;
        }
        return stack;
    }

    public void onEquip(ItemStack stack, EntityPlayer player) {
    }

    public void onUnequip(ItemStack stack, EntityPlayer player) {
    }

    public AccessoryType getType() {
        return this.accessoryType;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (this == AetherItems.DaggerfrostLocket) {
            return 11786751;
        }
        if (this == AetherItems.LuckyBell) {
            return 0xFFFF4D;
        }
        return super.func_82790_a(stack, pass);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List infoList, boolean par4) {
        if (this == AetherItems.RegenerationStone) {
            infoList.add("\u00a7cRegenerates Health");
        }
        if (this == AetherItems.IceRing || this == AetherItems.IcePendant) {
            infoList.add("\u00a7bSolidifies Lava and Water");
        }
        if (this == AetherItems.CandyRing) {
            infoList.add(EnumChatFormatting.GOLD + "Removes All Hunger");
        }
        if (this == AetherItems.BoneRing) {
            infoList.add(EnumChatFormatting.BLUE + "+3 Attack Damage");
        }
        if (this == AetherItems.SkyrootRing) {
            infoList.add(EnumChatFormatting.DARK_GREEN + "+15% Chance: " + EnumChatFormatting.GRAY + "Double Drops");
            infoList.add("\u00a73Affects Mobs Only");
        }
        if (this == AetherItems.ZaniteRing || this == AetherItems.ZanitePendant) {
            infoList.add("\u00a7dIncreases Mining Speed");
        }
        if (this == AetherItems.IronBubble) {
            infoList.add("\u00a79Water Breathing");
        }
        if (this == AetherItems.PhoenixGloves) {
            infoList.add("\u00a77\u00a7oWearing Full Set:");
            infoList.add("\u00a79Fire Resistant");
        }
        if (this == AetherItems.NeptuneGloves) {
            infoList.add("\u00a77\u00a7oWearing Full Set:");
            infoList.add("\u00a79Walk in Water");
        }
        if (this == AetherItems.ValkyrieGloves) {
            infoList.add("\u00a77\u00a7oWearing Full Set:");
            infoList.add("\u00a79Grows Wings");
        }
        if (this == AetherItems.ObsidianGloves) {
            infoList.add("\u00a77\u00a7oWearing Full Set:");
            infoList.add("\u00a79Extreme Protection");
            infoList.add("\u00a74Slow Movement");
        }
        if (this == AetherItems.GravititeGloves) {
            infoList.add("\u00a77\u00a7oWearing Full Set:");
            infoList.add("\u00a79Super Jump");
            infoList.add("\u00a73Use: \u00a7rShift + Space Bar");
        }
        if (this == AetherItems.MouseEarCap) {
            infoList.add("\u00a7eCosmetic");
            infoList.add("\u00a76Dyable");
        }
        if (this == AetherItems.IronRing || this == AetherItems.GoldenRing || this == AetherItems.IronPendant || this == AetherItems.GoldenPendant) {
            infoList.add("\u00a7eCosmetic");
        }
        if (this == AetherItems.LuckyBell) {
            if (Aether.enableChristmasEvents) {
                infoList.add(EnumChatFormatting.GOLD + "Increases Present Drop Chance");
            } else {
                infoList.add(EnumChatFormatting.GOLD + "Mobs Drop Presents");
            }
        }
        if (this == AetherItems.DaggerfrostLocket) {
            infoList.add("\u00a79Snowballs Cause Damage");
        }
        infoList.add("\u00a77\u00a7o" + this.getType().getDisplayName());
    }

    public static enum AccessoryType {
        RING("Ring", 11, 3),
        PENDANT("Neckwear", 16, 7),
        COMPANION("Companion", 15, 5),
        SHIELD("Shield", 13, 0),
        GLOVE("Gloves", 10, 0),
        MISC("Miscellaneous", 10, 0);

        private int maxDamage;
        private int damagedReduced;
        private IIcon icon;
        private String displayName;

        private AccessoryType(String displayName, int maxDamage, int damageReduced) {
            this.displayName = displayName;
            this.maxDamage = maxDamage;
            this.damagedReduced = damageReduced;
        }

        public int getMaxDamage() {
            return this.maxDamage;
        }

        public int getDamageReduced() {
            return this.damagedReduced;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isSlotValid(Slot slot) {
            SlotAccessory accessorySlot;
            return slot instanceof SlotAccessory && (accessorySlot = (SlotAccessory)slot).getAccessoryType() == this;
        }

        public IIcon getIcon() {
            return this.icon;
        }

        public void setIcon(IIcon icon) {
            this.icon = icon;
        }
    }
}

