/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.items;

import java.util.List;
import net.aetherteam.aether.achievements.AetherAchievements;
import net.aetherteam.aether.entities.companion.EntityCompanion;
import net.aetherteam.aether.items.ItemAccessory;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemCompanionSummoner
extends ItemAccessory {
    public final Class<? extends EntityCompanion> clazz;
    public EntityCompanion companion;

    public ItemCompanionSummoner(Class<? extends EntityCompanion> clazz) {
        super(ItemAccessory.AccessoryType.COMPANION);
        this.clazz = clazz;
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List infoList, boolean par4) {
        EntityCompanion companion;
        NBTTagCompound tag = stack.func_77978_p();
        PlayerAether hook = PlayerAether.get(player);
        if (this.companion == null) {
            World world = player.field_70170_p;
            this.companion = companion = this.createCompanion(world);
        }
        if (this.companion != null) {
            infoList.add(this.companion.getEffectDescription());
        }
        if (tag != null) {
            int respawnTime = tag.func_74762_e("cooldown");
            companion = hook.accessories.getStackFromID(stack.func_77973_b());
            if (companion == stack && !tag.func_74767_n("isSpawned")) {
                infoList.add("\u00a74Ready in " + respawnTime / 20);
            }
        }
        super.func_77624_a(stack, player, infoList, par4);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            tag.func_74768_a("cooldown", 600);
            tag.func_74757_a("isEquipped", false);
            tag.func_74757_a("isSpawned", false);
            stack.func_77982_d(tag);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            PlayerAether hook = PlayerAether.get(player);
            ItemStack companionStack = hook.accessories.getStackFromID(stack.func_77973_b());
            if (companionStack != stack) {
                return;
            }
            if (hook.currentCompanion == null || hook.currentCompanion.field_70128_L) {
                tag.func_74757_a("isSpawned", false);
                int tickCounter = tag.func_74762_e("cooldown");
                if (tickCounter <= 0) {
                    this.spawnCompanion(player, stack);
                    tag.func_74768_a("cooldown", 600);
                } else {
                    tag.func_74768_a("cooldown", tickCounter - 1);
                }
            } else if (!tag.func_74767_n("isSpawned")) {
                this.spawnCompanion(player, stack);
            }
        }
    }

    public void spawnCompanion(EntityPlayer player, ItemStack stack) {
        PlayerAether hook = PlayerAether.get(player);
        World world = player.field_70170_p;
        EntityCompanion companion = this.createCompanion(world);
        if (hook.currentCompanion != null) {
            hook.currentCompanion.unsummon();
        }
        player.func_71029_a((StatBase)AetherAchievements.companion);
        companion.setOwner(player);
        companion.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        companion.field_70759_as = companion.field_70177_z;
        companion.field_70761_aq = companion.field_70177_z;
        companion.summon(stack);
        hook.currentCompanion = companion;
        if (!world.field_72995_K) {
            stack.func_77978_p().func_74757_a("isSpawned", world.func_72838_d((Entity)companion));
            companion.func_70642_aH();
            String name = stack.func_77978_p().func_74779_i("name");
            if (name != null && !name.isEmpty()) {
                companion.setCompanionName(stack.func_77978_p().func_74779_i("name"));
            }
        }
    }

    private EntityCompanion createCompanion(World world) {
        try {
            return this.clazz.getConstructor(World.class).newInstance(world);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void onEquip(ItemStack stack, EntityPlayer player) {
        this.spawnCompanion(player, stack);
    }

    @Override
    public void onUnequip(ItemStack stack, EntityPlayer player) {
        PlayerAether hook = PlayerAether.get(player);
        if (hook.currentCompanion != null) {
            hook.currentCompanion.unsummon();
            hook.currentCompanion = null;
        }
    }
}

