/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.entities.AetherEntities;
import net.aetherteam.aether.entities.util.AetherSpawnEggInfo;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemSpawnEgg
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon theIcon;

    public ItemSpawnEgg() {
        this.func_77627_a(true);
        this.func_77637_a(Aether.misc);
    }

    public String func_77653_i(ItemStack stack) {
        String itemName = ("" + StatCollector.func_74838_a((String)(this.func_77658_a() + ".name"))).trim();
        String entityName = AetherEntities.getStringFromID(stack.func_77960_j());
        if (entityName != null) {
            itemName = itemName + " " + StatCollector.func_74838_a((String)("entity.aether." + entityName + ".name"));
        }
        return itemName;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int layer) {
        AetherSpawnEggInfo entityegginfo = AetherEntities.entityEggs.get(stack.func_77960_j());
        return entityegginfo != null ? (layer == 0 ? entityegginfo.getPrimaryColor() : entityegginfo.getSecondaryColor()) : 0xFFFFFF;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        Entity entity;
        if (world.field_72995_K) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        x += Facing.field_71586_b[side];
        y += Facing.field_71587_c[side];
        z += Facing.field_71585_d[side];
        double d0 = 0.0;
        if (side == 1 && block.func_149645_b() == 11) {
            d0 = 0.5;
        }
        if ((entity = ItemSpawnEgg.spawnCreature(world, stack.func_77960_j(), (double)x + 0.5, (double)y + d0, (double)z + 0.5)) != null) {
            if (entity instanceof EntityLivingBase && stack.func_82837_s()) {
                ((EntityLiving)entity).func_94058_c(stack.func_82833_r());
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
        if (movingobjectposition == null) {
            return stack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Entity entity;
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(player, i, j, k)) {
                return stack;
            }
            if (!player.func_82247_a(i, j, k, movingobjectposition.field_72310_e, stack)) {
                return stack;
            }
            if (world.func_147439_a(i, j, k) instanceof BlockLiquid && (entity = ItemSpawnEgg.spawnCreature(world, stack.func_77960_j(), i, j, k)) != null) {
                if (entity instanceof EntityLivingBase && stack.func_82837_s()) {
                    ((EntityLiving)entity).func_94058_c(stack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
        }
        return stack;
    }

    public static Entity spawnCreature(World world, int id, double x, double y, double z) {
        if (!AetherEntities.entityEggs.containsKey(id)) {
            return null;
        }
        Entity entity = null;
        for (int j = 0; j < 1; ++j) {
            entity = ItemSpawnEgg.createEntityByID(id, world);
            if (entity == null || !(entity instanceof EntityLivingBase)) continue;
            EntityLiving entityliving = (EntityLiving)entity;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_110161_a(null);
            world.func_72838_d(entity);
            entityliving.func_70642_aH();
        }
        return entity;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int par1, int side) {
        return side > 0 ? this.theIcon : super.func_77618_c(par1, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item p_150895_1_, CreativeTabs p_150895_2_, List p_150895_3_) {
        for (AetherSpawnEggInfo info : AetherEntities.entityEggs.values()) {
            p_150895_3_.add(new ItemStack(p_150895_1_, 1, info.getSpawnedID()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegistry) {
        super.func_94581_a(iconRegistry);
        this.theIcon = iconRegistry.func_94245_a(this.func_111208_A() + "_overlay");
    }

    public static Entity createEntityByID(int id, World world) {
        Entity entity = null;
        try {
            Class oclass = AetherEntities.getClassFromID(id);
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }
}

