/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;

public class ItemWrappingPaper
extends Item {
    public static IIcon overlayIcon;
    public static IIcon ribbonIcon;

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        PresentDyeData data = ItemWrappingPaper.getDyeData(stack);
        if (data == null) {
            return;
        }
        list.add(EnumChatFormatting.YELLOW + data.getBowColorName() + " Bow, " + data.getBoxColorName() + " Box");
        list.add(EnumChatFormatting.GRAY + "Craft with items!");
    }

    public static PresentDyeData getDyeData(ItemStack stack) {
        return PresentDyeData.readFromNBT(stack.func_77978_p());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        super.func_94581_a(register);
        overlayIcon = register.func_94245_a("aether:Wrapping Paper Overlay");
        ribbonIcon = register.func_94245_a("aether:Wrapping Paper Ribbon");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int phase) {
        PresentDyeData data = ItemWrappingPaper.getDyeData(stack);
        if (phase == 0) {
            return ItemDye.field_150922_c[data.getBoxColor()];
        }
        if (phase == 1) {
            return ItemDye.field_150922_c[data.getBowColor()];
        }
        return super.func_82790_a(stack, phase);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int p_77618_1_, int phase) {
        if (phase == 0) {
            return this.field_77791_bV;
        }
        if (phase == 1) {
            return ribbonIcon;
        }
        return overlayIcon;
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    public static class PresentDyeData {
        public static final String[] dyeNames = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "Silver", "Gray", "Pink", "Lime", "Yellow", "Light Blue", "Magenta", "Orange", "White"};
        private byte bowColor = 1;
        private byte boxColor = (byte)15;

        public static PresentDyeData readFromNBT(NBTTagCompound compound) {
            PresentDyeData data = new PresentDyeData();
            if (compound == null) {
                return new PresentDyeData();
            }
            data.setBoxColor(compound.func_74771_c("boxColor"));
            data.setBowColor(compound.func_74771_c("bowColor"));
            return data;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound compound) {
            compound.func_74774_a("boxColor", this.getBoxColor());
            compound.func_74774_a("bowColor", this.getBowColor());
            return compound;
        }

        public String getBowColorName() {
            return dyeNames[this.getBowColor()];
        }

        public String getBoxColorName() {
            return dyeNames[this.getBoxColor()];
        }

        public byte getBowColor() {
            return this.bowColor;
        }

        public void setBowColor(byte bowColor) {
            this.bowColor = bowColor;
        }

        public byte getBoxColor() {
            return this.boxColor;
        }

        public void setBoxColor(byte boxColor) {
            this.boxColor = boxColor;
        }
    }
}

