/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.notifications.actions;

import net.aetherteam.aether.data.DungeonPosition;
import net.aetherteam.aether.notifications.Notification;
import net.aetherteam.aether.notifications.NotificationHandler;
import net.aetherteam.aether.notifications.actions.NotificationAction;
import net.aetherteam.aether.packets.AetherPacketHandler;
import net.aetherteam.aether.packets.PacketDungeonEnter;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.player.PlayerAether;

public class MemberEnterDungeonAction
implements NotificationAction {
    private DungeonPosition position;

    public MemberEnterDungeonAction(DungeonPosition position) {
        this.position = position;
    }

    @Override
    public boolean executeAccept(Notification notification) {
        PlayerAether recruiter = notification.getSender();
        Party party = recruiter.getParty();
        PlayerAether receiver = notification.getReceiver();
        Party receiverParty = receiver.getParty();
        boolean dungeonJoined = false;
        if (party == receiverParty) {
            AetherPacketHandler.sendToServer(new PacketDungeonEnter(this.position));
            dungeonJoined = true;
        }
        NotificationHandler.instance().removeNotification(notification);
        NotificationHandler.instance().removeSentNotification(notification, true);
        return dungeonJoined;
    }

    @Override
    public boolean executeDecline(Notification notification) {
        NotificationHandler.instance().removeNotification(notification);
        NotificationHandler.instance().removeSentNotification(notification, true);
        return true;
    }

    @Override
    public String acceptMessage(Notification notification) {
        return "You have joined " + notification.getSender().getUsername() + "'s Dungeon!";
    }

    @Override
    public String failedMessage(Notification notification) {
        return "Something went wrong! " + notification.getSender().getUsername() + " might have left your party.";
    }

    @Override
    public boolean isRelevant(Notification notification) {
        PlayerAether recruiter = notification.getSender();
        Party party = recruiter.getParty();
        PlayerAether receiver = notification.getReceiver();
        Party receiverParty = receiver.getParty();
        return receiverParty != null && receiverParty.equals(party);
    }
}

