/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.packets;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.aetherteam.aether.client.gui.notifications.ClientNotificationHandler;
import net.aetherteam.aether.data.ByteDecoder;
import net.aetherteam.aether.data.ByteEncoder;
import net.aetherteam.aether.packets.AetherPacket;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.party.PartyController;
import net.aetherteam.aether.party.PartyType;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.entity.player.EntityPlayer;

public class PacketPartyClientInfo
extends AetherPacket<PacketPartyClientInfo> {
    private Party party;
    private UUID partyID;
    private UUID leader;
    private String partyName;
    private PartyType partyType;
    private ArrayList<PlayerAether> newMemberList;
    private ArrayList<PlayerAether> requestedMembers;

    public PacketPartyClientInfo() {
    }

    public PacketPartyClientInfo(Party party) {
        this.party = party;
        this.partyID = party.getID();
        this.leader = party.getLeader().getUniqueID();
    }

    public void detectPlayerListChanges(Collection<PlayerAether> oldList, Collection<PlayerAether> newList, ArrayList<PlayerAether> added, ArrayList<PlayerAether> removed) {
        boolean found;
        for (PlayerAether newPlayer : newList) {
            found = false;
            for (PlayerAether oldPlayer : oldList) {
                if (!newPlayer.getUniqueID().equals(oldPlayer.getUniqueID())) continue;
                found = true;
                break;
            }
            if (found) continue;
            added.add(newPlayer);
        }
        for (PlayerAether oldPlayer : oldList) {
            found = false;
            for (PlayerAether newPlayer : newList) {
                if (!oldPlayer.getUniqueID().equals(newPlayer.getUniqueID())) continue;
                found = true;
                break;
            }
            if (found) continue;
            removed.add(oldPlayer);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.partyID = new UUID(buf.readLong(), buf.readLong());
        this.leader = new UUID(buf.readLong(), buf.readLong());
        this.partyName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.partyType = PartyType.getTypeFromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.newMemberList = ByteDecoder.decodePlayerList(buf);
        this.requestedMembers = ByteDecoder.decodePlayerList(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.partyID.getMostSignificantBits());
        buf.writeLong(this.partyID.getLeastSignificantBits());
        buf.writeLong(this.leader.getMostSignificantBits());
        buf.writeLong(this.leader.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.party.getName());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.party.getType().name());
        ByteEncoder.encodePlayerList(buf, this.party.getAllMembers());
        ByteEncoder.encodePlayerList(buf, this.party.getAllPendingMembers());
    }

    @Override
    public void handleClientSide(PacketPartyClientInfo message, EntityPlayer player) {
        Party party = PartyController.instance().getParty(message.partyID);
        if (party != null) {
            PartyController controller = PartyController.instance();
            if (!message.partyName.equals(party.getName())) {
                ClientNotificationHandler.createMessage("Party name changed!", party.getName(), null, "Anonymous");
                party.setName(message.partyName);
            } else if (controller.getParty(party.getID()) == null) {
                ClientNotificationHandler.createMessage("Party disbanded!", party.getName(), null, "Anonymous");
                return;
            }
            if (message.partyType != party.getType()) {
                ClientNotificationHandler.createMessage("Party type changed!", message.partyType.name(), null, "Anonymous");
                party.setType(message.partyType);
            }
            if (!message.leader.equals(party.getLeader().getUniqueID())) {
                ClientNotificationHandler.createMessage("You've been promoted!", party.getName(), null, "Anonymous");
                party.setLeader(PlayerAether.get(message.leader));
            }
            ArrayList<PlayerAether> addedMembers = new ArrayList<PlayerAether>();
            ArrayList<PlayerAether> removedMembers = new ArrayList<PlayerAether>();
            this.detectPlayerListChanges(party.getAllMembers(), message.newMemberList, addedMembers, removedMembers);
            for (PlayerAether addedMember : addedMembers) {
                if (addedMember == party.getLeader()) continue;
                ClientNotificationHandler.createGeneric("Member joined!", addedMember, null);
            }
            for (PlayerAether removedMember : removedMembers) {
                if (removedMember == party.getLeader()) continue;
                ClientNotificationHandler.createGeneric("Member left!", removedMember, null);
            }
            party.setMembers(message.newMemberList);
            party.setRequestedMembers(message.requestedMembers);
        }
    }

    @Override
    public void handleServerSide(PacketPartyClientInfo message, EntityPlayer player) {
    }
}

