/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.packets;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.aetherteam.aether.data.ByteDecoder;
import net.aetherteam.aether.data.ByteEncoder;
import net.aetherteam.aether.packets.AetherPacket;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.party.PartyController;
import net.minecraft.entity.player.EntityPlayer;

public class PacketPartyListChange
extends AetherPacket<PacketPartyListChange> {
    private ArrayList<Party> partyList;

    public void fromBytes(ByteBuf buf) {
        this.partyList = ByteDecoder.decodeArrayList(buf, Party.class);
    }

    public void toBytes(ByteBuf buf) {
        ByteEncoder.encodeArrayList(buf, PartyController.instance().getPartyList());
    }

    @Override
    public void handleClientSide(PacketPartyListChange message, EntityPlayer player) {
        HashMap<UUID, Party> partyMap = new HashMap<UUID, Party>(PartyController.instance().getParties());
        HashMap<UUID, Party> newPartyMap = PartyController.instance().getParties();
        newPartyMap.clear();
        for (Party party : message.partyList) {
            Party oldParty = partyMap.get(party.getID());
            if (oldParty == null) {
                newPartyMap.put(party.getID(), party);
                continue;
            }
            oldParty.setName(party.getName());
            oldParty.setType(party.getType());
            oldParty.setLeader(party.getLeader());
            newPartyMap.put(oldParty.getID(), oldParty);
        }
    }

    @Override
    public void handleServerSide(PacketPartyListChange message, EntityPlayer player) {
    }
}

