/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.party;

import com.gildedgames.util.core.nbt.NBT;
import com.gildedgames.util.core.nbt.NBTFactory;
import com.gildedgames.util.io_manager.factory.IOFactory;
import com.gildedgames.util.io_manager.util.IOUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.packets.AetherPacketHandler;
import net.aetherteam.aether.packets.PacketPartyEvent;
import net.aetherteam.aether.packets.PacketPartyListChange;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.party.PartyType;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.nbt.NBTTagCompound;

public class PartyController
implements NBT {
    private final HashMap<UUID, Party> parties = new HashMap();
    private static PartyController clientController = new PartyController();
    private static PartyController serverController = new PartyController();

    public static void clear() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side.isClient()) {
            clientController = new PartyController();
        } else {
            Aether.print("Clearing the party controller.");
            serverController = new PartyController();
        }
    }

    public static PartyController instance() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side.isClient()) {
            return clientController;
        }
        return serverController;
    }

    public void sendAddPartyPacket(String name, PartyType type) {
        AetherPacketHandler.sendToServer(new PacketPartyEvent(PacketPartyEvent.PartyEvent.PARTY_CREATE, new UUID(0L, 0L), name, type, null, null));
    }

    public void addParty(String name, PartyType type, PlayerAether source) {
        for (Party party : this.getPartyList()) {
            if (!party.getName().equals(name)) continue;
            Aether.print("Failure to create party with name " + name + " because party already exists!");
            return;
        }
        Aether.print("Party with name " + name + " created!");
        Party party = new Party(name, type, source);
        this.parties.put(party.getID(), party);
        AetherPacketHandler.sendToAll(new PacketPartyListChange());
    }

    public void sendRemovePartyPacket(Party party) {
        AetherPacketHandler.sendToServer(new PacketPartyEvent(PacketPartyEvent.PartyEvent.PARTY_DISBAND, party.getID(), party.getName(), null, null, null));
    }

    public void removeParty(UUID uuid, PlayerAether source) {
        Party party = this.parties.get(uuid);
        if (party == null) {
            Aether.print("Failure to delete party because it was not in the Controller list.");
            return;
        }
        if (party.getLeader() == null || source.getUniqueID().equals(party.getLeader().getUniqueID())) {
            ArrayList<PlayerAether> members = new ArrayList<PlayerAether>(party.getAllMembers());
            for (PlayerAether member : members) {
                party.leave(member, member);
            }
            if (this.parties.remove(party.getID()) != null) {
                Aether.print(party.getName() + " removed!");
                AetherPacketHandler.sendToAll(new PacketPartyListChange());
            } else {
                Aether.print("Failure to delete party " + party.getName() + " because it was not in the controller!");
            }
        } else {
            Aether.print("Couldn't delete party " + party.getName() + " because " + source.getProfile().getUsername() + " is not the leader.");
        }
    }

    public Party getParty(UUID uuid) {
        return this.parties.get(uuid);
    }

    public boolean doesPartyWithNameExist(String name) {
        for (Party party : this.getPartyList()) {
            if (!party.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public HashMap<UUID, Party> getParties() {
        return this.parties;
    }

    public Collection<Party> getPartyList() {
        return this.parties.values();
    }

    public Collection<Party> getOnlinePartyList() {
        ArrayList<Party> onlineParties = new ArrayList<Party>();
        for (Party party : this.parties.values()) {
            if (party.getOnlineMembers().size() == 0 && !party.getLeader().loggedIn) continue;
            onlineParties.add(party);
        }
        return onlineParties;
    }

    private void setParties(List<Party> parties) {
        for (Party party : parties) {
            this.parties.put(party.getID(), party);
        }
        if (Aether.isServer()) {
            AetherPacketHandler.sendToAll(new PacketPartyListChange());
        }
    }

    public void write(NBTTagCompound output) {
        NBTFactory factory = new NBTFactory();
        IOUtil.setIOList((String)"parties", new ArrayList<Party>(this.getPartyList()), (IOFactory)factory, (Object)output);
    }

    public void read(NBTTagCompound input) {
        NBTFactory factory = new NBTFactory();
        List parties = IOUtil.getIOList((String)"parties", (IOFactory)factory, (Object)input);
        this.setParties(parties);
    }
}

