/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.player;

import com.gildedgames.util.core.nbt.NBTHelper;
import com.gildedgames.util.io_manager.io.IOSyncable;
import com.gildedgames.util.player.common.IPlayerHookPool;
import com.gildedgames.util.player.common.player.IPlayerHook;
import com.gildedgames.util.player.common.player.IPlayerProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.AetherLoot;
import net.aetherteam.aether.achievements.AetherAchievements;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.containers.inventory.InventoryAccessories;
import net.aetherteam.aether.data.ByteDecoder;
import net.aetherteam.aether.data.ByteEncoder;
import net.aetherteam.aether.data.DungeonPosition;
import net.aetherteam.aether.data.EntityPosition;
import net.aetherteam.aether.donator.DonatorChoice;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.dungeons.DungeonHandler;
import net.aetherteam.aether.dungeons.DungeonSliderLabyrinth;
import net.aetherteam.aether.dungeons.TeleporterDungeons;
import net.aetherteam.aether.entities.EntityAetherCoin;
import net.aetherteam.aether.entities.bosses.EntityBossMob;
import net.aetherteam.aether.entities.companion.EntityCompanion;
import net.aetherteam.aether.items.AetherItems;
import net.aetherteam.aether.items.ItemAccessory;
import net.aetherteam.aether.items.ItemCompanionSummoner;
import net.aetherteam.aether.packets.AetherPacketHandler;
import net.aetherteam.aether.packets.PacketPlayerInput;
import net.aetherteam.aether.party.MemberType;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.party.PartyController;
import net.aetherteam.aether.player.abilities.Ability;
import net.aetherteam.aether.player.abilities.AbilityAccessories;
import net.aetherteam.aether.player.abilities.AbilityArmor;
import net.aetherteam.aether.player.abilities.AbilityParachute;
import net.aetherteam.aether.player.abilities.AbilityWings;
import net.aetherteam.aether.potions.AetherPotion;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;

public class PlayerAether
implements IPlayerHook {
    private AttributeModifier healthModifier = new AttributeModifier("Aether Health Modifier", 0.0, 2);
    private IPlayerHookPool<PlayerAether> pool;
    private IPlayerProfile profile;
    public EntityPlayer entityPlayer;
    public Ability[] abilities;
    public AbilityParachute abilityParachute;
    private float wingAnimation;
    private int cooldown;
    private int cooldownMax;
    private String cooldownName = "Hammer of Notch";
    private int aetherCoins;
    public InventoryAccessories accessories = new InventoryAccessories(this, this.entityPlayer);
    private EntityBossMob currentBoss;
    private int currentDungeonId = -1;
    private EntityPosition nonDungeonPos = new EntityPosition();
    private HashMap<DungeonPosition, Integer> dungeonMap = new HashMap();
    private final ArrayList<DungeonPosition> bannedDungeonEntrances = new ArrayList();
    private UUID partyID;
    private MemberType partyMemberType;
    private boolean isDonator;
    private DonatorChoice donatorChoice = new DonatorChoice();
    public List<Item> extendedReachItems = Arrays.asList(AetherItems.ValkyrieShovel, AetherItems.ValkyriePickaxe, AetherItems.ValkyrieAxe);
    public boolean loggedIn;
    protected boolean isJumping;
    protected boolean prevIsJumping;
    public float prevTimeInPortal;
    public static float timeCharged;
    public boolean teleported;
    public float timeInPortal;
    public EntityCompanion currentCompanion;
    private List<ItemStack> dungeonRewards = new ArrayList<ItemStack>();
    private int lastBedDimension = 0;
    private boolean sleptInBed = false;
    public int shardsUsed = 0;
    private int spiritRepairTime = 24000;
    private boolean brokeSeal = false;
    private boolean isDirty;
    private boolean lastHasHighSteps;
    private boolean isHaloEnabled;

    public static PlayerAether get(EntityPlayer player) {
        return PlayerAether.get(player.func_110124_au());
    }

    public static PlayerAether get(UUID uuid) {
        return Aether.locate().get(uuid);
    }

    public IPlayerHookPool getParentPool() {
        return this.pool;
    }

    public IPlayerProfile getProfile() {
        return this.profile;
    }

    public PlayerAether() {
        this.abilities = new Ability[]{new AbilityAccessories(this), new AbilityArmor(this), new AbilityParachute(this), new AbilityWings(this)};
        this.abilityParachute = (AbilityParachute)this.abilities[2];
    }

    public PlayerAether(IPlayerProfile profile, IPlayerHookPool<PlayerAether> pool) {
        this();
        this.profile = profile;
        this.pool = pool;
    }

    public PlayerAether(UUID uuid) {
        this();
        Aether.locate().get(uuid);
    }

    public void entityInit(EntityPlayer player) {
        this.entityPlayer = player;
        this.onJoinWorld();
    }

    public void onJoinWorld() {
        this.accessories.player = this.entityPlayer;
        for (Ability ability : this.abilities) {
            ability.entityPlayer = this.entityPlayer;
            ability.worldObj = this.entityPlayer.field_70170_p;
        }
        for (Ability ability : this.accessories.stacks) {
            if (ability == null || !(ability.func_77973_b() instanceof ItemAccessory)) continue;
            ((ItemAccessory)ability.func_77973_b()).onEquip((ItemStack)ability, this.entityPlayer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientUpdate() {
        if (!(this.entityPlayer instanceof EntityPlayerSP)) {
            return;
        }
        for (Ability ability : this.abilities) {
            if (!ability.isWearing()) continue;
            ability.onClientUpdate();
        }
        this.isJumping = ((EntityPlayerSP)this.entityPlayer).field_71158_b.field_78901_c;
        if (this.prevIsJumping != this.isJumping) {
            AetherPacketHandler.sendToServer(new PacketPlayerInput(this));
        }
        this.prevIsJumping = this.isJumping;
    }

    public void onUpdate() {
        if (this.entityPlayer == null) {
            return;
        }
        if (this.entityPlayer.func_70608_bn()) {
            this.entityPlayer.setSpawnChunk(this.entityPlayer.getBedLocation(this.entityPlayer.field_71093_bK), false, this.entityPlayer.field_71093_bK);
            this.setLastSleptInDimension(this.entityPlayer.field_71093_bK);
            this.setSleptInBed(true);
        }
        if (this.accessories.getStackFromType(ItemAccessory.AccessoryType.COMPANION) == null) {
            if (this.currentCompanion != null) {
                this.currentCompanion.unsummon();
            }
            this.currentCompanion = null;
        }
        for (Ability ability : this.abilities) {
            if (!ability.isWearing()) continue;
            ability.onUpdate();
        }
        boolean hasHighSteps = this.entityPlayer.func_82165_m(AetherPotion.highSteps.field_76415_H);
        if (this.lastHasHighSteps != hasHighSteps) {
            this.entityPlayer.field_70138_W = hasHighSteps ? (float)(1 + this.entityPlayer.func_70660_b(AetherPotion.highSteps).func_76458_c()) : 0.5f;
        }
        this.lastHasHighSteps = hasHighSteps;
        this.accessories.onUpdate();
        this.wingAnimation = !this.entityPlayer.field_70122_E ? (this.wingAnimation += 0.75f) : (this.wingAnimation += 0.15f);
        if (this.wingAnimation > 6.283186f) {
            this.wingAnimation -= 6.283186f;
        }
        if (this.getCurrentBoss() != null && this.getCurrentBoss() instanceof EntityLivingBase) {
            EntityBossMob bossMob = this.getCurrentBoss();
            if (Math.sqrt(Math.pow(((EntityLiving)bossMob).field_70165_t - this.entityPlayer.field_70165_t, 2.0) + Math.pow(((EntityLiving)bossMob).field_70163_u - this.entityPlayer.field_70163_u, 2.0) + Math.pow(((EntityLiving)bossMob).field_70161_v - this.entityPlayer.field_70161_v, 2.0)) > 50.0) {
                this.setCurrentBoss(null);
            } else if (((EntityLiving)bossMob).field_70128_L || this.getCurrentBoss().func_110143_aJ() <= 0.0f) {
                this.setCurrentBoss(null);
            }
        }
        if (this.getCooldown() > 0) {
            this.setCooldown(this.getCooldown() - 1);
        }
        if (this.isAboveBlock(AetherBlocks.Aercloud)) {
            this.entityPlayer.field_70143_R = 0.0f;
        }
        if (this.isInBlock(AetherBlocks.ColdFire)) {
            this.entityPlayer.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 10, 4));
        }
        this.prevTimeInPortal = this.timeInPortal;
        if (this.isInBlock(AetherBlocks.AetherPortal)) {
            if (this.entityPlayer.field_70170_p.field_72995_K && timeCharged == 0.0f && !this.teleported) {
                if (Minecraft.func_71410_x().field_71439_g.func_145782_y() == this.entityPlayer.func_145782_y()) {
                    Minecraft.func_71410_x().field_71439_g.func_85030_a("aether:aeportal.aetrigger", 1.0f, 1.0f);
                }
                timeCharged = 70.0f;
            }
            this.timeInPortal += 0.0125f;
            if (this.timeInPortal >= 1.0f) {
                this.timeInPortal = 1.0f;
            }
            if (!this.teleported && (this.entityPlayer.field_71075_bZ.field_75098_d || this.timeInPortal == 1.0f)) {
                this.teleportToAether();
            }
        } else if (this.entityPlayer.func_70644_a(Potion.field_76431_k) && this.entityPlayer.func_70660_b(Potion.field_76431_k).func_76459_b() > 60) {
            this.timeInPortal += 0.006666667f;
            if (this.timeInPortal > 1.0f) {
                this.timeInPortal = 1.0f;
            }
        } else {
            if (this.timeInPortal > 0.0f) {
                this.timeInPortal -= 0.05f;
            }
            if (this.timeInPortal < 0.0f) {
                this.timeInPortal = 0.0f;
            }
            this.teleported = false;
        }
        if (timeCharged > 0.0f) {
            timeCharged -= 1.0f;
        }
        if (this.entityPlayer.field_71088_bW > 0) {
            --this.entityPlayer.field_71088_bW;
        }
        if (this.entityPlayer.field_71093_bK == Aether.getDimensionID() && this.entityPlayer.field_70163_u < -2.0) {
            Aether.teleportPlayerToAether(this.entityPlayer, true);
            this.entityPlayer.func_71029_a((StatBase)AetherAchievements.freeFall);
        }
        if (this.entityPlayer.field_71093_bK == Aether.getDimensionID()) {
            this.entityPlayer.func_71029_a((StatBase)AetherAchievements.enterAether);
        }
        if (this.entityPlayer.field_70170_p.field_72995_K) {
            this.onClientUpdate();
        } else {
            ((EntityPlayerMP)this.entityPlayer).field_71134_c.setBlockReachDistance(this.getReach());
        }
    }

    public double getReach() {
        ItemStack stack = this.entityPlayer.func_71045_bC();
        if (stack != null && stack.func_77973_b() != null && this.extendedReachItems.contains(stack.func_77973_b())) {
            return 10.0;
        }
        return this.entityPlayer.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
    }

    public boolean onLivingAttack(DamageSource source) {
        for (Ability ability : this.abilities) {
            if (ability.onLivingAttack(source)) continue;
            return false;
        }
        return true;
    }

    public void onDeath() {
        for (Ability ability : this.abilities) {
            ability.onDeath();
        }
        if (!this.entityPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory") && !this.entityPlayer.field_70170_p.field_72995_K) {
            this.entityPlayer.field_70170_p.func_72838_d((Entity)new EntityAetherCoin(this.entityPlayer.field_70170_p, this.entityPlayer.field_70165_t, this.entityPlayer.field_70163_u, this.entityPlayer.field_70161_v, this.aetherCoins));
            this.setAetherCoins(0);
        }
    }

    public void onRespawn() {
        ChunkCoordinates spawn;
        WorldServer world;
        Dungeon dungeon = this.getDungeon();
        if (dungeon != null && !this.entityPlayer.field_70170_p.field_72995_K) {
            WorldServer world2 = MinecraftServer.func_71276_C().func_71218_a(Aether.getDungeonDimensionID());
            this.entityPlayer.func_70029_a((World)world2);
            dungeon.movePlayerToEntrance((EntityPlayerMP)this.entityPlayer);
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        ServerConfigurationManager configManager = server.func_71203_ab();
        if (this.hasSleptInBed()) {
            int bedDimension = this.getLastSleptInDimension();
            world = server.func_71218_a(bedDimension);
            spawn = this.entityPlayer.getBedLocation(bedDimension);
            if (spawn != null) {
                if ((spawn = EntityPlayer.func_71056_a((World)world, (ChunkCoordinates)spawn, (boolean)false)) != null) {
                    if (this.entityPlayer.field_71093_bK != bedDimension) {
                        configManager.transferPlayerToDimension((EntityPlayerMP)this.entityPlayer, bedDimension, (Teleporter)new TeleporterDungeons(world));
                    }
                    this.entityPlayer.func_70012_b((double)((float)spawn.field_71574_a + 0.5f), (double)((float)spawn.field_71572_b + 0.1f), (double)((float)spawn.field_71573_c + 0.5f), 0.0f, 0.0f);
                    world.field_73059_b.func_73158_c((int)this.entityPlayer.field_70165_t >> 4, (int)this.entityPlayer.field_70161_v >> 4);
                    ((EntityPlayerMP)this.entityPlayer).field_71135_a.func_147364_a(this.entityPlayer.field_70165_t, this.entityPlayer.field_70163_u, this.entityPlayer.field_70161_v, this.entityPlayer.field_70177_z, this.entityPlayer.field_70125_A);
                    return;
                }
                this.setSleptInBed(false);
            }
        }
        if (this.entityPlayer.field_71093_bK == Aether.getDimensionID()) {
            world = server.func_71218_a(0);
            configManager.transferPlayerToDimension((EntityPlayerMP)this.entityPlayer, 0, (Teleporter)new TeleporterDungeons(world));
            spawn = world.func_72861_E();
            this.entityPlayer.func_70012_b((double)((float)spawn.field_71574_a + 0.5f), (double)((float)spawn.field_71572_b + 0.1f), (double)((float)spawn.field_71573_c + 0.5f), 0.0f, 0.0f);
            world.field_73059_b.func_73158_c((int)this.entityPlayer.field_70165_t >> 4, (int)this.entityPlayer.field_70161_v >> 4);
            while (!world.func_72945_a((Entity)this.entityPlayer, this.entityPlayer.field_70121_D).isEmpty()) {
                this.entityPlayer.func_70107_b(this.entityPlayer.field_70165_t, this.entityPlayer.field_70163_u + 1.0, this.entityPlayer.field_70161_v);
            }
            ((EntityPlayerMP)this.entityPlayer).field_71135_a.func_147364_a(this.entityPlayer.field_70165_t, this.entityPlayer.field_70163_u, this.entityPlayer.field_70161_v, this.entityPlayer.field_70177_z, this.entityPlayer.field_70125_A);
        }
    }

    public void onChangedDimension() {
        ItemStack companionStack;
        if (this.currentCompanion != null) {
            this.currentCompanion.func_70106_y();
        }
        if ((companionStack = this.accessories.getStackFromType(ItemAccessory.AccessoryType.COMPANION)) != null && companionStack.func_77973_b() instanceof ItemCompanionSummoner) {
            ((ItemCompanionSummoner)companionStack.func_77973_b()).spawnCompanion(this.entityPlayer, companionStack);
        }
        if (this.getDungeon() != null && this.entityPlayer.field_71093_bK != Aether.getDungeonDimensionID()) {
            this.setCurrentDungeonId(-1);
        }
    }

    public boolean isAboveBlock(Block blockID) {
        MathHelper.func_76128_c((double)this.entityPlayer.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.entityPlayer.field_70121_D.field_72338_b);
        MathHelper.func_76128_c((double)this.entityPlayer.field_70161_v);
        return this.entityPlayer.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.entityPlayer.field_70121_D.field_72340_a), y - 1, MathHelper.func_76128_c((double)this.entityPlayer.field_70121_D.field_72339_c)) == blockID || this.entityPlayer.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.entityPlayer.field_70121_D.field_72336_d), y - 1, MathHelper.func_76128_c((double)this.entityPlayer.field_70121_D.field_72339_c)) == blockID || this.entityPlayer.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.entityPlayer.field_70121_D.field_72336_d), y - 1, MathHelper.func_76128_c((double)this.entityPlayer.field_70121_D.field_72334_f)) == blockID || this.entityPlayer.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.entityPlayer.field_70121_D.field_72340_a), y - 1, MathHelper.func_76128_c((double)this.entityPlayer.field_70121_D.field_72334_f)) == blockID;
    }

    public boolean isInBlock(Block blockID) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.entityPlayer.field_70165_t);
        return this.entityPlayer.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)this.entityPlayer.field_70163_u), z = MathHelper.func_76128_c((double)this.entityPlayer.field_70161_v)) == blockID || this.entityPlayer.field_70170_p.func_147439_a(x, y + 1, z) == blockID || this.entityPlayer.field_70170_p.func_147439_a(x, y - 1, z) == blockID;
    }

    public float getStrengthVsBlock(Block block, float originalStrength) {
        if (this.entityPlayer == null || this.entityPlayer.field_71071_by == null) {
            return originalStrength;
        }
        float f = originalStrength;
        if (this.wearingAccessory(AetherItems.ZanitePendant)) {
            f *= 1.0f + (float)this.getAccessoryStacks()[0].func_77960_j() / ((float)this.getAccessoryStacks()[0].func_77958_k() * 3.0f);
        }
        if (this.wearingAccessory(AetherItems.ZaniteRing)) {
            ItemStack ring1 = this.getAccessoryStacks()[4];
            ItemStack ring2 = this.getAccessoryStacks()[5];
            if (ring1 != null && ring1.func_77973_b() == AetherItems.ZaniteRing) {
                f *= 1.0f + (float)ring1.func_77960_j() / ((float)ring1.func_77958_k() * 3.0f);
            }
            if (ring2 != null && ring2.func_77973_b() == AetherItems.ZaniteRing) {
                f *= 1.0f + (float)ring2.func_77960_j() / ((float)ring2.func_77958_k() * 3.0f);
            }
        }
        if (this.wearingNeptuneArmour()) {
            if (f > 1.0f) {
                int i = EnchantmentHelper.func_77509_b((EntityLivingBase)this.entityPlayer);
                ItemStack itemstack = this.entityPlayer.field_71071_by.func_70448_g();
                if (i > 0 && itemstack != null) {
                    float f1 = i * i + 1;
                    boolean canHarvest = ForgeHooks.canToolHarvestBlock((Block)block, (int)0, (ItemStack)itemstack);
                    f = !canHarvest && f <= 1.0f ? (f += f1 * 0.08f) : (f += f1);
                }
            }
            if (this.entityPlayer.func_70644_a(Potion.field_76422_e)) {
                f *= 1.0f + (float)(this.entityPlayer.func_70660_b(Potion.field_76422_e).func_76458_c() + 1) * 0.2f;
            }
            if (this.entityPlayer.func_70644_a(Potion.field_76419_f)) {
                f *= 1.0f - (float)(this.entityPlayer.func_70660_b(Potion.field_76419_f).func_76458_c() + 1) * 0.2f;
            }
            return f < 0.0f ? 0.0f : f;
        }
        return f;
    }

    public boolean wearingAccessory(Item itemID) {
        for (int index = 0; index < 8; ++index) {
            if (this.getAccessoryStacks()[index] == null || this.getAccessoryStacks()[index].func_77973_b() != itemID) continue;
            return true;
        }
        return false;
    }

    public int getAccessoryCount(Item itemID) {
        int count = 0;
        for (int index = 0; index < 8; ++index) {
            if (this.getAccessoryStacks()[index] == null || this.getAccessoryStacks()[index].func_77973_b() != itemID) continue;
            ++count;
        }
        return count;
    }

    public boolean wearingArmour(Item itemID) {
        for (int index = 0; index < 4; ++index) {
            if (this.entityPlayer.field_71071_by.field_70460_b[index] == null || this.entityPlayer.field_71071_by.field_70460_b[index].func_77973_b() != itemID) continue;
            return true;
        }
        return false;
    }

    public boolean wearingNeptuneArmour() {
        return this.wearingArmour(AetherItems.NeptuneHelmet) && this.wearingArmour(AetherItems.NeptuneChestplate) && this.wearingArmour(AetherItems.NeptuneLeggings) && this.wearingArmour(AetherItems.NeptuneBoots) && this.wearingAccessory(AetherItems.NeptuneGloves);
    }

    public boolean wearingValkyrieArmour() {
        return this.wearingArmour(AetherItems.ValkyrieHelmet) && this.wearingArmour(AetherItems.ValkyrieChestplate) && this.wearingArmour(AetherItems.ValkyrieLeggings) && this.wearingArmour(AetherItems.ValkyrieBoots) && this.wearingAccessory(AetherItems.ValkyrieGloves);
    }

    public boolean wearingObsidianArmour() {
        return this.wearingArmour(AetherItems.ObsidianHelmet) && this.wearingArmour(AetherItems.ObsidianChestplate) && this.wearingArmour(AetherItems.ObsidianLeggings) && this.wearingArmour(AetherItems.ObsidianBoots) && this.wearingAccessory(AetherItems.ObsidianGloves);
    }

    public boolean wearingPhoenixArmour() {
        return this.wearingArmour(AetherItems.PhoenixHelmet) && this.wearingArmour(AetherItems.PhoenixChestplate) && this.wearingArmour(AetherItems.PhoenixLeggings) && this.wearingArmour(AetherItems.PhoenixBoots) && this.wearingAccessory(AetherItems.PhoenixGloves);
    }

    public boolean wearingGravititeArmour() {
        return this.wearingArmour(AetherItems.GravititeHelmet) && this.wearingArmour(AetherItems.GravititeChestplate) && this.wearingArmour(AetherItems.GravititeLeggings) && this.wearingArmour(AetherItems.GravititeBoots) && this.wearingAccessory(AetherItems.GravititeGloves);
    }

    public void setIsHaloEnabled(boolean value) {
        this.isHaloEnabled = value;
        this.markDirty();
    }

    public boolean getIsHaloEnabled() {
        return this.isHaloEnabled;
    }

    public void write(NBTTagCompound tag) {
        tag.func_74768_a("GeneralCooldown", this.cooldown);
        tag.func_74768_a("GeneralCooldownMax", this.cooldownMax);
        tag.func_74778_a("CooldownName", this.cooldownName);
        tag.func_74768_a("Coins", this.aetherCoins);
        tag.func_74768_a("currentDungeonId", this.currentDungeonId);
        tag.func_74773_a("nonDungeonPos", ByteEncoder.encode(this.nonDungeonPos));
        tag.func_74773_a("dungeonMap", ByteEncoder.encodeIntMap(this.dungeonMap));
        tag.func_74757_a("donator", this.isDonator);
        tag.func_74778_a("partyMemberType", this.partyMemberType != null ? this.partyMemberType.name() : "");
        tag.func_74768_a("shardsUsed", this.shardsUsed);
        tag.func_74768_a("spiritRepairTime", this.spiritRepairTime);
        tag.func_74757_a("brokeSeal", this.brokeSeal);
        tag.func_74757_a("isHaloEnabled", this.isHaloEnabled);
        NBTTagCompound donator = new NBTTagCompound();
        this.donatorChoice.write(donator);
        tag.func_74782_a("donatorChoiceNew", (NBTBase)donator);
        this.accessories.write(tag);
        for (Ability ability : this.abilities) {
            ability.write(tag);
        }
        this.abilityParachute.write(tag);
        NBTHelper.encodeStackList((ItemStack[])this.dungeonRewards.toArray(new ItemStack[this.dungeonRewards.size()]));
        tag.func_74757_a("sleptInBed", this.sleptInBed);
        if (this.sleptInBed) {
            tag.func_74768_a("lastBedDimension", this.lastBedDimension);
        }
    }

    public void read(NBTTagCompound tag) {
        this.cooldown = tag.func_74762_e("GeneralCooldown");
        this.cooldownMax = tag.func_74762_e("GeneralCooldownMax");
        this.cooldownName = tag.func_74779_i("CooldownName");
        this.aetherCoins = tag.func_74762_e("Coins");
        this.currentDungeonId = tag.func_74762_e("currentDungeonId");
        this.nonDungeonPos = (EntityPosition)ByteDecoder.decode(EntityPosition.class, tag.func_74770_j("nonDungeonPos"));
        this.dungeonMap = ByteDecoder.decodeIntMap(DungeonPosition.class, tag.func_74770_j("dungeonMap"));
        this.isDonator = tag.func_74767_n("donator");
        this.partyMemberType = MemberType.getTypeFromString(tag.func_74779_i("partyMemberType"));
        this.shardsUsed = tag.func_74762_e("shardsUsed");
        this.spiritRepairTime = tag.func_74762_e("spiritRepairTime");
        this.brokeSeal = tag.func_74767_n("brokeSeal");
        this.accessories.read(tag);
        this.isHaloEnabled = tag.func_74767_n("isHaloEnabled");
        this.donatorChoice.read(tag.func_74775_l("donatorChoiceNew"));
        for (Ability ability : this.abilities) {
            ability.read(tag);
        }
        this.abilityParachute.read(tag);
        NBTHelper.decodeStackList((NBTTagList)tag.func_150295_c("dungeonRewards", 10));
        this.sleptInBed = tag.func_74767_n("sleptInBed");
        if (this.sleptInBed) {
            this.lastBedDimension = tag.func_74762_e("lastBedDimension");
        }
    }

    public void syncTo(ByteBuf dataOutput, IOSyncable.SyncSide to) {
        if (to.isClient()) {
            dataOutput.writeInt(this.cooldown);
            dataOutput.writeInt(this.cooldownMax);
            ByteBufUtils.writeUTF8String((ByteBuf)dataOutput, (String)this.cooldownName);
            dataOutput.writeInt(this.aetherCoins);
            dataOutput.writeInt(this.currentDungeonId);
            this.nonDungeonPos.writeData(dataOutput);
            ByteBufUtils.writeUTF8String((ByteBuf)dataOutput, (String)(this.partyID != null ? this.partyID.toString() : ""));
            ByteBufUtils.writeUTF8String((ByteBuf)dataOutput, (String)(this.partyMemberType != null ? this.partyMemberType.name() : ""));
            dataOutput.writeBoolean(this.loggedIn);
            dataOutput.writeBoolean(this.isDonator);
            dataOutput.writeFloat(this.wingAnimation);
            dataOutput.writeInt(this.spiritRepairTime);
            dataOutput.writeBoolean(this.brokeSeal);
            dataOutput.writeBoolean(this.isHaloEnabled);
            this.donatorChoice.writeData(dataOutput);
            this.accessories.writeData(dataOutput);
            for (Ability ability : this.abilities) {
                ability.syncTo(dataOutput, IOSyncable.SyncSide.CLIENT);
            }
            this.abilityParachute.syncTo(dataOutput, IOSyncable.SyncSide.CLIENT);
            ByteEncoder.encodeItemStackArray(dataOutput, this.dungeonRewards.toArray(new ItemStack[this.dungeonRewards.size()]));
        } else if (to.isServer()) {
            this.donatorChoice.writeData(dataOutput);
            dataOutput.writeBoolean(this.isJumping);
            dataOutput.writeBoolean(this.isHaloEnabled);
        }
    }

    public void syncFrom(ByteBuf dataInput, IOSyncable.SyncSide from) {
        if (from.isServer()) {
            this.cooldown = dataInput.readInt();
            this.cooldownMax = dataInput.readInt();
            this.cooldownName = ByteBufUtils.readUTF8String((ByteBuf)dataInput);
            this.aetherCoins = dataInput.readInt();
            this.currentDungeonId = dataInput.readInt();
            this.nonDungeonPos.readData(dataInput);
            String partyID = ByteBufUtils.readUTF8String((ByteBuf)dataInput);
            this.partyID = partyID.length() > 0 ? UUID.fromString(partyID) : null;
            this.partyMemberType = MemberType.getTypeFromString(ByteBufUtils.readUTF8String((ByteBuf)dataInput));
            this.loggedIn = dataInput.readBoolean();
            this.isDonator = dataInput.readBoolean();
            this.wingAnimation = dataInput.readFloat();
            this.spiritRepairTime = dataInput.readInt();
            this.brokeSeal = dataInput.readBoolean();
            this.isHaloEnabled = dataInput.readBoolean();
            this.donatorChoice.readData(dataInput);
            this.accessories.readData(dataInput);
            for (Ability ability : this.abilities) {
                ability.syncFrom(dataInput, IOSyncable.SyncSide.SERVER);
            }
            this.abilityParachute.syncFrom(dataInput, IOSyncable.SyncSide.SERVER);
            this.dungeonRewards = Arrays.asList(ByteDecoder.decodeItemStackArray(dataInput));
        } else if (from.isClient()) {
            this.donatorChoice.readData(dataInput);
            this.isJumping = dataInput.readBoolean();
            this.isHaloEnabled = dataInput.readBoolean();
        }
    }

    public Dungeon getDungeon() {
        return DungeonHandler.instance().getDungeon(this.currentDungeonId);
    }

    public Dungeon getDungeon(World world, DungeonPosition dungeonPosition) {
        Dungeon dungeon;
        dungeonPosition.dimensionID = world.field_73011_w.field_76574_g;
        if (this.getParty() != null) {
            return this.getParty().getDungeon(world, dungeonPosition);
        }
        Integer dungeonId = this.dungeonMap.get(dungeonPosition);
        if (dungeonId != null) {
            dungeon = DungeonHandler.instance().getDungeon(dungeonId);
            if (dungeon != null) {
                return dungeon;
            }
            this.dungeonMap.remove(dungeonPosition);
        }
        dungeon = new DungeonSliderLabyrinth();
        dungeon.generate(dungeonPosition);
        this.dungeonMap.put(dungeonPosition, dungeon.dungeonId);
        return dungeon;
    }

    public boolean setGeneralCooldown(int cooldown, String stackName) {
        if (this.cooldown == 0) {
            this.cooldown = cooldown;
            this.cooldownMax = cooldown;
            this.cooldownName = stackName;
            this.markDirty();
            return true;
        }
        return false;
    }

    public int getCurrentDungeonId() {
        return this.currentDungeonId;
    }

    public void setCurrentDungeonId(int currentDungeonId) {
        this.currentDungeonId = currentDungeonId;
        this.markDirty();
    }

    public EntityPosition getNonDungeonPos() {
        return this.nonDungeonPos;
    }

    public void setNonDungeonPos(EntityPosition nonDungeonPos) {
        this.nonDungeonPos = nonDungeonPos;
        this.markDirty();
    }

    public int getAetherCoins() {
        return this.aetherCoins;
    }

    public void setAetherCoins(int aetherCoins) {
        this.aetherCoins = aetherCoins;
        this.markDirty();
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public int getCooldownMax() {
        return this.cooldownMax;
    }

    public ItemStack[] getAccessoryStacks() {
        return this.accessories.stacks;
    }

    public EntityBossMob getCurrentBoss() {
        return this.currentBoss;
    }

    public void setCurrentBoss(EntityBossMob currentBoss) {
        this.currentBoss = currentBoss;
    }

    public String getCooldownName() {
        return this.cooldownName;
    }

    public void addBannedEntrance(DungeonPosition entrancePos) {
        this.bannedDungeonEntrances.add(entrancePos);
    }

    public boolean isEntranceBanned(DungeonPosition entrancePos) {
        return this.bannedDungeonEntrances.contains(entrancePos);
    }

    public float getHealth() {
        return this.entityPlayer.func_110143_aJ();
    }

    public float getMaxHealth() {
        return this.entityPlayer.func_110138_aP();
    }

    public int getTotalArmorValue() {
        return this.entityPlayer.func_70658_aO();
    }

    public Party getParty() {
        return this.partyID != null ? PartyController.instance().getParty(this.partyID) : null;
    }

    public void setParty(Party party) {
        this.partyID = party == null ? null : party.getID();
        this.markDirty();
    }

    public MemberType getPartyMemberType() {
        return this.partyMemberType;
    }

    public void setPartyMemberType(MemberType memberType) {
        this.partyMemberType = memberType;
        this.markDirty();
    }

    public float getWingAnimation() {
        return this.wingAnimation;
    }

    public void setWingAnimation(float wingAnimation) {
        this.wingAnimation = wingAnimation;
    }

    public boolean isDonator() {
        return this.isDonator;
    }

    public void setDonator(boolean isDonator) {
        this.isDonator = isDonator;
    }

    public DonatorChoice getDonatorChoice() {
        return this.donatorChoice;
    }

    public void setDonatorChoice(DonatorChoice donatorChoice) {
        this.donatorChoice = donatorChoice;
        this.markDirty();
    }

    public void increaseMaxHP(double i) {
        if (this.entityPlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(this.healthModifier.func_111167_a()) != null) {
            this.entityPlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(this.healthModifier);
        }
        this.healthModifier = new AttributeModifier("Aether Health Modifier", i, 1);
        this.entityPlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(this.healthModifier);
        this.entityPlayer.func_70606_j(this.getHealth() + (float)i * 20.0f);
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    public void teleportToAether() {
        this.entityPlayer.field_71088_bW = this.entityPlayer.func_82147_ab();
        this.teleported = true;
        if (this.entityPlayer.field_70170_p.field_72995_K && Minecraft.func_71410_x().field_71439_g.func_145782_y() == this.entityPlayer.func_145782_y()) {
            Minecraft.func_71410_x().field_71439_g.func_85030_a("aether:aeportal.aetravel", 1.0f, 1.0f);
        }
        Aether.teleportPlayerToAether(this.entityPlayer, false);
        this.timeInPortal = 0.0f;
    }

    private float updateRotation(float par1, float par2, float par3) {
        float f3 = MathHelper.func_76142_g((float)(par2 - par1));
        if (f3 > par3) {
            f3 = par3;
        }
        if (f3 < -par3) {
            f3 = -par3;
        }
        return par1 + f3;
    }

    public void faceEntity(Entity par1Entity, float par2, float par3) {
        double d2;
        double d0 = par1Entity.field_70165_t - this.entityPlayer.field_70165_t;
        double d1 = par1Entity.field_70161_v - this.entityPlayer.field_70161_v;
        if (par1Entity instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)par1Entity;
            d2 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (this.entityPlayer.field_70163_u + (double)this.entityPlayer.func_70047_e());
        } else {
            d2 = (par1Entity.field_70121_D.field_72338_b + par1Entity.field_70121_D.field_72337_e) / 2.0 - (this.entityPlayer.field_70163_u + (double)this.entityPlayer.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        this.entityPlayer.field_70125_A = this.updateRotation(this.entityPlayer.field_70125_A, f3, par3);
        this.entityPlayer.field_70177_z = this.updateRotation(this.entityPlayer.field_70177_z, f2, par2);
    }

    public void addDungeonReward(List<AetherLoot.Choice> choices, ItemStack reward) {
        this.dungeonRewards.add(reward);
        int rewardAmount = 0;
        block0: for (AetherLoot.Choice choice : choices) {
            for (ItemStack stack : this.dungeonRewards) {
                if (stack == null || choice == null || choice.getItemID() != stack.func_77973_b() || choice.getItemDamage() != stack.func_77960_j()) continue;
                ++rewardAmount;
                continue block0;
            }
        }
        if (rewardAmount >= choices.size()) {
            this.dungeonRewards.clear();
        }
    }

    public boolean hasDungeonReward(ItemStack reward) {
        for (ItemStack stack : this.dungeonRewards) {
            if (stack == null || !stack.func_77969_a(reward)) continue;
            return true;
        }
        return false;
    }

    public void setLastSleptInDimension(int dimension) {
        this.lastBedDimension = dimension;
    }

    public int getLastSleptInDimension() {
        return this.lastBedDimension;
    }

    public boolean hasSleptInBed() {
        return this.sleptInBed;
    }

    public void setSleptInBed(boolean sleptInBed) {
        this.sleptInBed = sleptInBed;
    }

    public int getShardsUsed() {
        return this.shardsUsed;
    }

    public int getSpiritRepairTime() {
        return this.spiritRepairTime;
    }

    public void setSpiritRepairTime(int spiritRepairTime) {
        this.spiritRepairTime = spiritRepairTime;
        this.markDirty();
    }

    public boolean getBrokeSeal() {
        return this.brokeSeal;
    }

    public void setBrokeSeal(boolean brokeSeal) {
        this.brokeSeal = brokeSeal;
        this.markDirty();
    }

    public String getUsername() {
        return this.getProfile().getUsername();
    }

    public UUID getUniqueID() {
        return this.getProfile().getUUID();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public void markClean() {
        this.isDirty = false;
    }
}

