/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.player;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.AetherConfig;
import net.aetherteam.aether.donator.DonatorChoice;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.packets.AetherPacketHandler;
import net.aetherteam.aether.packets.PacketHolidayEventState;
import net.aetherteam.aether.packets.PacketPartyClientInfo;
import net.aetherteam.aether.packets.PacketPartyListChange;
import net.aetherteam.aether.party.MemberType;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.party.PartyController;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PlayerTracker {
    @SubscribeEvent
    public void PlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        this.onPlayerLogin(event.player);
    }

    @SubscribeEvent
    public void PlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        this.onPlayerLogout(event.player);
    }

    public void onPlayerLogin(EntityPlayer player) {
        Dungeon dungeon;
        PlayerAether playerInfo = PlayerAether.get(player);
        if (!playerInfo.isDonator()) {
            playerInfo.setDonator(DonatorChoice.isDonator(playerInfo.getUniqueID()));
        }
        if ((dungeon = playerInfo.getDungeon()) != null) {
            dungeon.getMembers().add(player);
        }
        playerInfo.loggedIn = true;
        playerInfo.markDirty();
        AetherPacketHandler.sendTo(new PacketPartyListChange(), (EntityPlayerMP)player);
        if (playerInfo.getParty() != null) {
            AetherPacketHandler.sendTo(new PacketPartyClientInfo(playerInfo.getParty()), (EntityPlayerMP)player);
        }
        AetherPacketHandler.sendTo(new PacketHolidayEventState(AetherConfig.EnableChristmasEvent), (EntityPlayerMP)player);
    }

    public void onPlayerLogout(EntityPlayer player) {
        Party party;
        PlayerAether playerInfo = PlayerAether.get(player);
        Dungeon dungeon = playerInfo.getDungeon();
        playerInfo.loggedIn = false;
        if (dungeon != null) {
            dungeon.getMembers().remove(player);
        }
        if ((party = playerInfo.getParty()) != null) {
            if (party.getLeader().getUniqueID().equals(playerInfo.getUniqueID())) {
                ArrayList<PlayerAether> members = new ArrayList<PlayerAether>(party.getAllMembers());
                PlayerAether newOwner = null;
                for (PlayerAether member : members) {
                    if (member.getUniqueID() == playerInfo.getUniqueID()) continue;
                    newOwner = member;
                    break;
                }
                if (newOwner != null) {
                    Aether.print("Party leader left party " + party.getName() + ", promoting next player...");
                    party.promoteTo(newOwner, MemberType.LEADER, playerInfo);
                } else {
                    Aether.print("Party leader left party " + party.getName() + ", deleting party since no other players are available.");
                    PartyController.instance().removeParty(party.getID(), playerInfo);
                }
            }
            party.leave(playerInfo, playerInfo);
        }
    }
}

