/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.player.abilities;

import com.gildedgames.util.io_manager.io.IOSyncable;
import io.netty.buffer.ByteBuf;
import net.aetherteam.aether.items.consumables.ItemCloudParachute;
import net.aetherteam.aether.player.PlayerAether;
import net.aetherteam.aether.player.abilities.Ability;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class AbilityParachute
extends Ability {
    private boolean isParachuting;
    private int parachuteType;
    private int hitAmnt;

    public AbilityParachute(PlayerAether player) {
        super(player);
    }

    @Override
    public boolean isWearing() {
        return this.isParachuting;
    }

    @Override
    public void onUpdate() {
        int x = MathHelper.func_76128_c((double)this.player.entityPlayer.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.player.entityPlayer.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.player.entityPlayer.field_70161_v);
        if (this.isParachuting) {
            Vec3 vec3 = this.player.entityPlayer.func_70040_Z();
            switch (this.parachuteType) {
                case 4: {
                    if (!(this.player.entityPlayer.field_70163_u >= (double)this.player.entityPlayer.field_70170_p.func_72940_L()) && !this.isUnderABlock(x, y, z)) break;
                    this.setParachuting(false, this.parachuteType);
                }
            }
            this.player.entityPlayer.field_70143_R = 0.0f;
            if (!this.isParachuting) {
                this.hitAmnt = 0;
            } else if (this.player.entityPlayer.field_110158_av >= 4 && this.isParachuting && vec3.field_72448_b >= 1.0 && !this.entityPlayer.field_70122_E) {
                ++this.hitAmnt;
            }
            if (this.parachuteType != 4 && (!this.player.entityPlayer.field_70170_p.func_147437_c(x, y - 1, z) || !this.isParachuting) || this.isParachuting && this.hitAmnt >= 4) {
                this.setParachuting(false, this.parachuteType);
            }
        }
    }

    public void setParachuting(boolean isParachuting, int parachuteType) {
        this.isParachuting = isParachuting;
        this.parachuteType = parachuteType;
        this.player.markDirty();
        if (!isParachuting && !this.player.entityPlayer.func_130014_f_().field_72995_K) {
            EntityItem item = new EntityItem(this.player.entityPlayer.func_130014_f_(), this.player.entityPlayer.field_70165_t, this.player.entityPlayer.field_70163_u, this.player.entityPlayer.field_70161_v, new ItemStack(Items.field_151007_F, 1));
            EntityItem block = new EntityItem(this.player.entityPlayer.func_130014_f_(), this.player.entityPlayer.field_70165_t, this.player.entityPlayer.field_70163_u, this.player.entityPlayer.field_70161_v, ItemCloudParachute.getMatchingAercloudStack(this.parachuteType, 2));
            this.player.entityPlayer.func_130014_f_().func_72838_d((Entity)block);
            this.player.entityPlayer.func_130014_f_().func_72838_d((Entity)item);
        }
    }

    private boolean isUnderABlock(int x, int y, int z) {
        AxisAlignedBB boundingBox = this.player.entityPlayer.field_70121_D;
        for (int x1 = (int)Math.floor(boundingBox.field_72340_a); x1 <= (int)Math.ceil(boundingBox.field_72336_d); ++x1) {
            for (int z1 = (int)Math.floor(boundingBox.field_72339_c); z1 <= (int)Math.ceil(boundingBox.field_72334_f); ++z1) {
                if (this.player.entityPlayer.field_70170_p.func_147437_c(x1, y + 1, z1) && this.player.entityPlayer.field_70170_p.func_147437_c(x1, y + 2, z1)) continue;
                return true;
            }
        }
        return false;
    }

    public int getParachuteType() {
        return this.parachuteType;
    }

    public boolean getIsParachuting() {
        return this.isParachuting;
    }

    @Override
    public void write(NBTTagCompound output) {
        output.func_74757_a("parachuting", this.isParachuting);
        output.func_74768_a("parachuteType", this.parachuteType);
    }

    @Override
    public void read(NBTTagCompound input) {
        this.isParachuting = input.func_74767_n("parachuting");
        this.parachuteType = input.func_74762_e("parachuteType");
    }

    @Override
    public void syncTo(ByteBuf dataOutput, IOSyncable.SyncSide to) {
        if (to.isClient()) {
            dataOutput.writeBoolean(this.isParachuting);
            dataOutput.writeInt(this.parachuteType);
        }
    }

    @Override
    public void syncFrom(ByteBuf dataInput, IOSyncable.SyncSide from) {
        if (from.isServer()) {
            this.isParachuting = dataInput.readBoolean();
            this.parachuteType = dataInput.readInt();
        }
    }
}

