/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.server.cloud_network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.aetherteam.aether.server.cloud_network.CloudServer;
import net.aetherteam.aether.server.cloud_network.CloudServerStatus;
import net.aetherteam.aether.server.cloud_network.CloudUpdateThread;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.PropertyManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerCloudNetwork {
    public static final Logger LOGGER = LogManager.getLogger((String)"CloudNetwork");
    public static final String REMOTE_CLOUD_ENDPOINT = "http://gilded-games.com/cloudnetwork/removeCloud?id=%s";
    public static final String ADD_CLOUD_ENDPOINT = "http://gilded-games.com/cloudnetwork/addCloud";
    public static final String CLOUD_HEARTBEAT_ENDPOINT = "http://gilded-games.com/cloudnetwork/heartbeat?id=%s";
    private static final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private static final List<String> modsToIgnore = Arrays.asList("Forge", "FML", "mcp");
    public static CloudServer server;
    public static String serverID;
    public static CloudServerStatus serverStatus;

    public static void start() {
        PropertyManager config = new PropertyManager(FMLCommonHandler.instance().getMinecraftServerInstance().func_71209_f("cloud-network.properties"));
        serverStatus = config.func_73670_a("cloud-visible", false) ? CloudServerStatus.NOT_REGISTERED : CloudServerStatus.DISABLED;
        DedicatedServer dedicatedServer = (DedicatedServer)FMLCommonHandler.instance().getMinecraftServerInstance();
        if (serverStatus == CloudServerStatus.NOT_REGISTERED) {
            String name = config.func_73671_a("cloud-name", "Cloud Server");
            String description = config.func_73671_a("cloud-description", "A Cloud Server.");
            String version = "1.7.10-1.6";
            int port = dedicatedServer.func_71234_u();
            server = new CloudServer(name, port, description, version, ServerCloudNetwork.getActiveMods());
            executorService.scheduleAtFixedRate(new CloudUpdateThread(), 0L, 30L, TimeUnit.SECONDS);
        }
        config.func_73668_b();
    }

    public static void stop() {
        executorService.shutdown();
        if (serverStatus == CloudServerStatus.REGISTERED) {
            LOGGER.info("Removing your cloud from the network...");
            ServerCloudNetwork.removeCloudServer();
        }
    }

    public static void removeCloudServer() {
        if (serverID == null) {
            return;
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(String.format(REMOTE_CLOUD_ENDPOINT, serverID)).openConnection();
            connection.setReadTimeout(3000);
            connection.setConnectTimeout(3000);
            InputStream stream = connection.getErrorStream() != null ? connection.getErrorStream() : connection.getInputStream();
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        serverID = null;
    }

    private static List<String> getActiveMods() {
        ArrayList<String> requiredMods = new ArrayList<String>();
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            if (modsToIgnore.contains(mod.getModId()) || !mod.acceptableMinecraftVersionRange().hasRestrictions()) continue;
            requiredMods.add(String.format("%s (%s)", mod.getName(), mod.getVersion()));
        }
        Collections.sort(requiredMods);
        return requiredMods;
    }
}

