/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.tile_entities;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.AetherEnchantment;
import net.aetherteam.aether.achievements.AetherAchievements;
import net.aetherteam.aether.entities.altar.EntityFakeItem;
import net.aetherteam.aether.items.AetherItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class TileEntityAltar
extends TileEntity
implements IInventory {
    private static List<AetherEnchantment> enchantments = new ArrayList<AetherEnchantment>();
    private final Random rand;
    private EntityFakeItem renderedItem = null;
    private EntityPlayer achievementPlayer;
    private ItemStack[] enchanterItemStacks = new ItemStack[3];
    public int enchantProgress = 0;
    public int enchantPowerRemaining = 0;
    public int enchantTimeForItem = 0;
    private final float ambRotationSpeed = 0.05f;
    private float ambRotation = 0.0f;
    private double ambSpinningSpeed = 0.0;
    private double itemFloatingSpeed = 0.0;
    private AetherEnchantment currentEnchantment;

    public TileEntityAltar() {
        this.rand = new Random();
    }

    public void setAchievementPlayer(EntityPlayer player) {
        this.achievementPlayer = player;
    }

    public int func_70302_i_() {
        return this.enchanterItemStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.enchanterItemStacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.enchanterItemStacks[i] != null) {
            if (this.enchanterItemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.enchanterItemStacks[i];
                this.enchanterItemStacks[i] = null;
                if (!this.field_145850_b.field_72995_K) {
                    this.sendToAllInOurWorld(this.func_145844_m());
                }
                return itemstack;
            }
            ItemStack itemstack1 = this.enchanterItemStacks[i].func_77979_a(j);
            if (this.enchanterItemStacks[i].field_77994_a == 0) {
                this.enchanterItemStacks[i] = null;
            }
            if (!this.field_145850_b.field_72995_K) {
                this.sendToAllInOurWorld(this.func_145844_m());
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.enchanterItemStacks[par1] != null) {
            ItemStack var2 = this.enchanterItemStacks[par1];
            this.enchanterItemStacks[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.enchanterItemStacks[i] = itemstack;
        if (i == 0) {
            this.currentEnchantment = null;
        }
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sendToAllInOurWorld(this.func_145844_m());
        }
    }

    public String func_145825_b() {
        return "Enchanter";
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.enchanterItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.enchanterItemStacks.length) continue;
            this.enchanterItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.enchantProgress = nbttagcompound.func_74765_d("BurnTime");
        this.enchantTimeForItem = nbttagcompound.func_74765_d("CookTime");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("BurnTime", (short)this.enchantProgress);
        nbttagcompound.func_74777_a("CookTime", (short)this.enchantTimeForItem);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.enchanterItemStacks.length; ++i) {
            if (this.enchanterItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.enchanterItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void addEnchantable(EntityPlayer player, ItemStack stack) {
        if (stack == null || !this.isEnchantable(stack)) {
            return;
        }
        ItemStack enchantableStack = this.func_70301_a(0);
        int stackSizeLimit = this.func_70297_j_();
        if (this.isLimitedToOne(stack)) {
            stackSizeLimit = 1;
        }
        if (enchantableStack == null) {
            if (stack.field_77994_a > stackSizeLimit) {
                enchantableStack = stack;
                enchantableStack.field_77994_a = stackSizeLimit;
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                this.func_70299_a(0, enchantableStack);
            } else {
                enchantableStack = stack;
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                this.func_70299_a(0, enchantableStack);
            }
        } else if (enchantableStack.func_77973_b() == stack.func_77973_b() && enchantableStack.func_77960_j() == stack.func_77960_j()) {
            if (this.canCombineStackWithRemainder(stack, enchantableStack, stackSizeLimit)) {
                this.combineStackWithRemainder(stack, enchantableStack, stackSizeLimit);
            } else if (this.stackIsFull(enchantableStack, stackSizeLimit)) {
                if (this.field_145850_b.field_72995_K) {
                    FMLClientHandler.instance().getClient().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText("Altar is at full capacity."));
                }
            } else {
                enchantableStack.field_77994_a += stack.field_77994_a;
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
        }
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.sendToAllInOurWorld(this.func_145844_m());
        }
    }

    public boolean canEnchant() {
        return this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150350_a;
    }

    public int getRemainingStackSize(ItemStack newStack, ItemStack currentStack, int stackSizeLimit) {
        if (this.canCombineStackWithRemainder(newStack, currentStack, stackSizeLimit)) {
            return currentStack.field_77994_a + newStack.field_77994_a - stackSizeLimit;
        }
        return 0;
    }

    public boolean canCombineStackWithRemainder(ItemStack newStack, ItemStack currentStack, int stackSizeLimit) {
        if (newStack.func_77973_b() != currentStack.func_77973_b() || newStack.func_77960_j() != currentStack.func_77960_j()) {
            return false;
        }
        if (this.stackIsFull(currentStack, stackSizeLimit)) {
            return false;
        }
        return currentStack.field_77994_a + newStack.field_77994_a > stackSizeLimit;
    }

    public boolean stackIsFull(ItemStack stack, int stackSizeLimit) {
        return stack.field_77994_a == stackSizeLimit;
    }

    public void combineStackWithRemainder(ItemStack newStack, ItemStack currentStack, int stackSizeLimit) {
        if (!this.canCombineStackWithRemainder(newStack, currentStack, stackSizeLimit)) {
            return;
        }
        newStack.field_77994_a = this.getRemainingStackSize(newStack, currentStack, stackSizeLimit);
        currentStack.field_77994_a = this.func_70297_j_();
    }

    public void addAmbrosium(EntityPlayer player, ItemStack stack) {
        if (stack == null || stack.func_77973_b() != AetherItems.AmbrosiumShard) {
            return;
        }
        ItemStack ambrosiumStack = this.func_70301_a(1);
        if (ambrosiumStack != null && ambrosiumStack.field_77994_a >= this.func_70297_j_()) {
            return;
        }
        if (ambrosiumStack == null) {
            ambrosiumStack = new ItemStack(AetherItems.AmbrosiumShard, 1, 0);
            this.func_70299_a(1, ambrosiumStack);
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
        } else {
            ++ambrosiumStack.field_77994_a;
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
        }
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.sendToAllInOurWorld(this.func_145844_m());
        }
    }

    public void dropNextStack() {
        if (this.enchanterItemStacks[1] != null) {
            if (!this.field_145850_b.field_72995_K) {
                EntityItem entityitem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 1.0f), (double)((float)this.field_145849_e + 0.5f), this.enchanterItemStacks[1]);
                entityitem.field_145804_b = 10;
                this.field_145850_b.func_72838_d((Entity)entityitem);
            }
            this.func_70298_a(1, this.enchanterItemStacks[1].field_77994_a);
        } else if (this.enchanterItemStacks[0] != null) {
            if (!this.field_145850_b.field_72995_K) {
                EntityItem entityitem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 1.0f), (double)((float)this.field_145849_e + 0.5f), this.enchanterItemStacks[0]);
                entityitem.field_145804_b = 10;
                this.field_145850_b.func_72838_d((Entity)entityitem);
            }
            this.func_70298_a(0, this.enchanterItemStacks[0].field_77994_a);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int i) {
        if (this.enchantTimeForItem == 0) {
            return 0;
        }
        return this.enchantProgress * i / this.enchantTimeForItem;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int i) {
        return this.enchantPowerRemaining * i / 500;
    }

    public boolean isBurning() {
        return this.enchantPowerRemaining > 0;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.renderedItem == null) {
                if (this.getEnchanterStacks(0) != null) {
                    this.renderedItem = new EntityFakeItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.15, (double)this.field_145849_e + 0.5, this.getEnchanterStacks(0));
                    this.field_145850_b.func_72838_d((Entity)this.renderedItem);
                }
            } else if (this.getEnchanterStacks(0) == null) {
                this.renderedItem.func_70106_y();
                this.renderedItem = null;
            }
        }
        this.itemFloatingSpeed = this.enchanterItemStacks[0] != null ? 0.03 : 0.0;
        if (this.enchanterItemStacks[1] != null) {
            float rotationSpeed = this.ambRotationSpeed * ((float)this.enchanterItemStacks[1].field_77994_a * 0.5f);
            this.ambRotation += rotationSpeed;
            double spinningSpeed = this.enchanterItemStacks[1].field_77994_a < 4 ? 0.2 * ((double)this.enchanterItemStacks[1].field_77994_a * 0.5) : 0.35;
            this.ambSpinningSpeed = spinningSpeed;
        } else {
            this.ambRotation = 0.0f;
            this.ambSpinningSpeed = 0.0;
        }
        if (this.currentEnchantment != null) {
            ItemStack inputStack = this.func_70301_a(0);
            ItemStack fuelStack = this.func_70301_a(1);
            if (this.canEnchant() && fuelStack != null && fuelStack.field_77994_a >= this.currentEnchantment.enchantAmbrosiumNeeded && inputStack != null) {
                Aether.proxy.spawnAltarParticles(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.rand);
                if (this.achievementPlayer != null) {
                    this.achievementPlayer.func_71029_a((StatBase)AetherAchievements.enchanter);
                }
                if (!this.field_145850_b.field_72995_K) {
                    ItemStack outputStack = this.currentEnchantment.getResult(this.rand);
                    outputStack.field_77994_a = 1;
                    outputStack.field_77990_d = inputStack.field_77990_d;
                    EntityItem entityitem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 1.0f), (double)((float)this.field_145849_e + 0.5f), outputStack);
                    entityitem.field_145804_b = 10;
                    this.field_145850_b.func_72838_d((Entity)entityitem);
                }
                this.func_70298_a(0, 1);
                this.func_70298_a(1, this.currentEnchantment.enchantAmbrosiumNeeded);
                this.currentEnchantment = null;
            }
        } else {
            ItemStack itemstack = this.func_70301_a(0);
            for (AetherEnchantment enchantment : enchantments) {
                ItemStack result = enchantment.getResult(this.rand);
                if (itemstack == null || itemstack.func_77973_b() != enchantment.getRequirement().func_77973_b() || itemstack.func_77960_j() != enchantment.getRequirement().func_77960_j() && !enchantment.repairing) continue;
                if (this.enchanterItemStacks[2] == null) {
                    this.currentEnchantment = enchantment;
                    continue;
                }
                if (this.enchanterItemStacks[2].func_77973_b() != result.func_77973_b() || result.func_77973_b().func_77639_j() <= this.enchanterItemStacks[2].field_77994_a) continue;
                this.currentEnchantment = enchantment;
            }
        }
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public static void addEnchantment(ItemStack from, ItemStack to, int i) {
        enchantments.add(new AetherEnchantment(from, to, i));
    }

    public static void addEnchantment(ItemStack from, ItemStack to, int i, boolean limit) {
        enchantments.add(new AetherEnchantment(from, to, i, limit));
    }

    public static void addEnchantment(ItemStack from, ItemStack to, int i, boolean limit, boolean repairing) {
        AetherEnchantment enchantment = new AetherEnchantment(from, to, i, limit);
        enchantment.repairing = repairing;
        enchantments.add(enchantment);
    }

    public static void addEnchantment(AetherEnchantment enchantment) {
        enchantments.add(enchantment);
    }

    public boolean isEnchantable(ItemStack stack) {
        for (AetherEnchantment enchantment : enchantments) {
            if (stack == null || enchantment == null || stack.func_77973_b() != enchantment.getRequirement().func_77973_b() || stack.func_77960_j() != enchantment.getRequirement().func_77960_j() && !enchantment.repairing) continue;
            return true;
        }
        return false;
    }

    public boolean isLimitedToOne(ItemStack stack) {
        for (AetherEnchantment enchantment : enchantments) {
            if (stack == null || enchantment == null || stack.func_77973_b() != enchantment.getRequirement().func_77973_b() || stack.func_77960_j() != enchantment.getRequirement().func_77960_j() || !enchantment.limitStackToOne) continue;
            return true;
        }
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, var1);
    }

    private void sendToAllInOurWorld(Packet pkt) {
        ServerConfigurationManager scm = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab();
        for (Object obj : scm.field_72404_b) {
            EntityPlayerMP player = (EntityPlayerMP)obj;
            if (player.field_70170_p != this.field_145850_b) continue;
            player.field_71135_a.func_147359_a(pkt);
        }
    }

    public ItemStack getEnchanterStacks(int index) {
        return this.enchanterItemStacks[index];
    }

    public float getAmbRotation() {
        return this.ambRotation;
    }

    public double getItemFloating() {
        if (this.field_145850_b.field_72995_K && Aether.isGamePaused()) {
            return 0.0;
        }
        return this.itemFloatingSpeed;
    }

    public double getAmbSpinning() {
        if (this.field_145850_b.field_72995_K && Aether.isGamePaused()) {
            return 0.0;
        }
        return this.ambSpinningSpeed;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }
}

