/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.tile_entities.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.aetherteam.aether.blocks.util.BlockMultiTileEntity;
import net.aetherteam.aether.blocks.util.IRotatable;
import net.aetherteam.aether.blocks.util.Rotation;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TileEntityMultiBlock
extends TileEntity
implements IRotatable {
    public AxisAlignedBB size = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    public Rotation rotation = Rotation.NORTH;
    public boolean hasInit = false;

    public void setSize(AxisAlignedBB size) {
        this.size = AxisAlignedBB.func_72330_a((double)size.field_72340_a, (double)size.field_72338_b, (double)size.field_72339_c, (double)size.field_72336_d, (double)size.field_72337_e, (double)size.field_72334_f);
        this.size.field_72340_a += (double)this.field_145851_c;
        this.size.field_72338_b += (double)this.field_145848_d;
        this.size.field_72339_c += (double)this.field_145849_e;
        this.size.field_72336_d += (double)this.field_145851_c;
        this.size.field_72337_e += (double)this.field_145848_d;
        this.size.field_72334_f += (double)this.field_145849_e;
    }

    public AxisAlignedBB getSize() {
        return this.size;
    }

    public int getWidth() {
        return (int)(this.size.field_72336_d - this.size.field_72340_a + 1.0);
    }

    public int getHeight() {
        return (int)(this.size.field_72337_e - this.size.field_72338_b + 1.0);
    }

    public int getLength() {
        return (int)(this.size.field_72334_f - this.size.field_72339_c + 1.0);
    }

    public Object iterateSize(Action action, World world) {
        return this.iterateSize(this.size, action, world);
    }

    public Object iterateSize(AxisAlignedBB size, Action action, World world) {
        int minX = MathHelper.func_76128_c((double)size.field_72340_a);
        int minY = MathHelper.func_76128_c((double)size.field_72338_b);
        int minZ = MathHelper.func_76128_c((double)size.field_72339_c);
        int maxX = MathHelper.func_76128_c((double)size.field_72336_d);
        int maxY = MathHelper.func_76128_c((double)size.field_72337_e);
        int maxZ = MathHelper.func_76128_c((double)size.field_72334_f);
        for (int x1 = minX; x1 < maxX; ++x1) {
            for (int y1 = minY; y1 < maxY; ++y1) {
                for (int z1 = minZ; z1 < maxZ; ++z1) {
                    Object object = action.onAction(world, x1, y1, z1, world.func_147439_a(x1, y1, z1), world.func_72805_g(x1, y1, z1));
                    if (!action.shouldReturnObject(world, x1, y1, z1)) continue;
                    return object;
                }
            }
        }
        return null;
    }

    public void setRotationAndRefresh(Rotation rotation) {
        this.rotation = rotation;
        this.hasInit = false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        double minX = nbt.func_74769_h("minX");
        double minY = nbt.func_74769_h("minY");
        double minZ = nbt.func_74769_h("minZ");
        double maxX = nbt.func_74769_h("maxX");
        double maxY = nbt.func_74769_h("maxY");
        double maxZ = nbt.func_74769_h("maxZ");
        this.size = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        this.rotation = !nbt.func_74779_i("rotation").isEmpty() ? Rotation.valueOf(nbt.func_74779_i("rotation")) : null;
        this.hasInit = nbt.func_74767_n("hasInit");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("minX", this.size.field_72340_a);
        nbt.func_74780_a("minY", this.size.field_72338_b);
        nbt.func_74780_a("minZ", this.size.field_72339_c);
        nbt.func_74780_a("maxX", this.size.field_72336_d);
        nbt.func_74780_a("maxY", this.size.field_72337_e);
        nbt.func_74780_a("maxZ", this.size.field_72334_f);
        nbt.func_74778_a("rotation", this.rotation.name());
        nbt.func_74757_a("hasInit", this.hasInit);
    }

    @Override
    public void rotate(World world, Rotation rotation, int x, int y, int z) {
        if (rotation != null) {
            rotation.rotate(world, this, x, y, z);
        }
    }

    @Override
    public void rotate(World world, boolean clockwise, int x, int y, int z) {
        int width = this.getWidth();
        int length = this.getLength();
        this.size.field_72340_a = this.size.field_72340_a + (double)(width / 2) - (double)(length / 2);
        this.size.field_72339_c = this.size.field_72339_c + (double)(length / 2) - (double)(width / 2);
        this.size.field_72336_d = this.size.field_72340_a + (double)length - 1.0;
        this.size.field_72334_f = this.size.field_72339_c + (double)width - 1.0;
    }

    @Override
    public Rotation getCurrentRotation(World world, int x, int y, int z) {
        return this.rotation;
    }

    @Override
    public void setCurrentRotation(World world, Rotation rotation, int x, int y, int z) {
        this.rotation = rotation;
    }

    public void func_145845_h() {
        BlockMultiTileEntity block;
        Action checkLoadedChunks;
        Object checked;
        if (!this.hasInit && this.func_145838_q() instanceof BlockMultiTileEntity && !((checked = this.iterateSize(checkLoadedChunks = new Action((Block)(block = (BlockMultiTileEntity)this.func_145838_q())){

            @Override
            public Object onAction(World world, int x, int y, int z, Block blockID, int blockMetadata) {
                return false;
            }

            @Override
            public boolean shouldReturnObject(World world, int x, int y, int z) {
                Chunk chunk = world.func_72938_d(x, z);
                return chunk == null || !chunk.field_76636_d;
            }
        }, this.field_145850_b)) instanceof Boolean)) {
            block.func_149689_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, null, null);
            this.hasInit = true;
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, var1);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public static abstract class Action {
        protected Block block;
        protected int startX;
        protected int startY;
        protected int startZ;

        public Action(Block block) {
            this.block = block;
        }

        public Action(Block block, int startX, int startY, int startZ) {
            this(block);
            this.startX = startX;
            this.startY = startY;
            this.startZ = startZ;
        }

        public abstract Object onAction(World var1, int var2, int var3, int var4, Block var5, int var6);

        public abstract boolean shouldReturnObject(World var1, int var2, int var3, int var4);
    }
}

