/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.worldgen;

import java.util.Random;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.worldgen.ChunkProviderAether;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class AetherGenLargeTree
extends WorldGenAbstractTree {
    private Block leafBlock;
    private Block logBlock;
    private int logMetadata;

    public AetherGenLargeTree(Block leafID, Block logID, int logMeta) {
        super(true);
        this.leafBlock = leafID;
        this.logBlock = logID;
        this.logMetadata = logMeta;
    }

    public boolean branch(World world, Random random, int i, int j, int k, int slant) {
        int directionX = random.nextInt(3) - 1;
        int directionY = slant;
        int directionZ = random.nextInt(3) - 1;
        int x = i;
        int z = k;
        for (int n = 0; n < 2; ++n) {
            x -= directionX;
            z -= directionZ;
            if (world.func_147439_a(i += directionX, j += directionY, k += directionZ) != this.leafBlock) continue;
            world.func_147465_d(i, j, k, this.logBlock, this.logMetadata, ChunkProviderAether.placementFlagType);
            world.func_147465_d(x, j, z, this.logBlock, this.logMetadata, ChunkProviderAether.placementFlagType);
        }
        return true;
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        int height = 11;
        boolean flag = true;
        if (j < 1 || j + height + 1 > 128) {
            return false;
        }
        for (int i1 = j; i1 <= j + 1 + height; ++i1) {
            int byte0 = 1;
            if (i1 == j) {
                byte0 = 0;
            }
            if (i1 >= j + 1 + height - 2) {
                byte0 = 2;
            }
            for (int i2 = i - byte0; i2 <= i + byte0 && flag; ++i2) {
                for (int l2 = k - byte0; l2 <= k + byte0 && flag; ++l2) {
                    if (i1 >= 0 && i1 < 128) {
                        Block j3 = world.func_147439_a(i2, i1, l2);
                        if (j3 == Blocks.field_150350_a || j3 == this.leafBlock) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        for (int y = j; y < j + height; ++y) {
            if (this.isReplaceable(world, i, y, k)) continue;
            return false;
        }
        if (world.func_147439_a(i, j - 1, k) != AetherBlocks.AetherGrass && world.func_147439_a(i, j - 1, k) != AetherBlocks.AetherDirt) {
            return false;
        }
        for (int x = i - 3; x < i + 5; ++x) {
            for (int y = j + 5; y < j + 13; ++y) {
                for (int z = k - 3; z < k + 5; ++z) {
                    if ((x - i) * (x - i) + (y - j - 8) * (y - j - 8) + (z - k) * (z - k) >= 12 + random.nextInt(5) || world.func_147439_a(x, y, z) != Blocks.field_150350_a) continue;
                    world.func_147449_b(x, y, z, this.leafBlock);
                }
            }
        }
        for (int n = 0; n < height - 2; ++n) {
            if (n > 4) {
                this.branch(world, random, i, j + n, k, n / 4 - 1);
            }
            if (!this.isReplaceable(world, i, j + n, k)) continue;
            world.func_147465_d(i, j + n, k, this.logBlock, this.logMetadata, ChunkProviderAether.placementFlagType);
        }
        return true;
    }
}

