/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import xaero.common.IXaeroMinimap;
import xaero.common.message.LevelMapPropertiesConsumer;
import xaero.common.server.events.ServerEvents;
import xaero.common.server.level.LevelMapProperties;
import xaero.common.server.level.LevelMapPropertiesIO;

public class XaeroMinimapServer {
    private IXaeroMinimap modMain;
    private Map<Path, LevelMapProperties> levelProperties;
    private LevelMapPropertiesIO propertiesIO;
    private ServerEvents serverEvents;

    public XaeroMinimapServer(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.levelProperties = new HashMap<Path, LevelMapProperties>();
        this.propertiesIO = new LevelMapPropertiesIO();
    }

    public void load(FMLInitializationEvent event) {
        System.out.println("Loading Xaero's Minimap - Stage 1/2 (Server)");
        this.serverEvents = new ServerEvents(this);
        MinecraftForge.EVENT_BUS.register((Object)this.serverEvents);
        FMLCommonHandler.instance().bus().register((Object)this.serverEvents);
    }

    public void loadLater() {
        System.out.println("Loading Xaero's Minimap - Stage 2/2 (Server)");
        this.modMain.getNetwork().registerMessage(LevelMapPropertiesConsumer.class, LevelMapProperties.class, 0, Side.CLIENT);
    }

    public LevelMapProperties getLevelProperties(Path path) {
        LevelMapProperties properties = this.levelProperties.get(path);
        if (properties == null) {
            properties = new LevelMapProperties();
            try {
                this.propertiesIO.load(path, properties);
            }
            catch (FileNotFoundException fnfe) {
                this.propertiesIO.save(path, properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.levelProperties.put(path, properties);
        }
        return properties;
    }

    public IXaeroMinimap getModMain() {
        return this.modMain;
    }

    public ServerEvents getServerEvents() {
        return this.serverEvents;
    }
}

