/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.items;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import zabi.minecraft.extraalchemy.ExtraAlchemy;
import zabi.minecraft.extraalchemy.config.ModConfig;
import zabi.minecraft.extraalchemy.items.ItemSettings;
import zabi.minecraft.extraalchemy.items.ModItems;
import zabi.minecraft.extraalchemy.utils.PlayerLevelUtil;

public class PotionRingItem
extends class_1792 {
    public PotionRingItem() {
        super(new class_1792.class_1793().method_7892(ItemSettings.EXTRA_ALCHEMY_GROUP).method_7889(1));
    }

    public void method_7850(class_1761 group, class_2371<class_1799> stacks) {
        try {
            if (this.method_7877(group) && ModConfig.INSTANCE.enableRings && class_310.method_1551().field_1687 != null) {
                class_310.method_1551().field_1687.method_8433().method_8126().stream().filter(r -> r.method_8110().method_7909().equals((Object)ModItems.POTION_RING)).forEach(rec -> stacks.add((Object)rec.method_8110()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean method_7886(class_1799 stack) {
        return !stack.method_7948().method_10577("disabled");
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        try {
            if (class_1844.method_8067((class_1799)stack).size() != 1) {
                tooltip.add((class_2561)new class_2585("Error: rings must have exactly 1 effect attached!").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}));
                return;
            }
            class_1293 sei = (class_1293)class_1844.method_8067((class_1799)stack).get(0);
            class_5250 potionName = new class_2588(sei.method_5586()).method_27692(class_124.field_1064);
            class_5250 potionLevel = new class_2588("potion.potency." + sei.method_5578()).method_27692(class_124.field_1064);
            tooltip.add((class_2561)new class_2588("item.extraalchemy.potion_ring.potion", new Object[]{potionName, potionLevel}));
            class_2487 tag = stack.method_7948();
            int cost = tag.method_10550("cost");
            if (cost > 0) {
                tooltip.add((class_2561)new class_2588("item.extraalchemy.potion_ring.cost", new Object[]{new class_2585("" + cost).method_27692(class_124.field_1065)}));
            } else {
                tooltip.add((class_2561)new class_2588("item.extraalchemy.potion_ring.creative").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}));
            }
            tooltip.add((class_2561)new class_2588("item.extraalchemy.potion_ring.length", new Object[]{new class_2585("" + tag.method_10550("length")).method_27692(class_124.field_1078)}));
            if (tag.method_10577("disabled")) {
                tooltip.add((class_2561)new class_2588("item.extraalchemy.potion_ring.disabled").method_27692(class_124.field_1065));
            } else {
                tooltip.add((class_2561)new class_2588("item.extraalchemy.potion_ring.enabled").method_27692(class_124.field_1060));
            }
        }
        catch (Exception e) {
            tooltip.add((class_2561)new class_2585("An error occurred when displaying the tooltip.").method_27692(class_124.field_1061));
            tooltip.add((class_2561)new class_2585("Destroy this item ASAP to avoid crashes.").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
            tooltip.add((class_2561)new class_2585(e.getMessage()).method_27692(class_124.field_1063));
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (user.method_5715()) {
            PotionRingItem.toggleRingStack(stack);
            return new class_1271(class_1269.field_5812, (Object)stack);
        }
        return new class_1271(class_1269.field_5814, (Object)stack);
    }

    public static class_1799 toggleRingStack(class_1799 stack) {
        class_2487 tag;
        tag.method_10556("disabled", !(tag = stack.method_7948()).method_10577("disabled"));
        return stack;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!ExtraAlchemy.areRingModsInstalled() || ModConfig.INSTANCE.allowRingsInInventoryWithThirdPartyMods) {
            PotionRingItem.onTick(stack, entity);
        }
    }

    public static void onTick(class_1799 stack, class_1297 entity) {
        if (!stack.method_7948().method_10577("disabled") && entity instanceof class_1309) {
            class_1309 e = (class_1309)entity;
            for (class_1293 sei : class_1844.method_8067((class_1799)stack)) {
                class_1291 statusEffect = sei.method_5579();
                class_1293 onEntity = e.method_6112(statusEffect);
                if (onEntity != null && onEntity.method_5584() > stack.method_7969().method_10550("renew") * 20 || !PotionRingItem.drainXP(e, stack.method_7969().method_10550("cost"))) continue;
                int length = stack.method_7969().method_10550("length");
                e.method_6092(new class_1293(statusEffect, length * 20, sei.method_5578(), false, false, true));
            }
        }
    }

    private static boolean drainXP(class_1309 e, int cost) {
        if (cost <= 0 || !(e instanceof class_1657)) {
            return true;
        }
        class_1657 p = (class_1657)e;
        if (p.method_7337()) {
            return true;
        }
        if (PlayerLevelUtil.getPlayerXP(p) < cost) {
            return false;
        }
        PlayerLevelUtil.addPlayerXP(p, -cost);
        return true;
    }
}

