/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.inventory;

import de.siphalor.mousewheelie.MWConfig;
import de.siphalor.mousewheelie.client.inventory.CreativeContainerScreenHelper;
import de.siphalor.mousewheelie.client.network.ClickEventFactory;
import de.siphalor.mousewheelie.client.network.InteractionManager;
import de.siphalor.mousewheelie.client.util.accessors.ISlot;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_485;

@Environment(value=EnvType.CLIENT)
public class ContainerScreenHelper<T extends class_465<?>> {
    protected final T screen;
    protected final ClickEventFactory clickEventFactory;
    protected final IntSet lockedSlots = new IntRBTreeSet();
    public static final int INVALID_SCOPE = Integer.MAX_VALUE;

    protected ContainerScreenHelper(T screen, ClickEventFactory clickEventFactory) {
        this.screen = screen;
        this.clickEventFactory = clickEventFactory;
    }

    public static <T extends class_465<?>> ContainerScreenHelper<T> of(T screen, ClickEventFactory clickEventFactory) {
        if (screen instanceof class_481) {
            return new CreativeContainerScreenHelper<class_481>((class_481)screen, clickEventFactory);
        }
        return new ContainerScreenHelper<T>(screen, clickEventFactory);
    }

    public InteractionManager.InteractionEvent createClickEvent(class_1735 slot, int action, class_1713 actionType) {
        if (this.lockedSlots.contains(slot.field_7874)) {
            return null;
        }
        return this.clickEventFactory.create(slot, action, actionType);
    }

    public boolean isSlotLocked(class_1735 slot) {
        return this.lockedSlots.contains(slot.field_7874);
    }

    public void lockSlot(class_1735 slot) {
        this.lockedSlots.add(slot.field_7874);
    }

    public void unlockSlot(class_1735 slot) {
        this.lockedSlots.remove(slot.field_7874);
    }

    private InteractionManager.InteractionEvent unlockAfter(InteractionManager.InteractionEvent event, class_1735 slot) {
        if (event == null) {
            return null;
        }
        return new InteractionManager.CallbackEvent(() -> {
            InteractionManager.Waiter waiter = event.send();
            this.unlockSlot(slot);
            return waiter;
        });
    }

    public void scroll(class_1735 referenceSlot, boolean scrollUp) {
        boolean shallSend;
        if (MWConfig.scrolling.directionalScrolling) {
            shallSend = this.shallChangeInventory(referenceSlot, scrollUp);
        } else {
            shallSend = !scrollUp;
            scrollUp = false;
        }
        if (shallSend) {
            if (!referenceSlot.method_7680(class_1799.field_8037)) {
                this.sendStack(referenceSlot);
            }
            if (class_437.method_25441()) {
                this.sendAllOfAKind(referenceSlot);
            } else if (class_437.method_25442()) {
                this.sendStack(referenceSlot);
            } else {
                this.sendSingleItem(referenceSlot);
            }
        } else {
            class_1799 referenceStack = referenceSlot.method_7677().method_7972();
            int referenceScope = this.getScope(referenceSlot);
            if (class_437.method_25442() || class_437.method_25441()) {
                for (class_1735 slot : this.screen.method_17577().field_7761) {
                    if (this.getScope(slot) == referenceScope || !slot.method_7677().method_7962(referenceStack)) continue;
                    this.sendStack(slot);
                    if (class_437.method_25441()) continue;
                    break;
                }
            } else {
                class_1735 moveSlot = null;
                int stackSize = Integer.MAX_VALUE;
                for (class_1735 slot : this.screen.method_17577().field_7761) {
                    if (this.getScope(slot) == referenceScope || this.getScope(slot) <= 0 != scrollUp || !slot.method_7677().method_7962(referenceStack) || slot.method_7677().method_7947() >= stackSize) continue;
                    stackSize = slot.method_7677().method_7947();
                    moveSlot = slot;
                    if (stackSize != 1) continue;
                    break;
                }
                if (moveSlot != null) {
                    this.sendSingleItem(moveSlot);
                }
            }
        }
    }

    public boolean shallChangeInventory(class_1735 slot, boolean scrollUp) {
        return this.getScope(slot) <= 0 == scrollUp;
    }

    public boolean isHotbarSlot(class_1735 slot) {
        return ((ISlot)slot).mouseWheelie_getInvSlot() < 9;
    }

    public int getScope(class_1735 slot) {
        if (slot.field_7871 == null || ((ISlot)slot).mouseWheelie_getInvSlot() >= slot.field_7871.method_5439() || !slot.method_7680(class_1799.field_8037)) {
            return Integer.MAX_VALUE;
        }
        if (this.screen instanceof class_485) {
            if (slot.field_7871 instanceof class_1661) {
                if (this.isHotbarSlot(slot)) {
                    return 0;
                }
                if (((ISlot)slot).mouseWheelie_getInvSlot() >= 40) {
                    return -1;
                }
                return 1;
            }
            return 2;
        }
        if (slot.field_7871 instanceof class_1661) {
            if (MWConfig.general.hotbarScope && this.isHotbarSlot(slot)) {
                return -1;
            }
            return 0;
        }
        return 1;
    }

    public void runInScope(int scope, Consumer<class_1735> slotConsumer) {
        for (class_1735 slot : this.screen.method_17577().field_7761) {
            if (this.getScope(slot) != scope) continue;
            slotConsumer.accept(slot);
        }
    }

    public void sendSingleItem(class_1735 slot) {
        if (this.lockedSlots.contains(slot.field_7874)) {
            return;
        }
        InteractionManager.push(this.clickEventFactory.create(slot, 0, class_1713.field_7790));
        InteractionManager.push(this.clickEventFactory.create(slot, 1, class_1713.field_7790));
        InteractionManager.push(this.clickEventFactory.create(slot, 0, class_1713.field_7794));
        InteractionManager.push(this.clickEventFactory.create(slot, 0, class_1713.field_7790));
    }

    public void sendSingleItemLocked(class_1735 slot) {
        if (this.lockedSlots.contains(slot.field_7874)) {
            return;
        }
        this.lockedSlots.add(slot.field_7874);
        InteractionManager.push(this.clickEventFactory.create(slot, 0, class_1713.field_7790));
        InteractionManager.push(this.clickEventFactory.create(slot, 1, class_1713.field_7790));
        InteractionManager.push(this.clickEventFactory.create(slot, 0, class_1713.field_7794));
        InteractionManager.push(this.unlockAfter(this.clickEventFactory.create(slot, 0, class_1713.field_7790), slot));
    }

    public void sendStack(class_1735 slot) {
        InteractionManager.push(this.createClickEvent(slot, 0, class_1713.field_7794));
    }

    public void sendStackLocked(class_1735 slot) {
        if (this.lockedSlots.contains(slot.field_7874)) {
            return;
        }
        this.lockedSlots.add(slot.field_7874);
        InteractionManager.push(this.unlockAfter(this.clickEventFactory.create(slot, 0, class_1713.field_7794), slot));
    }

    public void sendAllOfAKind(class_1735 referenceSlot) {
        class_1799 referenceStack = referenceSlot.method_7677().method_7972();
        this.runInScope(this.getScope(referenceSlot), slot -> {
            if (slot.method_7677().method_7962(referenceStack)) {
                this.sendStack((class_1735)slot);
            }
        });
    }

    public void sendAllFrom(class_1735 referenceSlot) {
        this.runInScope(this.getScope(referenceSlot), this::sendStack);
    }

    public void dropStack(class_1735 slot) {
        if (this.lockedSlots.contains(slot.field_7874)) {
            return;
        }
        InteractionManager.push(this.createClickEvent(slot, 1, class_1713.field_7795));
    }

    public void dropStackLocked(class_1735 slot) {
        if (this.lockedSlots.contains(slot.field_7874)) {
            return;
        }
        this.lockedSlots.add(slot.field_7874);
        InteractionManager.push(this.unlockAfter(this.clickEventFactory.create(slot, 1, class_1713.field_7795), slot));
    }

    public void dropAllOfAKind(class_1735 referenceSlot) {
        class_1799 referenceStack = referenceSlot.method_7677().method_7972();
        this.runInScope(this.getScope(referenceSlot), slot -> {
            if (slot.method_7677().method_7962(referenceStack)) {
                this.dropStack((class_1735)slot);
            }
        });
    }

    public void dropAllFrom(class_1735 referenceSlot) {
        this.runInScope(this.getScope(referenceSlot), this::dropStack);
    }
}

