/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.inventory.sort;

import de.siphalor.mousewheelie.client.inventory.ContainerScreenHelper;
import de.siphalor.mousewheelie.client.inventory.sort.SortContext;
import de.siphalor.mousewheelie.client.inventory.sort.SortMode;
import de.siphalor.mousewheelie.client.network.InteractionManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_465;
import org.apache.commons.lang3.ArrayUtils;

@Environment(value=EnvType.CLIENT)
public class InventorySorter {
    private final class_465<?> containerScreen;
    private List<class_1735> inventorySlots;
    private final class_1799[] stacks;

    public InventorySorter(class_465<?> containerScreen, class_1735 originSlot) {
        this.containerScreen = containerScreen;
        this.collectSlots(originSlot);
        this.stacks = (class_1799[])this.inventorySlots.stream().map(slot -> slot.method_7677().method_7972()).toArray(class_1799[]::new);
    }

    private void collectSlots(class_1735 originSlot) {
        this.inventorySlots = new ArrayList<class_1735>();
        ContainerScreenHelper<class_465<?>> screenHelper = ContainerScreenHelper.of(this.containerScreen, (slot, data, slotActionType) -> null);
        int originScope = screenHelper.getScope(originSlot);
        if (originScope == Integer.MAX_VALUE) {
            return;
        }
        for (class_1735 slot2 : this.containerScreen.method_17577().field_7761) {
            if (originScope != screenHelper.getScope(slot2)) continue;
            this.inventorySlots.add(slot2);
        }
    }

    private void combineStacks() {
        ArrayDeque<InteractionManager.ClickEvent> clickEvents = new ArrayDeque<InteractionManager.ClickEvent>();
        for (int i = this.stacks.length - 1; i >= 0; --i) {
            int stackSize;
            class_1799 stack = this.stacks[i];
            if (stack.method_7960() || (stackSize = stack.method_7947()) >= stack.method_7909().method_7882()) continue;
            clickEvents.add(new InteractionManager.ClickEvent(this.containerScreen.method_17577().field_7763, this.inventorySlots.get((int)i).field_7874, 0, class_1713.field_7790));
            for (int j = 0; j < i; ++j) {
                class_1799 targetStack = this.stacks[j];
                if (targetStack.method_7960() || targetStack.method_7947() >= targetStack.method_7909().method_7882() || stack.method_7909() != targetStack.method_7909() || !class_1799.method_7975((class_1799)stack, (class_1799)targetStack)) continue;
                int delta = targetStack.method_7909().method_7882() - targetStack.method_7947();
                delta = Math.min(delta, stackSize);
                targetStack.method_7939(targetStack.method_7947() + delta);
                clickEvents.add(new InteractionManager.ClickEvent(this.containerScreen.method_17577().field_7763, this.inventorySlots.get((int)j).field_7874, 0, class_1713.field_7790));
                if ((stackSize -= delta) <= 0) break;
            }
            if (clickEvents.size() <= 1) {
                clickEvents.clear();
                continue;
            }
            InteractionManager.interactionEventQueue.addAll(clickEvents);
            InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
            clickEvents.clear();
            if (stackSize > 0) {
                InteractionManager.pushClickEvent(this.containerScreen.method_17577().field_7763, this.inventorySlots.get((int)i).field_7874, 0, class_1713.field_7790);
                stack.method_7939(stackSize);
                continue;
            }
            this.stacks[i] = class_1799.field_8037;
        }
    }

    public void sort(SortMode sortMode) {
        int i;
        this.combineStacks();
        int slotCount = this.stacks.length;
        int[] sortIds = new int[slotCount];
        for (int i2 = 0; i2 < sortIds.length; ++i2) {
            sortIds[i2] = i2;
        }
        sortIds = sortMode.sort(sortIds, this.stacks, new SortContext(this.containerScreen, this.inventorySlots));
        BitSet doneSlashEmpty = new BitSet(slotCount * 2);
        for (i = 0; i < slotCount; ++i) {
            if (i == sortIds[i]) {
                doneSlashEmpty.set(i);
                continue;
            }
            if (!this.stacks[i].method_7960()) continue;
            doneSlashEmpty.set(slotCount + i);
        }
        block2: for (i = 0; i < slotCount; ++i) {
            if (doneSlashEmpty.get(i)) continue;
            if (doneSlashEmpty.get(slotCount + sortIds[i])) {
                doneSlashEmpty.set(sortIds[i]);
                continue;
            }
            int syncId = this.containerScreen.method_17577().field_7763;
            InteractionManager.pushClickEvent(syncId, this.inventorySlots.get((int)sortIds[i]).field_7874, 0, class_1713.field_7790);
            doneSlashEmpty.set(slotCount + sortIds[i]);
            class_1799 currentStack = this.stacks[sortIds[i]];
            int workingSlotId = this.inventorySlots.get((int)sortIds[i]).field_7874;
            int id = i;
            do {
                if (this.stacks[id].method_7909() == currentStack.method_7909() && !doneSlashEmpty.get(slotCount + id) && class_1799.method_7975((class_1799)this.stacks[id], (class_1799)currentStack)) {
                    if (this.stacks[id].method_7947() == currentStack.method_7947()) {
                        doneSlashEmpty.set(id);
                        id = ArrayUtils.indexOf((int[])sortIds, (int)id);
                        continue;
                    }
                    if (currentStack.method_7947() < this.stacks[id].method_7947()) {
                        int targetSlotId = this.inventorySlots.get((int)id).field_7874;
                        InteractionManager.pushClickEvent(syncId, workingSlotId, 0, class_1713.field_7790);
                        InteractionManager.pushClickEvent(syncId, targetSlotId, 0, class_1713.field_7790);
                        InteractionManager.pushClickEvent(syncId, workingSlotId, 0, class_1713.field_7790);
                        InteractionManager.pushClickEvent(syncId, targetSlotId, 0, class_1713.field_7790);
                        InteractionManager.pushClickEvent(syncId, workingSlotId, 0, class_1713.field_7790);
                        currentStack = this.stacks[id];
                        doneSlashEmpty.set(id);
                        id = ArrayUtils.indexOf((int[])sortIds, (int)id);
                        continue;
                    }
                }
                InteractionManager.pushClickEvent(syncId, this.inventorySlots.get((int)id).field_7874, 0, class_1713.field_7790);
                currentStack = this.stacks[id];
                doneSlashEmpty.set(id);
                if (doneSlashEmpty.get(slotCount + id)) continue block2;
                id = ArrayUtils.indexOf((int[])sortIds, (int)id);
            } while (!doneSlashEmpty.get(id));
        }
    }
}

