/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.inventory.sort;

import de.siphalor.mousewheelie.client.inventory.sort.SortContext;
import de.siphalor.tweed4.tailor.DropdownMaterial;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2561;

public abstract class SortMode
implements DropdownMaterial<SortMode> {
    private static final Map<String, SortMode> SORT_MODES = new HashMap<String, SortMode>();
    private final String name;
    public static final SortMode NONE = SortMode.register("none", new SortMode("none"){});
    public static final SortMode ALPHABET = SortMode.register("alphabet", new SortMode("alphabet"){
        String[] strings;
        class_1799[] stacks;

        @Override
        public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
            this.stacks = stacks;
            this.strings = new String[sortIds.length];
            for (int i = 0; i < sortIds.length; ++i) {
                class_1799 stack = stacks[i];
                this.strings[i] = stack.method_7960() ? "" : stack.method_7964().getString();
            }
            IntArrays.quickSort((int[])sortIds, (a, b) -> {
                if (this.strings[a].equals("")) {
                    if (this.strings[b].equals("")) {
                        return 0;
                    }
                    return 1;
                }
                if (this.strings[b].equals("")) {
                    return -1;
                }
                int comp = this.strings[a].compareToIgnoreCase(this.strings[b]);
                if (comp == 0) {
                    return 2.compareEqualItems(stacks[a], stacks[b]);
                }
                return comp;
            });
            return sortIds;
        }
    });
    public static final SortMode QUANTITY = SortMode.register("quantity", new SortMode("quantity"){

        @Override
        public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
            HashMap<class_1792, Integer> itemToAmountMap = new HashMap<class_1792, Integer>();
            for (class_1799 stack : stacks) {
                if (stack.method_7960()) continue;
                if (!itemToAmountMap.containsKey(stack.method_7909())) {
                    itemToAmountMap.put(stack.method_7909(), stack.method_7947());
                    continue;
                }
                itemToAmountMap.put(stack.method_7909(), (Integer)itemToAmountMap.get(stack.method_7909()) + stack.method_7947());
            }
            IntArrays.quickSort((int[])sortIds, (a, b) -> {
                class_1799 stack = stacks[a];
                class_1799 stack2 = stacks[b];
                if (stack.method_7960()) {
                    return stack2.method_7960() ? 0 : 1;
                }
                if (stack2.method_7960()) {
                    return -1;
                }
                Integer amountA = (Integer)itemToAmountMap.get(stack.method_7909());
                Integer amountB = (Integer)itemToAmountMap.get(stack2.method_7909());
                int cmp = Integer.compare(amountB, amountA);
                if (cmp != 0) {
                    return cmp;
                }
                return 3.compareEqualItems(stack, stack2);
            });
            return sortIds;
        }
    });
    public static final SortMode RAW_ID = SortMode.register("raw_id", new SortMode("raw_id"){

        @Override
        public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
            Integer[] rawIds = (Integer[])Arrays.stream(stacks).map(stack -> stack.method_7960() ? Integer.MAX_VALUE : class_2378.field_11142.method_10206((Object)stack.method_7909())).toArray(Integer[]::new);
            IntArrays.quickSort((int[])sortIds, (a, b) -> {
                int cmp = Integer.compare(rawIds[a], rawIds[b]);
                if (cmp != 0) {
                    return cmp;
                }
                return 4.compareEqualItems(stacks[a], stacks[b]);
            });
            return sortIds;
        }
    });

    public static <T extends SortMode> T register(String name, T sortMode) {
        SORT_MODES.put(name, sortMode);
        return sortMode;
    }

    public static void unregister(String name) {
        SORT_MODES.remove(name);
    }

    protected SortMode(String name) {
        this.name = name;
    }

    public int[] sort(int[] sortIds, class_1799[] stacks, SortContext context) {
        int i;
        Integer[] boxedSortIds = new Integer[sortIds.length];
        for (i = 0; i < sortIds.length; ++i) {
            boxedSortIds[i] = sortIds[i];
        }
        boxedSortIds = this.sort(boxedSortIds, stacks);
        for (i = 0; i < sortIds.length; ++i) {
            sortIds[i] = boxedSortIds[i];
        }
        return sortIds;
    }

    @Deprecated
    public Integer[] sort(Integer[] sortIds, class_1799[] stacks) {
        return sortIds;
    }

    public DropdownMaterial<SortMode> valueOf(String s) {
        return SORT_MODES.get(s);
    }

    public Collection<SortMode> values() {
        return SORT_MODES.values();
    }

    public String name() {
        return this.name;
    }

    public String getTranslationKey() {
        return "mousewheelie.sortmode." + this.name.toLowerCase(Locale.ENGLISH);
    }

    protected static int compareEqualItems(class_1799 a, class_1799 b) {
        int cmp = Integer.compare(b.method_7947(), a.method_7947());
        if (cmp != 0) {
            return cmp;
        }
        return SortMode.compareEqualItems2(a, b);
    }

    private static int compareEqualItems2(class_1799 a, class_1799 b) {
        if (a.method_7938()) {
            if (!b.method_7938()) {
                return -1;
            }
            return SortMode.compareEqualItems3(a, b);
        }
        if (b.method_7938()) {
            return 1;
        }
        return SortMode.compareEqualItems3(a, b);
    }

    private static int compareEqualItems3(class_1799 a, class_1799 b) {
        Iterator tooltipsA = a.method_7950(null, (class_1836)class_1836.class_1837.field_8934).iterator();
        Iterator tooltipsB = b.method_7950(null, (class_1836)class_1836.class_1837.field_8934).iterator();
        while (tooltipsA.hasNext()) {
            if (!tooltipsB.hasNext()) {
                return 1;
            }
            int cmp = ((class_2561)tooltipsA.next()).getString().compareToIgnoreCase(((class_2561)tooltipsB.next()).getString());
            if (cmp == 0) continue;
            return cmp;
        }
        if (tooltipsB.hasNext()) {
            return -1;
        }
        return SortMode.compareEqualItems4(a, b);
    }

    private static int compareEqualItems4(class_1799 a, class_1799 b) {
        return Integer.compare(a.method_7919(), b.method_7919());
    }
}

