/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.network;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_2596;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class InteractionManager {
    public static final Queue<InteractionEvent> interactionEventQueue = new ArrayDeque<InteractionEvent>();
    private static final ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(1);
    private static ScheduledFuture<?> tickFuture;
    public static final Waiter DUMMY_WAITER;
    public static final Waiter TICK_WAITER;
    private static Waiter waiter;

    public static void push(InteractionEvent interactionEvent) {
        if (interactionEvent == null) {
            return;
        }
        interactionEventQueue.add(interactionEvent);
        if (waiter == null) {
            InteractionManager.triggerSend(TriggerType.INITIAL);
        }
    }

    public static void pushClickEvent(int containerSyncId, int slotId, int buttonId, class_1713 slotAction) {
        InteractionManager.push(new ClickEvent(containerSyncId, slotId, buttonId, slotAction));
    }

    public static void triggerSend(TriggerType triggerType) {
        if (waiter == null || waiter.trigger(triggerType)) {
            InteractionEvent event;
            do {
                if ((event = interactionEventQueue.poll()) != null) continue;
                waiter = null;
                break;
            } while ((waiter = event.send()).trigger(TriggerType.INITIAL));
        }
    }

    public static void setTickRate(long milliSeconds) {
        if (tickFuture != null) {
            tickFuture.cancel(true);
        }
        tickFuture = scheduledExecutor.scheduleAtFixedRate(InteractionManager::tick, milliSeconds, milliSeconds, TimeUnit.MILLISECONDS);
    }

    public static void tick() {
        InteractionManager.triggerSend(TriggerType.TICK);
    }

    public static void setWaiter(Waiter waiter) {
        InteractionManager.waiter = waiter;
    }

    public static void clear() {
        interactionEventQueue.clear();
        waiter = null;
    }

    public static boolean isReady() {
        return waiter == null && interactionEventQueue.isEmpty();
    }

    static {
        DUMMY_WAITER = triggerType -> true;
        TICK_WAITER = triggerType -> triggerType == TriggerType.TICK;
        waiter = null;
    }

    @FunctionalInterface
    public static interface Waiter {
        public boolean trigger(TriggerType var1);
    }

    public static enum TriggerType {
        INITIAL,
        CONTAINER_SLOT_UPDATE,
        GUI_CONFIRM,
        HELD_ITEM_CHANGE,
        TICK;

    }

    public static class ClickEvent
    implements InteractionEvent {
        private final Waiter waiter;
        private final int containerSyncId;
        private final int slotId;
        private final int buttonId;
        private final class_1713 slotAction;

        public ClickEvent(int containerSyncId, int slotId, int buttonId, class_1713 slotAction) {
            this(containerSyncId, slotId, buttonId, slotAction, TICK_WAITER);
        }

        public ClickEvent(int containerSyncId, int slotId, int buttonId, class_1713 slotAction, Waiter waiter) {
            this.containerSyncId = containerSyncId;
            this.slotId = slotId;
            this.buttonId = buttonId;
            this.slotAction = slotAction;
            this.waiter = waiter;
        }

        @Override
        public Waiter send() {
            class_310.method_1551().field_1761.method_2906(this.containerSyncId, this.slotId, this.buttonId, this.slotAction, (class_1657)class_310.method_1551().field_1724);
            return this.waiter;
        }
    }

    @FunctionalInterface
    public static interface InteractionEvent {
        public Waiter send();
    }

    public static class PacketEvent
    implements InteractionEvent {
        private final class_2596<?> packet;
        private final Waiter waiter;

        public PacketEvent(class_2596<?> packet) {
            this(packet, DUMMY_WAITER);
        }

        public PacketEvent(class_2596<?> packet, int triggers) {
            this(packet, new SlotUpdateWaiter(triggers));
        }

        public PacketEvent(class_2596<?> packet, Waiter waiter) {
            this.packet = packet;
            this.waiter = waiter;
        }

        @Override
        public Waiter send() {
            class_310.method_1551().method_1562().method_2883(this.packet);
            return this.waiter;
        }
    }

    public static class CallbackEvent
    implements InteractionEvent {
        private final Supplier<Waiter> callback;

        public CallbackEvent(Supplier<Waiter> callback) {
            this.callback = callback;
        }

        @Override
        public Waiter send() {
            return this.callback.get();
        }
    }

    public static class SlotUpdateWaiter
    implements Waiter {
        int triggers;

        public SlotUpdateWaiter(int triggers) {
            this.triggers = triggers;
        }

        @Override
        public boolean trigger(TriggerType triggerType) {
            return triggerType == TriggerType.CONTAINER_SLOT_UPDATE && --this.triggers == 0;
        }
    }

    @Deprecated
    public static class GuiConfirmWaiter
    implements Waiter {
        int triggers;

        public GuiConfirmWaiter(int triggers) {
            this.triggers = triggers;
        }

        @Override
        public boolean trigger(TriggerType triggerType) {
            return triggerType == TriggerType.GUI_CONFIRM && --this.triggers == 0;
        }
    }
}

