/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui.widgets;

import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ClientComputer;
import java.util.BitSet;
import javax.annotation.Nonnull;
import net.minecraft.class_155;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_6382;

public class WidgetTerminal
extends class_339 {
    private static final float TERMINATE_TIME = 0.5f;
    private final ClientComputer computer;
    private final int innerX;
    private final int innerY;
    private final int innerWidth;
    private final int innerHeight;
    private float terminateTimer = -1.0f;
    private float rebootTimer = -1.0f;
    private float shutdownTimer = -1.0f;
    private int lastMouseButton = -1;
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    private final BitSet keysDown = new BitSet(256);

    public WidgetTerminal(@Nonnull ClientComputer computer, int x, int y, int termWidth, int termHeight) {
        super(x, y, termWidth * 6 + 4, termHeight * 9 + 4, class_2585.field_24366);
        this.computer = computer;
        this.innerX = x + 2;
        this.innerY = y + 2;
        this.innerWidth = termWidth * 6;
        this.innerHeight = termHeight * 9;
    }

    public boolean method_25400(char ch, int modifiers) {
        if (ch >= ' ' && ch <= '~' || ch >= '\u00a0' && ch <= '\u00ff') {
            this.computer.queueEvent("char", new Object[]{Character.toString(ch)});
        }
        return true;
    }

    public boolean method_25404(int key, int scancode, int modifiers) {
        if (key == 256) {
            return false;
        }
        if ((modifiers & 2) != 0) {
            switch (key) {
                case 84: {
                    if (this.terminateTimer < 0.0f) {
                        this.terminateTimer = 0.0f;
                    }
                    return true;
                }
                case 83: {
                    if (this.shutdownTimer < 0.0f) {
                        this.shutdownTimer = 0.0f;
                    }
                    return true;
                }
                case 82: {
                    if (this.rebootTimer < 0.0f) {
                        this.rebootTimer = 0.0f;
                    }
                    return true;
                }
                case 86: {
                    String clipboard = class_310.method_1551().field_1774.method_1460();
                    if (clipboard == null) break;
                    int newLineIndex1 = clipboard.indexOf("\r");
                    int newLineIndex2 = clipboard.indexOf("\n");
                    if (newLineIndex1 >= 0 && newLineIndex2 >= 0) {
                        clipboard = clipboard.substring(0, Math.min(newLineIndex1, newLineIndex2));
                    } else if (newLineIndex1 >= 0) {
                        clipboard = clipboard.substring(0, newLineIndex1);
                    } else if (newLineIndex2 >= 0) {
                        clipboard = clipboard.substring(0, newLineIndex2);
                    }
                    clipboard = class_155.method_644((String)clipboard);
                    if (!clipboard.isEmpty()) {
                        if (clipboard.length() > 512) {
                            clipboard = clipboard.substring(0, 512);
                        }
                        this.computer.queueEvent("paste", new Object[]{clipboard});
                    }
                    return true;
                }
            }
        }
        if (key >= 0 && this.terminateTimer < 0.0f && this.rebootTimer < 0.0f && this.shutdownTimer < 0.0f) {
            boolean repeat = this.keysDown.get(key);
            this.keysDown.set(key);
            this.computer.keyDown(key, repeat);
        }
        return true;
    }

    public boolean method_16803(int key, int scancode, int modifiers) {
        if (key >= 0 && this.keysDown.get(key)) {
            this.keysDown.set(key, false);
            this.computer.keyUp(key);
        }
        switch (key) {
            case 84: {
                this.terminateTimer = -1.0f;
                break;
            }
            case 82: {
                this.rebootTimer = -1.0f;
                break;
            }
            case 83: {
                this.shutdownTimer = -1.0f;
                break;
            }
            case 341: 
            case 345: {
                this.shutdownTimer = -1.0f;
                this.rebootTimer = -1.0f;
                this.terminateTimer = -1.0f;
            }
        }
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.inTermRegion(mouseX, mouseY)) {
            return false;
        }
        if (!this.computer.isColour() || button < 0 || button > 2) {
            return false;
        }
        Terminal term = this.computer.getTerminal();
        if (term != null) {
            int charX = (int)((mouseX - (double)this.innerX) / 6.0);
            int charY = (int)((mouseY - (double)this.innerY) / 9.0);
            charX = Math.min(Math.max(charX, 0), term.getWidth() - 1);
            charY = Math.min(Math.max(charY, 0), term.getHeight() - 1);
            this.computer.mouseClick(button + 1, charX + 1, charY + 1);
            this.lastMouseButton = button;
            this.lastMouseX = charX;
            this.lastMouseY = charY;
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.inTermRegion(mouseX, mouseY)) {
            return false;
        }
        if (!this.computer.isColour() || button < 0 || button > 2) {
            return false;
        }
        Terminal term = this.computer.getTerminal();
        if (term != null) {
            int charX = (int)((mouseX - (double)this.innerX) / 6.0);
            int charY = (int)((mouseY - (double)this.innerY) / 9.0);
            charX = Math.min(Math.max(charX, 0), term.getWidth() - 1);
            charY = Math.min(Math.max(charY, 0), term.getHeight() - 1);
            if (this.lastMouseButton == button) {
                this.computer.mouseUp(this.lastMouseButton + 1, charX + 1, charY + 1);
                this.lastMouseButton = -1;
            }
            this.lastMouseX = charX;
            this.lastMouseY = charY;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double v2, double v3) {
        if (!this.inTermRegion(mouseX, mouseY)) {
            return false;
        }
        if (!this.computer.isColour() || button < 0 || button > 2) {
            return false;
        }
        Terminal term = this.computer.getTerminal();
        if (term != null) {
            int charX = (int)((mouseX - (double)this.innerX) / 6.0);
            int charY = (int)((mouseY - (double)this.innerY) / 9.0);
            charX = Math.min(Math.max(charX, 0), term.getWidth() - 1);
            charY = Math.min(Math.max(charY, 0), term.getHeight() - 1);
            if (button == this.lastMouseButton && (charX != this.lastMouseX || charY != this.lastMouseY)) {
                this.computer.mouseDrag(button + 1, charX + 1, charY + 1);
                this.lastMouseX = charX;
                this.lastMouseY = charY;
            }
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (!this.inTermRegion(mouseX, mouseY)) {
            return false;
        }
        if (!this.computer.isColour() || delta == 0.0) {
            return false;
        }
        Terminal term = this.computer.getTerminal();
        if (term != null) {
            int charX = (int)((mouseX - (double)this.innerX) / 6.0);
            int charY = (int)((mouseY - (double)this.innerY) / 9.0);
            charX = Math.min(Math.max(charX, 0), term.getWidth() - 1);
            charY = Math.min(Math.max(charY, 0), term.getHeight() - 1);
            this.computer.mouseScroll(delta < 0.0 ? 1 : -1, charX + 1, charY + 1);
            this.lastMouseX = charX;
            this.lastMouseY = charY;
        }
        return true;
    }

    private boolean inTermRegion(double mouseX, double mouseY) {
        return this.field_22763 && this.field_22764 && mouseX >= (double)this.innerX && mouseY >= (double)this.innerY && mouseX < (double)(this.innerX + this.innerWidth) && mouseY < (double)(this.innerY + this.innerHeight);
    }

    public void update() {
        if (this.terminateTimer >= 0.0f && this.terminateTimer < 0.5f) {
            float f;
            this.terminateTimer += 0.05f;
            if (f > 0.5f) {
                this.computer.queueEvent("terminate");
            }
        }
        if (this.shutdownTimer >= 0.0f && this.shutdownTimer < 0.5f) {
            float f;
            this.shutdownTimer += 0.05f;
            if (f > 0.5f) {
                this.computer.shutdown();
            }
        }
        if (this.rebootTimer >= 0.0f && this.rebootTimer < 0.5f) {
            float f;
            this.rebootTimer += 0.05f;
            if (f > 0.5f) {
                this.computer.reboot();
            }
        }
    }

    public void method_25363(boolean focused) {
        if (!focused) {
            for (int key = 0; key < this.keysDown.size(); ++key) {
                if (!this.keysDown.get(key)) continue;
                this.computer.keyUp(key);
            }
            this.keysDown.clear();
            if (this.lastMouseButton > 0) {
                this.computer.mouseUp(this.lastMouseButton + 1, this.lastMouseX + 1, this.lastMouseY + 1);
                this.lastMouseButton = -1;
            }
            this.rebootTimer = -1.0f;
            this.terminateTimer = -1.0f;
            this.shutdownTimer = -1.0f;
        }
    }

    public void method_25394(@Nonnull class_4587 transform, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_22764) {
            return;
        }
        Terminal terminal = this.computer.getTerminal();
        if (terminal != null) {
            FixedWidthFontRenderer.drawTerminalImmediate(transform, this.innerX, this.innerY, terminal, !this.computer.isColour(), 2.0f, 2.0f, 2.0f, 2.0f);
        } else {
            FixedWidthFontRenderer.drawEmptyTerminalImmediate(transform, this.field_22760, this.field_22761, this.field_22758, this.field_22759);
        }
    }

    public void method_37020(@Nonnull class_6382 output) {
    }

    public static int getWidth(int termWidth) {
        return termWidth * 6 + 4;
    }

    public static int getHeight(int termHeight) {
        return termHeight * 9 + 4;
    }
}

