/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.client.render.MonitorTextureBufferShader;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.DirectionUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_291;
import net.minecraft.class_311;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.lwjgl.opengl.GL11;

public class TileEntityMonitorRenderer
implements class_827<TileMonitor> {
    private static final float MARGIN = 0.0328125f;
    private static ByteBuffer tboContents;
    private static final class_4581 IDENTITY;

    public TileEntityMonitorRenderer(class_5614.class_5615 context) {
    }

    public void render(@Nonnull TileMonitor monitor, float partialTicks, @Nonnull class_4587 transform, @Nonnull class_4597 renderer, int lightmapCoord, int overlayLight) {
        ClientMonitor originTerminal = monitor.getClientMonitor();
        if (originTerminal == null) {
            return;
        }
        TileMonitor origin = originTerminal.getOrigin();
        class_2338 monitorPos = monitor.method_11016();
        long renderFrame = FrameInfo.getRenderFrame();
        if (originTerminal.lastRenderFrame == renderFrame && !monitorPos.equals((Object)originTerminal.lastRenderPos)) {
            return;
        }
        originTerminal.lastRenderFrame = renderFrame;
        originTerminal.lastRenderPos = monitorPos;
        class_2338 originPos = origin.method_11016();
        class_2350 dir = origin.getDirection();
        class_2350 front = origin.getFront();
        float yaw = dir.method_10144();
        float pitch = DirectionUtil.toPitchAngle(front);
        transform.method_22903();
        transform.method_22904((double)(originPos.method_10263() - monitorPos.method_10263()) + 0.5, (double)(originPos.method_10264() - monitorPos.method_10264()) + 0.5, (double)(originPos.method_10260() - monitorPos.method_10260()) + 0.5);
        transform.method_22907(class_1160.field_20704.method_23214(yaw));
        transform.method_22907(class_1160.field_20703.method_23214(pitch));
        transform.method_22904(-0.34375, (double)origin.getHeight() - 0.5 - 0.15625 + 0.0, 0.5);
        double xSize = (double)origin.getWidth() - 0.3125;
        double ySize = (double)origin.getHeight() - 0.3125;
        Terminal terminal = originTerminal.getTerminal();
        if (terminal != null) {
            int width = terminal.getWidth();
            int height = terminal.getHeight();
            int pixelWidth = width * 6;
            int pixelHeight = height * 9;
            double xScale = xSize / (double)pixelWidth;
            double yScale = ySize / (double)pixelHeight;
            transform.method_22903();
            transform.method_23760().method_23761().method_22672(class_1159.method_24019((float)((float)xScale), (float)((float)(-yScale)), (float)1.0f));
            TileEntityMonitorRenderer.renderTerminal(renderer, transform, originTerminal, (float)((double)0.0328125f / xScale), (float)((double)0.0328125f / yScale));
            FixedWidthFontRenderer.drawCursor(transform, renderer.getBuffer(RenderTypes.MONITOR), 0.0f, 0.0f, terminal, !originTerminal.isColour());
            transform.method_22909();
        } else {
            FixedWidthFontRenderer.drawEmptyTerminal(transform, renderer.getBuffer(RenderTypes.MONITOR), -0.0328125f, 0.0328125f, (float)(xSize + (double)0.065625f), (float)(-(ySize + (double)0.065625f)), 0xF000F0);
        }
        transform.method_22909();
    }

    private static void renderTerminal(@Nonnull class_4597 renderer, class_4587 transform, ClientMonitor monitor, float xMargin, float yMargin) {
        Terminal terminal = monitor.getTerminal();
        MonitorRenderer renderType = MonitorRenderer.current();
        boolean redraw = monitor.pollTerminalChanged();
        if (monitor.createBuffer(renderType)) {
            redraw = true;
        }
        switch (renderType) {
            case TBO: {
                int width = terminal.getWidth();
                int height = terminal.getHeight();
                int pixelWidth = width * 6;
                int pixelHeight = height * 9;
                if (redraw) {
                    int size = width * height * 3;
                    if (tboContents == null || tboContents.capacity() < size) {
                        tboContents = class_311.method_1596((int)size);
                    }
                    ByteBuffer monitorBuffer = tboContents;
                    monitorBuffer.clear();
                    for (int y = 0; y < height; ++y) {
                        TextBuffer text = terminal.getLine(y);
                        TextBuffer textColour = terminal.getTextColourLine(y);
                        TextBuffer background = terminal.getBackgroundColourLine(y);
                        for (int x = 0; x < width; ++x) {
                            monitorBuffer.put((byte)(text.charAt(x) & 0xFF));
                            monitorBuffer.put((byte)FixedWidthFontRenderer.getColour(textColour.charAt(x), Colour.WHITE));
                            monitorBuffer.put((byte)FixedWidthFontRenderer.getColour(background.charAt(x), Colour.BLACK));
                        }
                    }
                    monitorBuffer.flip();
                    GlStateManager._glBindBuffer((int)35882, (int)monitor.tboBuffer);
                    GlStateManager._glBufferData((int)35882, (ByteBuffer)monitorBuffer, (int)35044);
                    GlStateManager._glBindBuffer((int)35882, (int)0);
                }
                int active = GlStateManager._getActiveTexture();
                RenderSystem.activeTexture((int)33987);
                GL11.glBindTexture((int)35882, (int)monitor.tboTexture);
                RenderSystem.activeTexture((int)active);
                MonitorTextureBufferShader shader = RenderTypes.getMonitorTextureBufferShader();
                shader.setupUniform(width, height, terminal.getPalette(), !monitor.isColour());
                class_1159 matrix = transform.method_23760().method_23761();
                class_4588 buffer = renderer.getBuffer(RenderTypes.MONITOR_TBO);
                TileEntityMonitorRenderer.tboVertex(buffer, matrix, -xMargin, -yMargin);
                TileEntityMonitorRenderer.tboVertex(buffer, matrix, -xMargin, (float)pixelHeight + yMargin);
                TileEntityMonitorRenderer.tboVertex(buffer, matrix, (float)pixelWidth + xMargin, -yMargin);
                TileEntityMonitorRenderer.tboVertex(buffer, matrix, (float)pixelWidth + xMargin, (float)pixelHeight + yMargin);
                break;
            }
            case VBO: {
                class_291 vbo = monitor.buffer;
                if (redraw) {
                    class_289 tessellator = class_289.method_1348();
                    class_287 builder = tessellator.method_1349();
                    builder.method_1328(RenderTypes.MONITOR.method_23033(), RenderTypes.MONITOR.method_23031());
                    FixedWidthFontRenderer.drawTerminalWithoutCursor(new class_4587(), (class_4588)builder, 0.0f, 0.0f, terminal, !monitor.isColour(), yMargin, yMargin, xMargin, xMargin, 0xF000F0);
                    builder.method_1326();
                    vbo.method_1352(builder);
                }
                class_4581 popViewRotation = RenderSystem.getInverseViewRotationMatrix();
                RenderSystem.setInverseViewRotationMatrix((class_4581)IDENTITY);
                RenderTypes.MONITOR.method_23516();
                vbo.method_34427(transform.method_23760().method_23761(), RenderSystem.getProjectionMatrix(), RenderTypes.getMonitorShader());
                RenderTypes.MONITOR.method_23518();
                RenderSystem.setInverseViewRotationMatrix((class_4581)popViewRotation);
                break;
            }
        }
    }

    private static void tboVertex(class_4588 builder, class_1159 matrix, float x, float y) {
        builder.method_22918(matrix, x, y, 0.0f).method_22913(x, y).method_1344();
    }

    public int method_33893() {
        return ComputerCraft.monitorDistance;
    }

    static {
        class_4581 identity = new class_4581();
        identity.method_22856();
        IDENTITY = identity;
    }
}

