/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.IFileSystem;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class FileSystemWrapperMount
implements IFileSystem {
    private final FileSystem filesystem;

    public FileSystemWrapperMount(FileSystem filesystem) {
        this.filesystem = filesystem;
    }

    @Override
    public void makeDirectory(@Nonnull String path) throws IOException {
        try {
            this.filesystem.makeDir(path);
        }
        catch (FileSystemException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void delete(@Nonnull String path) throws IOException {
        try {
            this.filesystem.delete(path);
        }
        catch (FileSystemException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    @Nonnull
    public ReadableByteChannel openForRead(@Nonnull String path) throws IOException {
        try {
            return (ReadableByteChannel)this.filesystem.openForRead(path, Function.identity()).get();
        }
        catch (FileSystemException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    @Nonnull
    public WritableByteChannel openForWrite(@Nonnull String path) throws IOException {
        try {
            return (WritableByteChannel)this.filesystem.openForWrite(path, false, Function.identity()).get();
        }
        catch (FileSystemException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    @Nonnull
    public WritableByteChannel openForAppend(@Nonnull String path) throws IOException {
        try {
            return (WritableByteChannel)this.filesystem.openForWrite(path, true, Function.identity()).get();
        }
        catch (FileSystemException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public long getRemainingSpace() throws IOException {
        try {
            return this.filesystem.getFreeSpace("/");
        }
        catch (FileSystemException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public boolean exists(@Nonnull String path) throws IOException {
        try {
            return this.filesystem.exists(path);
        }
        catch (FileSystemException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public boolean isDirectory(@Nonnull String path) throws IOException {
        try {
            return this.filesystem.isDir(path);
        }
        catch (FileSystemException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void list(@Nonnull String path, @Nonnull List<String> contents) throws IOException {
        try {
            Collections.addAll(contents, this.filesystem.list(path));
        }
        catch (FileSystemException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public long getSize(@Nonnull String path) throws IOException {
        try {
            return this.filesystem.getSize(path);
        }
        catch (FileSystemException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public String combine(String path, String child) {
        return this.filesystem.combine(path, child);
    }

    @Override
    public void copy(String from, String to) throws IOException {
        try {
            this.filesystem.copy(from, to);
        }
        catch (FileSystemException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void move(String from, String to) throws IOException {
        try {
            this.filesystem.move(from, to);
        }
        catch (FileSystemException e) {
            throw new IOException(e.getMessage());
        }
    }
}

