/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.tracking;

import com.google.common.collect.MapMaker;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.tracking.ComputerTracker;
import dan200.computercraft.core.tracking.Tracker;
import dan200.computercraft.core.tracking.Tracking;
import dan200.computercraft.core.tracking.TrackingField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TrackingContext
implements Tracker {
    private boolean tracking = false;
    private final List<ComputerTracker> timings = new ArrayList<ComputerTracker>();
    private final Map<Computer, ComputerTracker> timingLookup = new MapMaker().weakKeys().makeMap();

    public synchronized void start() {
        if (!this.tracking) {
            Tracking.tracking.incrementAndGet();
        }
        this.tracking = true;
        this.timings.clear();
        this.timingLookup.clear();
    }

    public synchronized boolean stop() {
        if (!this.tracking) {
            return false;
        }
        Tracking.tracking.decrementAndGet();
        this.tracking = false;
        this.timingLookup.clear();
        return true;
    }

    public synchronized List<ComputerTracker> getImmutableTimings() {
        ArrayList<ComputerTracker> timings = new ArrayList<ComputerTracker>(this.timings.size());
        for (ComputerTracker timing : this.timings) {
            timings.add(new ComputerTracker(timing));
        }
        return timings;
    }

    public synchronized List<ComputerTracker> getTimings() {
        return new ArrayList<ComputerTracker>(this.timings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaskTiming(Computer computer, long time) {
        if (!this.tracking) {
            return;
        }
        TrackingContext trackingContext = this;
        synchronized (trackingContext) {
            ComputerTracker computerTimings = this.timingLookup.get(computer);
            if (computerTimings == null) {
                computerTimings = new ComputerTracker(computer);
                this.timingLookup.put(computer, computerTimings);
                this.timings.add(computerTimings);
            }
            computerTimings.addTaskTiming(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerTiming(Computer computer, long time) {
        if (!this.tracking) {
            return;
        }
        TrackingContext trackingContext = this;
        synchronized (trackingContext) {
            ComputerTracker computerTimings = this.timingLookup.get(computer);
            if (computerTimings == null) {
                computerTimings = new ComputerTracker(computer);
                this.timingLookup.put(computer, computerTimings);
                this.timings.add(computerTimings);
            }
            computerTimings.addMainTiming(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValue(Computer computer, TrackingField field, long change) {
        if (!this.tracking) {
            return;
        }
        TrackingContext trackingContext = this;
        synchronized (trackingContext) {
            ComputerTracker computerTimings = this.timingLookup.get(computer);
            if (computerTimings == null) {
                computerTimings = new ComputerTracker(computer);
                this.timingLookup.put(computer, computerTimings);
                this.timings.add(computerTimings);
            }
            computerTimings.addValue(field, change);
        }
    }
}

