/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.fabric.mixin;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParseException;
import dan200.computercraft.fabric.util.ServerTranslationEntry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2477;
import net.minecraft.class_2583;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2477.class})
public class MixinLanguage {
    @Shadow
    @Final
    private static Logger field_11490;
    @Shadow
    @Final
    private static String field_33187;

    @Shadow
    private static void method_29425(InputStream inputStream, BiConsumer<String, String> entryConsumer) {
    }

    private static void loadModLangFile(ModContainer modContainer, BiConsumer<String, String> biConsumer) {
        Path path = modContainer.getPath("assets/" + modContainer.getMetadata().getId() + "/lang/" + field_33187 + ".json");
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            MixinLanguage.method_29425(inputStream, biConsumer);
        }
        catch (JsonParseException | IOException e) {
            field_11490.error("Couldn't read strings from " + path, e);
        }
    }

    @Inject(method={"loadDefault"}, cancellable=true, at={@At(value="HEAD")})
    private static void loadDefault(CallbackInfoReturnable<class_2477> cir) {
        HashMap translations = new HashMap();
        for (Object mod : FabricLoader.getInstance().getAllMods()) {
            MixinLanguage.loadModLangFile((ModContainer)mod, (arg_0, arg_1) -> MixinLanguage.lambda$loadDefault$0(translations, (ModContainer)mod, arg_0, arg_1));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry2 : translations.entrySet()) {
            if (((List)entry2.getValue()).size() == 1) {
                builder.put((Object)((String)entry2.getKey()), (Object)((ServerTranslationEntry)((List)entry2.getValue()).get(0)).value());
                continue;
            }
            Set clusterIds = ((List)entry2.getValue()).stream().map(ServerTranslationEntry::getModId).collect(Collectors.toSet());
            ServerTranslationEntry pickedEntry = Collections.max((Collection)entry2.getValue(), Comparator.comparingInt(entry -> entry.getDependencyIntersectionSize(clusterIds)));
            builder.put((Object)((String)entry2.getKey()), (Object)pickedEntry.value());
        }
        ImmutableMap map = builder.build();
        cir.setReturnValue((Object)new class_2477((Map)map){
            final /* synthetic */ Map val$map;
            {
                this.val$map = map;
            }

            public String method_4679(String key) {
                return this.val$map.getOrDefault(key, key);
            }

            public boolean method_4678(String key) {
                return this.val$map.containsKey(key);
            }

            public boolean method_29428() {
                return false;
            }

            public class_5481 method_30934(@NotNull class_5348 text) {
                return visitor -> text.method_27658((style, string) -> class_5223.method_27479((String)string, (class_2583)style, (class_5224)visitor) ? Optional.empty() : class_5348.field_25309, class_2583.field_24360).isPresent();
            }
        });
    }

    private static /* synthetic */ void lambda$loadDefault$0(Map translations, ModContainer mod, String k, String v) {
        if (!translations.containsKey(k)) {
            translations.put(k, new ArrayList());
        }
        ((List)translations.get(k)).add(new ServerTranslationEntry(mod.getMetadata(), k, v));
    }
}

