/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;

public final class TurtleUpgrades {
    private static ITurtleUpgrade[] vanilla;
    private static final Map<String, ITurtleUpgrade> upgrades;
    private static final IdentityHashMap<ITurtleUpgrade, Wrapper> wrappers;
    private static boolean needsRebuild;

    private TurtleUpgrades() {
    }

    public static void register(@Nonnull ITurtleUpgrade upgrade) {
        Objects.requireNonNull(upgrade, "upgrade cannot be null");
        TurtleUpgrades.rebuild();
        Wrapper wrapper = new Wrapper(upgrade);
        String id = wrapper.id;
        ITurtleUpgrade existing = upgrades.get(id);
        if (existing != null) {
            throw new IllegalStateException("Error registering '" + upgrade.getUnlocalisedAdjective() + " Turtle'. Upgrade ID '" + id + "' is already registered by '" + existing.getUnlocalisedAdjective() + " Turtle'");
        }
        upgrades.put(id, upgrade);
        wrappers.put(upgrade, wrapper);
    }

    @Nullable
    public static ITurtleUpgrade get(String id) {
        TurtleUpgrades.rebuild();
        return upgrades.get(id);
    }

    @Nullable
    public static String getOwner(@Nonnull ITurtleUpgrade upgrade) {
        Wrapper wrapper = wrappers.get(upgrade);
        return wrapper != null ? wrapper.modId : null;
    }

    public static ITurtleUpgrade get(@Nonnull class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        for (Wrapper wrapper : wrappers.values()) {
            class_1799 craftingStack;
            if (!wrapper.enabled || (craftingStack = wrapper.upgrade.getCraftingItem()).method_7960() || craftingStack.method_7909() != stack.method_7909() || !wrapper.upgrade.isItemSuitable(stack)) continue;
            return wrapper.upgrade;
        }
        return null;
    }

    public static Stream<ITurtleUpgrade> getVanillaUpgrades() {
        if (vanilla == null) {
            vanilla = new ITurtleUpgrade[]{Registry.TurtleUpgrades.wirelessModemNormal, Registry.TurtleUpgrades.wirelessModemAdvanced, Registry.TurtleUpgrades.speaker, Registry.TurtleUpgrades.diamondPickaxe, Registry.TurtleUpgrades.diamondAxe, Registry.TurtleUpgrades.diamondSword, Registry.TurtleUpgrades.diamondShovel, Registry.TurtleUpgrades.diamondHoe, Registry.TurtleUpgrades.craftingTable};
        }
        return Arrays.stream(vanilla).filter(x -> x != null && TurtleUpgrades.wrappers.get((Object)x).enabled);
    }

    public static Stream<ITurtleUpgrade> getUpgrades() {
        return wrappers.values().stream().filter(x -> x.enabled).map(x -> x.upgrade);
    }

    public static boolean suitableForFamily(ComputerFamily family, ITurtleUpgrade upgrade) {
        return true;
    }

    private static void rebuild() {
        if (!needsRebuild) {
            return;
        }
        upgrades.clear();
        for (Wrapper wrapper : wrappers.values()) {
            if (!wrapper.enabled) continue;
            ITurtleUpgrade existing = upgrades.get(wrapper.id);
            if (existing != null) {
                ComputerCraft.log.error("Error registering '" + wrapper.upgrade.getUnlocalisedAdjective() + " Turtle'. Upgrade ID '" + wrapper.id + "' is already registered by '" + existing.getUnlocalisedAdjective() + " Turtle'");
                continue;
            }
            upgrades.put(wrapper.id, wrapper.upgrade);
        }
        needsRebuild = false;
    }

    public static void enable(ITurtleUpgrade upgrade) {
        Wrapper wrapper = wrappers.get(upgrade);
        if (wrapper.enabled) {
            return;
        }
        wrapper.enabled = true;
        needsRebuild = true;
    }

    public static void disable(ITurtleUpgrade upgrade) {
        Wrapper wrapper = wrappers.get(upgrade);
        if (!wrapper.enabled) {
            return;
        }
        wrapper.enabled = false;
        upgrades.remove(wrapper.id);
    }

    public static void remove(ITurtleUpgrade upgrade) {
        wrappers.remove(upgrade);
        needsRebuild = true;
    }

    static {
        upgrades = new HashMap<String, ITurtleUpgrade>();
        wrappers = new IdentityHashMap();
    }

    private static class Wrapper {
        final ITurtleUpgrade upgrade;
        final String id;
        final String modId;
        boolean enabled;

        Wrapper(ITurtleUpgrade upgrade) {
            this.upgrade = upgrade;
            this.id = upgrade.getUpgradeID().toString();
            this.modId = "computercraft";
            this.enabled = true;
        }
    }
}

