/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.core.filesystem.SubMount;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.util.Colour;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;

public class ItemTreasureDisk
extends class_1792
implements IMedia {
    private static final String NBT_TITLE = "Title";
    private static final String NBT_COLOUR = "Colour";
    private static final String NBT_SUB_PATH = "SubPath";

    public ItemTreasureDisk(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7850(@Nonnull class_1761 group, @Nonnull class_2371<class_1799> stacks) {
    }

    public void method_7851(@Nonnull class_1799 stack, @Nullable class_1937 world, @Nonnull List<class_2561> list, @Nonnull class_1836 tooltipOptions) {
        String label = ItemTreasureDisk.getTitle(stack);
        if (!label.isEmpty()) {
            list.add((class_2561)new class_2585(label));
        }
    }

    @Override
    public String getLabel(@Nonnull class_1799 stack) {
        return ItemTreasureDisk.getTitle(stack);
    }

    @Override
    public IMount createDataMount(@Nonnull class_1799 stack, @Nonnull class_1937 world) {
        IMount rootTreasure = ItemTreasureDisk.getTreasureMount();
        if (rootTreasure == null) {
            return null;
        }
        String subPath = ItemTreasureDisk.getSubPath(stack);
        try {
            if (rootTreasure.exists(subPath)) {
                return new SubMount(rootTreasure, subPath);
            }
            if (rootTreasure.exists("deprecated/" + subPath)) {
                return new SubMount(rootTreasure, "deprecated/" + subPath);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static class_1799 create(String subPath, int colourIndex) {
        class_1799 result = new class_1799((class_1935)Registry.ModItems.TREASURE_DISK);
        class_2487 nbt = result.method_7948();
        nbt.method_10582(NBT_SUB_PATH, subPath);
        int slash = subPath.indexOf(47);
        if (slash >= 0) {
            String author = subPath.substring(0, slash);
            String title = subPath.substring(slash + 1);
            nbt.method_10582(NBT_TITLE, "\"" + title + "\" by " + author);
        } else {
            nbt.method_10582(NBT_TITLE, "untitled");
        }
        nbt.method_10569(NBT_COLOUR, Colour.values()[colourIndex].getHex());
        return result;
    }

    private static IMount getTreasureMount() {
        return ComputerCraftAPI.createResourceMount("computercraft", "lua/treasure");
    }

    @Nonnull
    private static String getTitle(@Nonnull class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_TITLE) ? nbt.method_10558(NBT_TITLE) : "'missingno' by how did you get this anyway?";
    }

    @Nonnull
    private static String getSubPath(@Nonnull class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_SUB_PATH) ? nbt.method_10558(NBT_SUB_PATH) : "dan200/alongtimeago";
    }

    public static int getColour(@Nonnull class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_COLOUR) ? nbt.method_10550(NBT_COLOUR) : Colour.BLUE.getHex();
    }
}

