/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.sound.SpeakerManager;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.PacketContext;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_2540;

public class SpeakerAudioClientMessage
implements NetworkMessage {
    private final UUID source;
    private final class_243 pos;
    private final ByteBuffer content;
    private final float volume;

    public SpeakerAudioClientMessage(UUID source, class_243 pos, float volume, ByteBuffer content) {
        this.source = source;
        this.pos = pos;
        this.content = content;
        this.volume = volume;
    }

    public SpeakerAudioClientMessage(class_2540 buf) {
        this.source = buf.method_10790();
        this.pos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.volume = buf.readFloat();
        SpeakerManager.getSound(this.source).pushAudio((ByteBuf)buf);
        this.content = null;
    }

    @Override
    public void toBytes(@Nonnull class_2540 buf) {
        buf.method_10797(this.source);
        buf.writeDouble(this.pos.method_10216());
        buf.writeDouble(this.pos.method_10214());
        buf.writeDouble(this.pos.method_10215());
        buf.writeFloat(this.volume);
        buf.writeBytes(this.content.duplicate());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void handle(PacketContext context) {
        SpeakerManager.getSound(this.source).playAudio(this.pos, this.volume);
    }
}

