/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.network.client.TerminalState;
import dan200.computercraft.shared.peripheral.monitor.BlockMonitor;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.Expander;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.peripheral.monitor.MonitorPeripheral;
import dan200.computercraft.shared.peripheral.monitor.MonitorState;
import dan200.computercraft.shared.peripheral.monitor.MonitorWatcher;
import dan200.computercraft.shared.peripheral.monitor.ServerMonitor;
import dan200.computercraft.shared.peripheral.monitor.XYPair;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

public class TileMonitor
extends TileGeneric
implements IPeripheralTile {
    public static final double RENDER_BORDER = 0.125;
    public static final double RENDER_MARGIN = 0.03125;
    public static final double RENDER_PIXEL_SCALE = 0.015625;
    private static final String NBT_X = "XIndex";
    private static final String NBT_Y = "YIndex";
    private static final String NBT_WIDTH = "Width";
    private static final String NBT_HEIGHT = "Height";
    private final boolean advanced;
    private ServerMonitor serverMonitor;
    private ClientMonitor clientMonitor;
    private MonitorPeripheral peripheral;
    private final Set<IComputerAccess> computers = new HashSet<IComputerAccess>();
    private boolean needsUpdate = false;
    private boolean needsValidating = false;
    private boolean destroyed = false;
    boolean enqueued;
    TerminalState cached;
    private int width = 1;
    private int height = 1;
    private int xIndex = 0;
    private int yIndex = 0;

    public TileMonitor(class_2591<? extends TileMonitor> type, class_2338 pos, class_2680 state, boolean advanced) {
        super(type, pos, state);
        this.advanced = advanced;
    }

    public void method_10996() {
        super.method_10996();
        this.needsValidating = true;
        TickScheduler.schedule(this);
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (!this.method_10997().field_9236) {
            this.contractNeighbours();
        }
    }

    public void method_11012() {
        super.method_11012();
        if (this.clientMonitor != null && this.xIndex == 0 && this.yIndex == 0) {
            this.clientMonitor.destroy();
        }
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.clientMonitor != null && this.xIndex == 0 && this.yIndex == 0) {
            this.clientMonitor.destroy();
        }
    }

    @Override
    @Nonnull
    public class_1269 onActivate(class_1657 player, class_1268 hand, class_3965 hit) {
        if (!player.method_18276() && this.getFront() == hit.method_17780()) {
            if (!this.method_10997().field_9236) {
                this.monitorTouched((float)(hit.method_17784().field_1352 - (double)hit.method_17777().method_10263()), (float)(hit.method_17784().field_1351 - (double)hit.method_17777().method_10264()), (float)(hit.method_17784().field_1350 - (double)hit.method_17777().method_10260()));
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_11007(class_2487 tag) {
        tag.method_10569(NBT_X, this.xIndex);
        tag.method_10569(NBT_Y, this.yIndex);
        tag.method_10569(NBT_WIDTH, this.width);
        tag.method_10569(NBT_HEIGHT, this.height);
        super.method_11007(tag);
    }

    public void method_11014(@Nonnull class_2487 nbt) {
        super.method_11014(nbt);
        int oldXIndex = this.xIndex;
        int oldYIndex = this.yIndex;
        this.xIndex = nbt.method_10550(NBT_X);
        this.yIndex = nbt.method_10550(NBT_Y);
        this.width = nbt.method_10550(NBT_WIDTH);
        this.height = nbt.method_10550(NBT_HEIGHT);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            if (oldXIndex != this.xIndex || oldYIndex != this.yIndex) {
                if (oldXIndex == 0 && oldYIndex == 0 && this.clientMonitor != null) {
                    this.clientMonitor.destroy();
                }
                this.clientMonitor = null;
            }
            if (this.xIndex == 0 && this.yIndex == 0 && this.clientMonitor == null) {
                this.clientMonitor = new ClientMonitor(this.advanced, this);
            }
        }
    }

    @Override
    public void blockTick() {
        if (this.needsValidating) {
            this.needsValidating = false;
            this.validate();
        }
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.expand();
        }
        if (this.xIndex != 0 || this.yIndex != 0 || this.serverMonitor == null) {
            return;
        }
        this.serverMonitor.clearChanged();
        if (this.serverMonitor.pollResized()) {
            this.eachComputer(c -> c.queueEvent("monitor_resize", c.getAttachmentName()));
        }
        if (this.serverMonitor.pollTerminalChanged()) {
            MonitorWatcher.enqueue(this);
        }
    }

    @Override
    @Nonnull
    public IPeripheral getPeripheral(@NotNull class_2350 side) {
        this.createServerMonitor();
        if (this.peripheral == null) {
            this.peripheral = new MonitorPeripheral(this);
        }
        return this.peripheral;
    }

    @Nullable
    public ServerMonitor getCachedServerMonitor() {
        return this.serverMonitor;
    }

    @Nullable
    private ServerMonitor getServerMonitor() {
        if (this.serverMonitor != null) {
            return this.serverMonitor;
        }
        TileMonitor origin = this.getOrigin().getMonitor();
        if (origin == null) {
            return null;
        }
        this.serverMonitor = origin.serverMonitor;
        return this.serverMonitor;
    }

    @Nullable
    private ServerMonitor createServerMonitor() {
        if (this.serverMonitor != null) {
            return this.serverMonitor;
        }
        if (this.xIndex == 0 && this.yIndex == 0) {
            this.serverMonitor = new ServerMonitor(this.advanced, this);
            this.serverMonitor.rebuild();
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    TileMonitor monitor = this.getLoadedMonitor(x, y).getMonitor();
                    if (monitor == null) continue;
                    monitor.serverMonitor = this.serverMonitor;
                }
            }
            return this.serverMonitor;
        }
        class_2586 te = this.field_11863.method_8321(this.toWorldPos(0, 0));
        if (!(te instanceof TileMonitor)) {
            return null;
        }
        this.serverMonitor = ((TileMonitor)te).createServerMonitor();
        return this.serverMonitor;
    }

    @Nullable
    public ClientMonitor getClientMonitor() {
        if (this.clientMonitor != null) {
            return this.clientMonitor;
        }
        class_2586 te = this.field_11863.method_8321(this.toWorldPos(0, 0));
        if (!(te instanceof TileMonitor)) {
            return null;
        }
        this.clientMonitor = ((TileMonitor)te).clientMonitor;
        return this.clientMonitor;
    }

    @Nonnull
    public final class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    @Nonnull
    public final class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        nbt.method_10569(NBT_X, this.xIndex);
        nbt.method_10569(NBT_Y, this.yIndex);
        nbt.method_10569(NBT_WIDTH, this.width);
        nbt.method_10569(NBT_HEIGHT, this.height);
        return nbt;
    }

    public final void read(TerminalState state) {
        if (this.xIndex != 0 || this.yIndex != 0) {
            ComputerCraft.log.warn("Receiving monitor state for non-origin terminal at {}", (Object)this.method_11016());
            return;
        }
        if (this.clientMonitor == null) {
            this.clientMonitor = new ClientMonitor(this.advanced, this);
        }
        this.clientMonitor.read(state);
    }

    private void updateBlockState() {
        this.method_10997().method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657(BlockMonitor.STATE, (Comparable)((Object)MonitorEdgeState.fromConnections(this.yIndex < this.height - 1, this.yIndex > 0, this.xIndex > 0, this.xIndex < this.width - 1))), 2);
    }

    public class_2350 getDirection() {
        class_2680 state = this.method_11010();
        return state.method_28498((class_2769)BlockMonitor.FACING) ? (class_2350)state.method_11654((class_2769)BlockMonitor.FACING) : class_2350.field_11043;
    }

    public class_2350 getOrientation() {
        class_2680 state = this.method_11010();
        return state.method_28498((class_2769)BlockMonitor.ORIENTATION) ? (class_2350)state.method_11654((class_2769)BlockMonitor.ORIENTATION) : class_2350.field_11043;
    }

    public class_2350 getFront() {
        class_2350 orientation = this.getOrientation();
        return orientation == class_2350.field_11043 ? this.getDirection() : orientation;
    }

    public class_2350 getRight() {
        return this.getDirection().method_10160();
    }

    public class_2350 getDown() {
        class_2350 orientation = this.getOrientation();
        if (orientation == class_2350.field_11043) {
            return class_2350.field_11036;
        }
        return orientation == class_2350.field_11033 ? this.getDirection() : this.getDirection().method_10153();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    boolean isCompatible(TileMonitor other) {
        return !other.destroyed && this.advanced == other.advanced && this.getOrientation() == other.getOrientation() && this.getDirection() == other.getDirection();
    }

    @Nonnull
    private MonitorState getLoadedMonitor(int x, int y) {
        if (x == this.xIndex && y == this.yIndex) {
            return MonitorState.present(this);
        }
        class_2338 pos = this.toWorldPos(x, y);
        class_1937 world = this.method_10997();
        if (world == null || !world.method_8477(pos)) {
            return MonitorState.UNLOADED;
        }
        class_2586 tile = world.method_8321(pos);
        if (!(tile instanceof TileMonitor)) {
            return MonitorState.MISSING;
        }
        TileMonitor monitor = (TileMonitor)tile;
        return this.isCompatible(monitor) ? MonitorState.present(monitor) : MonitorState.MISSING;
    }

    private MonitorState getOrigin() {
        return this.getLoadedMonitor(0, 0);
    }

    class_2338 toWorldPos(int x, int y) {
        if (this.xIndex == x && this.yIndex == y) {
            return this.method_11016();
        }
        return this.method_11016().method_10079(this.getRight(), -this.xIndex + x).method_10079(this.getDown(), -this.yIndex + y);
    }

    void resize(int width, int height) {
        if (this.xIndex != 0 || this.yIndex != 0) {
            this.serverMonitor = null;
        }
        this.xIndex = 0;
        this.yIndex = 0;
        this.width = width;
        this.height = height;
        boolean needsTerminal = false;
        block0: for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                TileMonitor monitor = this.getLoadedMonitor(x, y).getMonitor();
                if (monitor == null || monitor.peripheral == null) continue;
                needsTerminal = true;
                break block0;
            }
        }
        if (needsTerminal) {
            if (this.serverMonitor == null) {
                this.serverMonitor = new ServerMonitor(this.advanced, this);
            }
        } else {
            this.serverMonitor = null;
        }
        if (this.serverMonitor != null) {
            this.serverMonitor.rebuild();
        }
        class_2338 pos = this.method_11016();
        class_2350 down = this.getDown();
        class_2350 right = this.getRight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                TileMonitor monitor;
                class_2586 other = this.method_10997().method_8321(pos.method_10079(right, x).method_10079(down, y));
                if (!(other instanceof TileMonitor) || !this.isCompatible(monitor = (TileMonitor)other)) continue;
                monitor.xIndex = x;
                monitor.yIndex = y;
                monitor.width = width;
                monitor.height = height;
                monitor.serverMonitor = this.serverMonitor;
                monitor.needsValidating = false;
                monitor.needsUpdate = false;
                monitor.updateBlockState();
                monitor.updateBlock();
            }
        }
    }

    void updateNeighborsDeferred() {
        this.needsUpdate = true;
    }

    void expand() {
        TileMonitor monitor = this.getOrigin().getMonitor();
        if (monitor != null && monitor.xIndex == 0 && monitor.yIndex == 0) {
            new Expander(monitor).expand();
        }
    }

    private void contractNeighbours() {
        if (this.width == 1 && this.height == 1) {
            return;
        }
        class_2338 pos = this.method_11016();
        class_2350 down = this.getDown();
        class_2350 right = this.getRight();
        class_2338 origin = this.toWorldPos(0, 0);
        TileMonitor toLeft = null;
        TileMonitor toAbove = null;
        TileMonitor toRight = null;
        TileMonitor toBelow = null;
        if (this.xIndex > 0) {
            toLeft = this.tryResizeAt(pos.method_10079(right, -this.xIndex), this.xIndex, 1);
        }
        if (this.yIndex > 0) {
            toAbove = this.tryResizeAt(origin, this.width, this.yIndex);
        }
        if (this.xIndex < this.width - 1) {
            toRight = this.tryResizeAt(pos.method_10079(right, 1), this.width - this.xIndex - 1, 1);
        }
        if (this.yIndex < this.height - 1) {
            toBelow = this.tryResizeAt(origin.method_10079(down, this.yIndex + 1), this.width, this.height - this.yIndex - 1);
        }
        if (toLeft != null) {
            toLeft.expand();
        }
        if (toAbove != null) {
            toAbove.expand();
        }
        if (toRight != null) {
            toRight.expand();
        }
        if (toBelow != null) {
            toBelow.expand();
        }
    }

    @Nullable
    private TileMonitor tryResizeAt(class_2338 pos, int width, int height) {
        TileMonitor monitor;
        class_2586 tile = this.field_11863.method_8321(pos);
        if (tile instanceof TileMonitor && this.isCompatible(monitor = (TileMonitor)tile)) {
            monitor.resize(width, height);
            return monitor;
        }
        return null;
    }

    private boolean checkMonitorAt(int xIndex, int yIndex) {
        MonitorState state = this.getLoadedMonitor(xIndex, yIndex);
        if (state.isMissing()) {
            return false;
        }
        TileMonitor monitor = state.getMonitor();
        if (monitor == null) {
            return true;
        }
        return monitor.xIndex == xIndex && monitor.yIndex == yIndex && monitor.width == this.width && monitor.height == this.height;
    }

    private void validate() {
        if (this.xIndex == 0 && this.yIndex == 0 && this.width == 1 && this.height == 1) {
            return;
        }
        if (this.xIndex >= 0 && this.xIndex <= this.width && this.width > 0 && this.width <= ComputerCraft.monitorWidth && this.yIndex >= 0 && this.yIndex <= this.height && this.height > 0 && this.height <= ComputerCraft.monitorHeight && this.checkMonitorAt(0, 0) && this.checkMonitorAt(0, this.height - 1) && this.checkMonitorAt(this.width - 1, 0) && this.checkMonitorAt(this.width - 1, this.height - 1)) {
            return;
        }
        ComputerCraft.log.warn("Monitor is malformed, resetting to 1x1.");
        this.resize(1, 1);
        this.needsUpdate = true;
    }

    private void monitorTouched(float xPos, float yPos, float zPos) {
        XYPair pair = XYPair.of(xPos, yPos, zPos, this.getDirection(), this.getOrientation()).add(this.xIndex, this.height - this.yIndex - 1);
        if ((double)pair.x > (double)this.width - 0.125 || (double)pair.y > (double)this.height - 0.125 || (double)pair.x < 0.125 || (double)pair.y < 0.125) {
            return;
        }
        ServerMonitor serverTerminal = this.getServerMonitor();
        if (serverTerminal == null || !serverTerminal.isColour()) {
            return;
        }
        Terminal originTerminal = serverTerminal.getTerminal();
        if (originTerminal == null) {
            return;
        }
        double xCharWidth = ((double)this.width - 0.3125) / (double)originTerminal.getWidth();
        double yCharHeight = ((double)this.height - 0.3125) / (double)originTerminal.getHeight();
        int xCharPos = (int)Math.min((double)originTerminal.getWidth(), Math.max(((double)pair.x - 0.125 - 0.03125) / xCharWidth + 1.0, 1.0));
        int yCharPos = (int)Math.min((double)originTerminal.getHeight(), Math.max(((double)pair.y - 0.125 - 0.03125) / yCharHeight + 1.0, 1.0));
        this.eachComputer(c -> c.queueEvent("monitor_touch", c.getAttachmentName(), xCharPos, yCharPos));
    }

    private void eachComputer(Consumer<IComputerAccess> fun) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                TileMonitor monitor = this.getLoadedMonitor(x, y).getMonitor();
                if (monitor == null) continue;
                for (IComputerAccess computer : monitor.computers) {
                    fun.accept(computer);
                }
            }
        }
    }

    void addComputer(IComputerAccess computer) {
        this.computers.add(computer);
    }

    void removeComputer(IComputerAccess computer) {
        this.computers.remove(computer);
    }
}

