/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import com.google.common.base.Objects;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.pocket.apis.PocketAPI;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.inventory.PocketComputerMenuProvider;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public class ItemPocketComputer
extends class_1792
implements IComputerItem,
IMedia,
IColouredItem {
    private static final String NBT_UPGRADE = "Upgrade";
    private static final String NBT_UPGRADE_INFO = "UpgradeInfo";
    public static final String NBT_LIGHT = "Light";
    private static final String NBT_INSTANCE = "Instanceid";
    private static final String NBT_SESSION = "SessionId";
    private final ComputerFamily family;

    public ItemPocketComputer(class_1792.class_1793 settings, ComputerFamily family) {
        super(settings);
        this.family = family;
    }

    public class_1799 create(int id, String label, int colour, IPocketUpgrade upgrade) {
        class_1799 result = new class_1799((class_1935)this);
        if (id >= 0) {
            result.method_7948().method_10569("ComputerId", id);
        }
        if (label != null) {
            result.method_7977((class_2561)new class_2585(label));
        }
        if (upgrade != null) {
            result.method_7948().method_10582(NBT_UPGRADE, upgrade.getUpgradeID().toString());
        }
        if (colour != -1) {
            result.method_7948().method_10569("Color", colour);
        }
        return result;
    }

    public void method_7850(@Nonnull class_1761 group, @Nonnull class_2371<class_1799> stacks) {
        if (!this.method_7877(group)) {
            return;
        }
        stacks.add((Object)this.create(-1, null, -1, null));
        PocketUpgrades.getVanillaUpgrades().map(x -> this.create(-1, null, -1, (IPocketUpgrade)x)).forEach(arg_0 -> stacks.add(arg_0));
    }

    private boolean tick(@Nonnull class_1799 stack, @Nonnull class_1937 world, @Nonnull class_1297 entity, @Nonnull PocketServerComputer computer) {
        String label;
        IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
        computer.setLevel(world);
        computer.updateValues(entity, stack, upgrade);
        boolean changed = false;
        int id = computer.getID();
        if (id != this.getComputerID(stack)) {
            changed = true;
            ItemPocketComputer.setComputerID(stack, id);
        }
        if (!Objects.equal((Object)(label = computer.getLabel()), (Object)this.getLabel(stack))) {
            changed = true;
            this.setLabel(stack, label);
        }
        if (upgrade != null) {
            upgrade.update(computer, computer.getPeripheral(ComputerSide.BACK));
        }
        return changed;
    }

    public void method_7888(@Nonnull class_1799 stack, class_1937 world, @Nonnull class_1297 entity, int slotNum, boolean selected) {
        if (!world.field_9236) {
            class_1661 class_16612;
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                class_16612 = player.method_31548();
            } else {
                class_16612 = null;
            }
            class_1661 inventory = class_16612;
            PocketServerComputer computer = this.createServerComputer(world, (class_1263)inventory, entity, stack);
            computer.keepAlive();
            boolean changed = this.tick(stack, world, entity, computer);
            if (changed && inventory != null) {
                inventory.method_5431();
            }
        } else {
            ItemPocketComputer.createClientComputer(stack);
        }
    }

    @Override
    public boolean onEntityItemUpdate(class_1799 stack, class_1542 entity) {
        if (entity.field_6002.field_9236) {
            return false;
        }
        PocketServerComputer computer = ItemPocketComputer.getServerComputer(stack);
        if (computer != null && this.tick(stack, entity.field_6002, (class_1297)entity, computer)) {
            entity.method_6979(stack.method_7972());
        }
        return false;
    }

    @Nonnull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236) {
            PocketServerComputer computer = this.createServerComputer(world, (class_1263)player.method_31548(), (class_1297)player, stack);
            computer.turnOn();
            boolean stop = false;
            IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
            if (upgrade != null) {
                computer.updateValues((class_1297)player, stack, upgrade);
                stop = upgrade.onRightClick(world, computer, computer.getPeripheral(ComputerSide.BACK));
            }
            if (!stop) {
                boolean isTypingOnly = hand == class_1268.field_5810;
                new ComputerContainerData(computer).open(player, new PocketComputerMenuProvider(computer, stack, this, hand, isTypingOnly));
            }
        }
        return new class_1271(class_1269.field_5812, (Object)stack);
    }

    @Nonnull
    public class_2561 method_7864(@Nonnull class_1799 stack) {
        String baseString = this.method_7866(stack);
        IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
        if (upgrade != null) {
            return new class_2588(baseString + ".upgraded", new Object[]{new class_2588(upgrade.getUnlocalisedAdjective())});
        }
        return super.method_7864(stack);
    }

    public void method_7851(@Nonnull class_1799 stack, @Nullable class_1937 world, @Nonnull List<class_2561> list, class_1836 flag) {
        int id;
        if ((flag.method_8035() || this.getLabel(stack) == null) && (id = this.getComputerID(stack)) >= 0) {
            list.add((class_2561)new class_2588("gui.computercraft.tooltip.computer_id", new Object[]{id}).method_27692(class_124.field_1080));
        }
    }

    public PocketServerComputer createServerComputer(class_1937 world, class_1263 inventory, class_1297 entity, @Nonnull class_1799 stack) {
        PocketServerComputer computer;
        if (world.field_9236) {
            throw new IllegalStateException("Cannot call createServerComputer on the client");
        }
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        int sessionID = ItemPocketComputer.getSessionID(stack);
        int correctSessionID = ComputerCraft.serverComputerRegistry.getSessionID();
        if (instanceID >= 0 && sessionID == correctSessionID && ComputerCraft.serverComputerRegistry.contains(instanceID)) {
            computer = (PocketServerComputer)ComputerCraft.serverComputerRegistry.get(instanceID);
        } else {
            int computerID;
            if (instanceID < 0 || sessionID != correctSessionID) {
                instanceID = ComputerCraft.serverComputerRegistry.getUnusedInstanceID();
                ItemPocketComputer.setInstanceID(stack, instanceID);
                ItemPocketComputer.setSessionID(stack, correctSessionID);
            }
            if ((computerID = this.getComputerID(stack)) < 0) {
                computerID = ComputerCraftAPI.createUniqueNumberedSaveDir(world, "computer");
                ItemPocketComputer.setComputerID(stack, computerID);
            }
            computer = new PocketServerComputer(world, computerID, this.getLabel(stack), instanceID, this.getFamily());
            computer.updateValues(entity, stack, ItemPocketComputer.getUpgrade(stack));
            computer.addAPI(new PocketAPI(computer));
            ComputerCraft.serverComputerRegistry.add(instanceID, computer);
            if (inventory != null) {
                inventory.method_5431();
            }
        }
        computer.setLevel(world);
        return computer;
    }

    @Nullable
    public static PocketServerComputer getServerComputer(@Nonnull class_1799 stack) {
        int session = ItemPocketComputer.getSessionID(stack);
        if (session != ComputerCraft.serverComputerRegistry.getSessionID()) {
            return null;
        }
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        return instanceID >= 0 ? (PocketServerComputer)ComputerCraft.serverComputerRegistry.get(instanceID) : null;
    }

    @Nullable
    public static ClientComputer createClientComputer(@Nonnull class_1799 stack) {
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        if (instanceID >= 0) {
            if (!ComputerCraft.clientComputerRegistry.contains(instanceID)) {
                ComputerCraft.clientComputerRegistry.add(instanceID, new ClientComputer(instanceID));
            }
            return (ClientComputer)ComputerCraft.clientComputerRegistry.get(instanceID);
        }
        return null;
    }

    @Nullable
    private static ClientComputer getClientComputer(@Nonnull class_1799 stack) {
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        return instanceID >= 0 ? (ClientComputer)ComputerCraft.clientComputerRegistry.get(instanceID) : null;
    }

    private static void setComputerID(@Nonnull class_1799 stack, int computerID) {
        stack.method_7948().method_10569("ComputerId", computerID);
    }

    @Override
    public String getLabel(@Nonnull class_1799 stack) {
        return IComputerItem.super.getLabel(stack);
    }

    @Override
    public ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    public class_1799 withFamily(@Nonnull class_1799 stack, @Nonnull ComputerFamily family) {
        return PocketComputerItemFactory.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), family, ItemPocketComputer.getUpgrade(stack));
    }

    @Override
    public boolean setLabel(@Nonnull class_1799 stack, String label) {
        if (label != null) {
            stack.method_7977((class_2561)new class_2585(label));
        } else {
            stack.method_7925();
        }
        return true;
    }

    @Override
    public IMount createDataMount(@Nonnull class_1799 stack, @Nonnull class_1937 world) {
        int id = this.getComputerID(stack);
        if (id >= 0) {
            return ComputerCraftAPI.createSaveDirMount(world, "computer/" + id, ComputerCraft.computerSpaceLimit);
        }
        return null;
    }

    private static int getInstanceID(@Nonnull class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_INSTANCE) ? nbt.method_10550(NBT_INSTANCE) : -1;
    }

    private static void setInstanceID(@Nonnull class_1799 stack, int instanceID) {
        stack.method_7948().method_10569(NBT_INSTANCE, instanceID);
    }

    private static int getSessionID(@Nonnull class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_SESSION) ? nbt.method_10550(NBT_SESSION) : -1;
    }

    private static void setSessionID(@Nonnull class_1799 stack, int sessionID) {
        stack.method_7948().method_10569(NBT_SESSION, sessionID);
    }

    public static ComputerState getState(@Nonnull class_1799 stack) {
        ClientComputer computer = ItemPocketComputer.getClientComputer(stack);
        return computer == null ? ComputerState.OFF : computer.getState();
    }

    public static int getLightState(@Nonnull class_1799 stack) {
        class_2487 computerNBT;
        ClientComputer computer = ItemPocketComputer.getClientComputer(stack);
        if (computer != null && computer.isOn() && (computerNBT = computer.getUserData()) != null && computerNBT.method_10545(NBT_LIGHT)) {
            return computerNBT.method_10550(NBT_LIGHT);
        }
        return -1;
    }

    public static IPocketUpgrade getUpgrade(@Nonnull class_1799 stack) {
        class_2487 compound = stack.method_7969();
        return compound != null && compound.method_10545(NBT_UPGRADE) ? PocketUpgrades.get(compound.method_10558(NBT_UPGRADE)) : null;
    }

    public static void setUpgrade(@Nonnull class_1799 stack, IPocketUpgrade upgrade) {
        class_2487 compound = stack.method_7948();
        if (upgrade == null) {
            compound.method_10551(NBT_UPGRADE);
        } else {
            compound.method_10582(NBT_UPGRADE, upgrade.getUpgradeID().toString());
        }
        compound.method_10551(NBT_UPGRADE_INFO);
    }

    public static class_2487 getUpgradeInfo(@Nonnull class_1799 stack) {
        return stack.method_7911(NBT_UPGRADE_INFO);
    }
}

