/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.blocks.ComputerProxy;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.apis.TurtleAPI;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.turtle.blocks.ITurtleTile;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.inventory.ContainerTurtle;
import dan200.computercraft.shared.util.DefaultInventory;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3965;

public class TileTurtle
extends TileComputerBase
implements ITurtleTile,
DefaultInventory {
    public static final int INVENTORY_SIZE = 16;
    public static final int INVENTORY_WIDTH = 4;
    public static final int INVENTORY_HEIGHT = 4;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
    private final class_2371<class_1799> previousInventory = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
    private boolean inventoryChanged = false;
    private TurtleBrain brain = new TurtleBrain(this);
    private MoveState moveState = MoveState.NOT_MOVED;

    public TileTurtle(class_2591<? extends TileGeneric> type, class_2338 pos, class_2680 state, ComputerFamily family) {
        super(type, pos, state, family);
    }

    private boolean hasMoved() {
        return this.moveState == MoveState.MOVED;
    }

    @Override
    protected ServerComputer createComputer(int instanceID, int id) {
        ServerComputer computer = new ServerComputer(this.method_10997(), id, this.label, instanceID, this.getFamily(), 39, 13);
        computer.setPosition(this.method_11016());
        computer.addAPI(new TurtleAPI(computer.getAPIEnvironment(), this.getAccess()));
        this.brain.setupComputer(computer);
        return computer;
    }

    public ComputerProxy createProxy() {
        return this.brain.getProxy();
    }

    @Override
    public void destroy() {
        block3: {
            block2: {
                if (this.hasMoved()) break block2;
                super.destroy();
                if (this.method_10997().field_9236) break block3;
                int size = this.method_5439();
                for (int i = 0; i < size; ++i) {
                    class_1799 stack = this.method_5438(i);
                    if (stack.method_7960()) continue;
                    WorldUtil.dropItemStack(stack, this.method_10997(), this.method_11016());
                }
                break block3;
            }
            for (class_2350 dir : DirectionUtil.FACINGS) {
                RedstoneUtil.propagateRedstoneOutput(this.method_10997(), this.method_11016(), dir);
            }
        }
    }

    @Override
    protected void unload() {
        if (!this.hasMoved()) {
            super.unload();
        }
    }

    @Override
    @Nonnull
    public class_1269 onActivate(class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 currentItem = player.method_5998(hand);
        if (!currentItem.method_7960()) {
            class_1792 class_17922 = currentItem.method_7909();
            if (class_17922 instanceof class_1769) {
                class_1769 dyeItem = (class_1769)class_17922;
                if (!this.method_10997().field_9236) {
                    class_1767 dye = dyeItem.method_7802();
                    if (this.brain.getDyeColour() != dye) {
                        this.brain.setDyeColour(dye);
                        if (!player.method_7337()) {
                            currentItem.method_7934(1);
                        }
                    }
                }
                return class_1269.field_5812;
            }
            if (currentItem.method_7909() == class_1802.field_8705 && this.brain.getColour() != -1) {
                if (!this.method_10997().field_9236 && this.brain.getColour() != -1) {
                    this.brain.setColour(-1);
                    if (!player.method_7337()) {
                        player.method_6122(hand, new class_1799((class_1935)class_1802.field_8550));
                        player.method_31548().method_5431();
                    }
                }
                return class_1269.field_5812;
            }
        }
        return super.onActivate(player, hand, hit);
    }

    @Override
    protected boolean canNameWithTag(class_1657 player) {
        return true;
    }

    @Override
    protected double getInteractRange(class_1657 player) {
        return 12.0;
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        this.brain.update();
        if (this.inventoryChanged) {
            ServerComputer computer = this.getServerComputer();
            if (computer != null) {
                computer.queueEvent("turtle_inventory");
            }
            this.inventoryChanged = false;
            for (int n = 0; n < this.method_5439(); ++n) {
                this.previousInventory.set(n, (Object)this.method_5438(n).method_7972());
            }
        }
    }

    protected void clientTick() {
        this.brain.update();
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
    }

    @Override
    public void onNeighbourChange(@Nonnull class_2338 neighbour) {
        if (this.moveState == MoveState.NOT_MOVED) {
            super.onNeighbourChange(neighbour);
        }
    }

    @Override
    public void onNeighbourTileEntityChange(@Nonnull class_2338 neighbour) {
        if (this.moveState == MoveState.NOT_MOVED) {
            super.onNeighbourTileEntityChange(neighbour);
        }
    }

    public void notifyMoveStart() {
        if (this.moveState == MoveState.NOT_MOVED) {
            this.moveState = MoveState.IN_PROGRESS;
        }
    }

    public void notifyMoveEnd() {
        if (this.moveState == MoveState.IN_PROGRESS) {
            this.moveState = MoveState.NOT_MOVED;
        }
    }

    @Override
    public void method_11014(@Nonnull class_2487 nbt) {
        super.method_11014(nbt);
        class_2499 nbttaglist = nbt.method_10554("Items", 10);
        this.inventory.clear();
        this.previousInventory.clear();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            class_2487 tag = nbttaglist.method_10602(i);
            int slot = tag.method_10571("Slot") & 0xFF;
            if (slot >= this.method_5439()) continue;
            this.inventory.set(slot, (Object)class_1799.method_7915((class_2487)tag));
            this.previousInventory.set(slot, (Object)((class_1799)this.inventory.get(slot)).method_7972());
        }
        this.brain.readFromNBT(nbt);
        this.brain.readDescription(nbt);
    }

    @Override
    public void method_11007(@Nonnull class_2487 nbt) {
        class_2499 nbttaglist = new class_2499();
        for (int i = 0; i < 16; ++i) {
            if (((class_1799)this.inventory.get(i)).method_7960()) continue;
            class_2487 tag = new class_2487();
            tag.method_10567("Slot", (byte)i);
            ((class_1799)this.inventory.get(i)).method_7953(tag);
            nbttaglist.add((Object)tag);
        }
        nbt.method_10566("Items", (class_2520)nbttaglist);
        nbt = this.brain.writeToNBT(nbt);
        super.method_11007(nbt);
    }

    @Override
    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return this.hasPeripheralUpgradeOnSide(localSide);
    }

    @Override
    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)BlockTurtle.FACING);
    }

    public void setDirection(class_2350 dir) {
        if (dir.method_10166() == class_2350.class_2351.field_11052) {
            dir = class_2350.field_11043;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)BlockTurtle.FACING, (Comparable)dir));
        this.updateOutput();
        this.updateInputsImmediately();
        this.onTileEntityChange();
    }

    @Override
    public ITurtleUpgrade getUpgrade(TurtleSide side) {
        return this.brain.getUpgrade(side);
    }

    @Override
    public int getColour() {
        return this.brain.getColour();
    }

    @Override
    public class_2960 getOverlay() {
        return this.brain.getOverlay();
    }

    @Override
    public ITurtleAccess getAccess() {
        return this.brain;
    }

    @Override
    public class_243 getRenderOffset(float f) {
        return this.brain.getRenderOffset(f);
    }

    @Override
    public float getRenderYaw(float f) {
        return this.brain.getVisualYaw(f);
    }

    @Override
    public float getToolRenderAngle(TurtleSide side, float f) {
        return this.brain.getToolRenderAngle(side, f);
    }

    void setOwningPlayer(GameProfile player) {
        this.brain.setOwningPlayer(player);
        this.method_5431();
    }

    public int method_5439() {
        return 16;
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public class_1799 method_5438(int slot) {
        return slot >= 0 && slot < 16 ? (class_1799)this.inventory.get(slot) : class_1799.field_8037;
    }

    @Nonnull
    public class_1799 method_5441(int slot) {
        class_1799 result = this.method_5438(slot);
        this.method_5447(slot, class_1799.field_8037);
        return result;
    }

    @Nonnull
    public class_1799 method_5434(int slot, int count) {
        if (count == 0) {
            return class_1799.field_8037;
        }
        class_1799 stack = this.method_5438(slot);
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (stack.method_7947() <= count) {
            this.method_5447(slot, class_1799.field_8037);
            return stack;
        }
        class_1799 part = stack.method_7971(count);
        this.onInventoryDefinitelyChanged();
        return part;
    }

    public void method_5447(int i, @Nonnull class_1799 stack) {
        if (i >= 0 && i < 16 && !InventoryUtil.areItemsEqual(stack, (class_1799)this.inventory.get(i))) {
            this.inventory.set(i, (Object)stack);
            this.onInventoryDefinitelyChanged();
        }
    }

    public void method_5448() {
        boolean changed = false;
        for (int i = 0; i < 16; ++i) {
            if (((class_1799)this.inventory.get(i)).method_7960()) continue;
            this.inventory.set(i, (Object)class_1799.field_8037);
            changed = true;
        }
        if (changed) {
            this.onInventoryDefinitelyChanged();
        }
    }

    public void method_5431() {
        super.method_5431();
        if (!this.inventoryChanged) {
            for (int n = 0; n < this.method_5439(); ++n) {
                if (class_1799.method_7973((class_1799)this.method_5438(n), (class_1799)((class_1799)this.previousInventory.get(n)))) continue;
                this.inventoryChanged = true;
                break;
            }
        }
    }

    public boolean method_5443(@Nonnull class_1657 player) {
        return this.isUsable(player, false);
    }

    private void onInventoryDefinitelyChanged() {
        super.method_5431();
        this.inventoryChanged = true;
    }

    public void onTileEntityChange() {
        super.method_5431();
    }

    @Override
    @Nonnull
    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        this.brain.writeDescription(nbt);
        return nbt;
    }

    @Override
    @Nonnull
    protected String getPeripheralName() {
        return "turtle";
    }

    private boolean hasPeripheralUpgradeOnSide(ComputerSide side) {
        ITurtleUpgrade upgrade;
        switch (side) {
            case RIGHT: {
                upgrade = this.getUpgrade(TurtleSide.RIGHT);
                break;
            }
            case LEFT: {
                upgrade = this.getUpgrade(TurtleSide.LEFT);
                break;
            }
            default: {
                return false;
            }
        }
        return upgrade != null && upgrade.getType().isPeripheral();
    }

    public void transferStateFrom(TileTurtle copy) {
        super.transferStateFrom(copy);
        Collections.copy(this.inventory, copy.inventory);
        Collections.copy(this.previousInventory, copy.previousInventory);
        this.inventoryChanged = copy.inventoryChanged;
        this.brain = copy.brain;
        this.brain.setOwner(this);
        copy.moveState = MoveState.MOVED;
    }

    @Nullable
    public class_1703 createMenu(int id, @Nonnull class_1661 inventory, @Nonnull class_1657 player) {
        return new ContainerTurtle(id, inventory, this.brain);
    }

    static enum MoveState {
        NOT_MOVED,
        IN_PROGRESS,
        MOVED;

    }
}

