/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.ItemComputerBase;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import javax.annotation.Nonnull;
import net.minecraft.class_1269;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5556;
import net.minecraft.class_5620;

public class ItemTurtle
extends ItemComputerBase
implements ITurtleItem {
    public static final class_5620 CAULDRON_INTERACTION = (blockState, level, pos, player, hand, stack) -> {
        if (IColouredItem.getColourBasic(stack) == -1) {
            return class_1269.field_5811;
        }
        if (!level.field_9236) {
            IColouredItem.setColourBasic(stack, -1);
            class_5556.method_31650((class_2680)blockState, (class_1937)level, (class_2338)pos);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    };

    public ItemTurtle(BlockTurtle block, class_1792.class_1793 settings) {
        super(block, settings);
    }

    public class_1799 create(int id, String label, int colour, ITurtleUpgrade leftUpgrade, ITurtleUpgrade rightUpgrade, int fuelLevel, class_2960 overlay) {
        class_1799 stack = new class_1799((class_1935)this);
        if (label != null) {
            stack.method_7977((class_2561)new class_2585(label));
        }
        if (id >= 0) {
            stack.method_7948().method_10569("ComputerId", id);
        }
        IColouredItem.setColourBasic(stack, colour);
        if (fuelLevel > 0) {
            stack.method_7948().method_10569("Fuel", fuelLevel);
        }
        if (overlay != null) {
            stack.method_7948().method_10582("Overlay", overlay.toString());
        }
        if (leftUpgrade != null) {
            stack.method_7948().method_10582("LeftUpgrade", leftUpgrade.getUpgradeID().toString());
        }
        if (rightUpgrade != null) {
            stack.method_7948().method_10582("RightUpgrade", rightUpgrade.getUpgradeID().toString());
        }
        return stack;
    }

    public void method_7850(@Nonnull class_1761 group, @Nonnull class_2371<class_1799> list) {
        if (!this.method_7877(group)) {
            return;
        }
        ComputerFamily family = this.getFamily();
        list.add((Object)this.create(-1, null, -1, null, null, 0, null));
        TurtleUpgrades.getVanillaUpgrades().map(x -> this.create(-1, null, -1, null, (ITurtleUpgrade)x, 0, null)).forEach(arg_0 -> list.add(arg_0));
    }

    @Nonnull
    public class_2561 method_7864(@Nonnull class_1799 stack) {
        String baseString = this.method_7866(stack);
        ITurtleUpgrade left = this.getUpgrade(stack, TurtleSide.LEFT);
        ITurtleUpgrade right = this.getUpgrade(stack, TurtleSide.RIGHT);
        if (left != null && right != null) {
            return new class_2588(baseString + ".upgraded_twice", new Object[]{new class_2588(right.getUnlocalisedAdjective()), new class_2588(left.getUnlocalisedAdjective())});
        }
        if (left != null) {
            return new class_2588(baseString + ".upgraded", new Object[]{new class_2588(left.getUnlocalisedAdjective())});
        }
        if (right != null) {
            return new class_2588(baseString + ".upgraded", new Object[]{new class_2588(right.getUnlocalisedAdjective())});
        }
        return new class_2588(baseString);
    }

    @Override
    public class_1799 withFamily(@Nonnull class_1799 stack, @Nonnull ComputerFamily family) {
        return TurtleItemFactory.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), family, this.getUpgrade(stack, TurtleSide.LEFT), this.getUpgrade(stack, TurtleSide.RIGHT), this.getFuelLevel(stack), this.getOverlay(stack));
    }

    @Override
    public ITurtleUpgrade getUpgrade(@Nonnull class_1799 stack, @Nonnull TurtleSide side) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return null;
        }
        String key = side == TurtleSide.LEFT ? "LeftUpgrade" : "RightUpgrade";
        return tag.method_10545(key) ? TurtleUpgrades.get(tag.method_10558(key)) : null;
    }

    @Override
    public class_2960 getOverlay(@Nonnull class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10545("Overlay") ? new class_2960(tag.method_10558("Overlay")) : null;
    }

    @Override
    public int getFuelLevel(@Nonnull class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10545("Fuel") ? tag.method_10550("Fuel") : 0;
    }
}

