/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommentedConfigSpec
extends ConfigSpec {
    private final Map<List<String>, String> comments = new HashMap<List<String>, String>();

    public void comment(List<String> path, String comment) {
        this.comments.put(path, comment);
    }

    public void comment(String path, String comment) {
        this.comment(StringUtils.split((String)path, (char)'.'), comment);
    }

    public int correct(Config config) {
        return this.correct(config, (action, path, incorrectValue, correctedValue) -> {});
    }

    public int correct(Config config, ConfigSpec.CorrectionListener listener) {
        int corrections = super.correct(config, listener);
        if (config instanceof CommentedConfig) {
            this.insertComments((CommentedConfig)config);
        }
        return corrections;
    }

    private void insertComments(CommentedConfig config) {
        for (Map.Entry<List<String>, String> entry : this.comments.entrySet()) {
            config.setComment(entry.getKey(), entry.getValue());
        }
    }
}

