/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.ItemStorage;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3954;
import org.apache.commons.lang3.tuple.Pair;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static boolean areItemsEqual(@Nonnull class_1799 a, @Nonnull class_1799 b) {
        return a == b || class_1799.method_7973((class_1799)a, (class_1799)b);
    }

    public static boolean areItemsStackable(@Nonnull class_1799 a, @Nonnull class_1799 b) {
        return a == b || a.method_7909() == b.method_7909() && class_1799.method_7975((class_1799)a, (class_1799)b);
    }

    public static class_1263 getInventory(class_1937 world, class_2338 pos, class_2350 side) {
        class_1297 entity;
        class_2350 dir;
        class_243 vecDir;
        class_1263 inventory;
        class_2586 tileEntity = world.method_8321(pos);
        if (tileEntity != null && (inventory = InventoryUtil.getInventory(tileEntity)) != null) {
            return inventory;
        }
        class_2680 block = world.method_8320(pos);
        class_2248 class_22482 = block.method_26204();
        if (class_22482 instanceof class_3954) {
            class_3954 containerHolder = (class_3954)class_22482;
            return containerHolder.method_17680(block, (class_1936)world, pos);
        }
        class_243 vecStart = new class_243((double)pos.method_10263() + 0.5 + 0.6 * (double)side.method_10148(), (double)pos.method_10264() + 0.5 + 0.6 * (double)side.method_10164(), (double)pos.method_10260() + 0.5 + 0.6 * (double)side.method_10165());
        Pair<class_1297, class_243> hit = WorldUtil.rayTraceEntities(world, vecStart, vecDir = new class_243((double)(dir = side.method_10153()).method_10148(), (double)dir.method_10164(), (double)dir.method_10165()), 1.1);
        if (hit != null && (entity = (class_1297)hit.getKey()) instanceof class_1263) {
            return (class_1263)entity;
        }
        return null;
    }

    public static class_1263 getInventory(class_2586 tileEntity) {
        class_1937 world = tileEntity.method_10997();
        class_2338 pos = tileEntity.method_11016();
        class_2680 blockState = world.method_8320(pos);
        class_2248 block = blockState.method_26204();
        if (tileEntity instanceof class_1263) {
            class_1263 inventory = (class_1263)tileEntity;
            if (inventory instanceof class_2595 && block instanceof class_2281) {
                class_2281 chestBlock = (class_2281)block;
                return class_2281.method_17458((class_2281)chestBlock, (class_2680)blockState, (class_1937)world, (class_2338)pos, (boolean)true);
            }
            return inventory;
        }
        return null;
    }

    @Nonnull
    public static class_1799 storeItems(@Nonnull class_1799 itemstack, ItemStorage inventory, int begin) {
        return InventoryUtil.storeItems(itemstack, inventory, 0, inventory.size(), begin);
    }

    @Nonnull
    public static class_1799 storeItems(@Nonnull class_1799 itemstack, ItemStorage inventory) {
        return InventoryUtil.storeItems(itemstack, inventory, 0, inventory.size(), 0);
    }

    @Nonnull
    public static class_1799 storeItems(@Nonnull class_1799 stack, ItemStorage inventory, int start, int range, int begin) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 remainder = stack.method_7972();
        for (int i = 0; i < range; ++i) {
            int slot = start + (i + begin - start) % range;
            if (remainder.method_7960()) break;
            remainder = inventory.store(slot, remainder, false);
        }
        return InventoryUtil.areItemsEqual(stack, remainder) ? stack : remainder;
    }

    @Nonnull
    public static class_1799 takeItems(int count, ItemStorage inventory, int begin) {
        return InventoryUtil.takeItems(count, inventory, 0, inventory.size(), begin);
    }

    @Nonnull
    public static class_1799 takeItems(int count, ItemStorage inventory) {
        return InventoryUtil.takeItems(count, inventory, 0, inventory.size(), 0);
    }

    @Nonnull
    public static class_1799 takeItems(int count, ItemStorage inventory, int start, int range, int begin) {
        class_1799 partialStack = class_1799.field_8037;
        for (int i = 0; i < range; ++i) {
            int slot = start + (i + begin - start) % range;
            if (count <= 0) break;
            class_1799 extracted = inventory.take(slot, count, partialStack, false);
            if (extracted.method_7960()) continue;
            count -= extracted.method_7947();
            if (partialStack.method_7960()) {
                partialStack = extracted;
                count = Math.min(count, extracted.method_7914());
                continue;
            }
            partialStack.method_7933(extracted.method_7947());
        }
        return partialStack;
    }
}

