/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_2350;

public interface ItemStorage {
    public static ItemStorage wrap(class_1263 inventory) {
        return new InventoryWrapper(inventory);
    }

    public static ItemStorage wrap(@Nonnull class_1278 inventory, @Nonnull class_2350 facing) {
        return new SidedInventoryWrapper(inventory, facing);
    }

    public static ItemStorage wrap(@Nonnull class_1263 inventory, @Nonnull class_2350 facing) {
        return inventory instanceof class_1278 ? new SidedInventoryWrapper((class_1278)inventory, facing) : new InventoryWrapper(inventory);
    }

    public static boolean areStackable(@Nonnull class_1799 a, @Nonnull class_1799 b) {
        return a == b || a.method_7909() == b.method_7909() && class_1799.method_7975((class_1799)a, (class_1799)b);
    }

    public int size();

    @Nonnull
    public class_1799 getStack(int var1);

    public void setStack(int var1, class_1799 var2);

    @Nonnull
    public class_1799 take(int var1, int var2, @Nonnull class_1799 var3, boolean var4);

    @Nonnull
    public class_1799 store(int var1, @Nonnull class_1799 var2, boolean var3);

    default public ItemStorage view(int start, int size) {
        return new View(this, start, size);
    }

    public static class InventoryWrapper
    implements ItemStorage {
        private final class_1263 inventory;

        InventoryWrapper(class_1263 inventory) {
            this.inventory = inventory;
        }

        @Override
        public int size() {
            return this.inventory.method_5439();
        }

        @Override
        @Nonnull
        public class_1799 getStack(int slot) {
            return this.inventory.method_5438(slot);
        }

        @Override
        public void setStack(int slot, class_1799 stack) {
            this.setAndDirty(slot, stack);
        }

        @Override
        @Nonnull
        public class_1799 take(int slot, int limit, @Nonnull class_1799 filter, boolean simulate) {
            class_1799 existing = this.inventory.method_5438(slot);
            if (existing.method_7960() || !this.canExtract(slot, existing) || !filter.method_7960() && !ItemStorage.areStackable(existing, filter)) {
                return class_1799.field_8037;
            }
            if (simulate) {
                if ((existing = existing.method_7972()).method_7947() > limit) {
                    existing.method_7939(limit);
                }
                return existing;
            }
            if (existing.method_7947() < limit) {
                this.setAndDirty(slot, class_1799.field_8037);
                return existing;
            }
            class_1799 result = existing.method_7971(limit);
            this.setAndDirty(slot, existing);
            return result;
        }

        protected boolean canExtract(int slot, class_1799 stack) {
            return true;
        }

        private void setAndDirty(int slot, @Nonnull class_1799 stack) {
            this.inventory.method_5447(slot, stack);
            this.inventory.method_5431();
        }

        @Override
        @Nonnull
        public class_1799 store(int slot, @Nonnull class_1799 stack, boolean simulate) {
            if (stack.method_7960() || !this.inventory.method_5437(slot, stack)) {
                return stack;
            }
            class_1799 existing = this.inventory.method_5438(slot);
            if (existing.method_7960()) {
                int limit = Math.min(stack.method_7914(), this.inventory.method_5444());
                if (limit <= 0) {
                    return stack;
                }
                if (stack.method_7947() < limit) {
                    if (!simulate) {
                        this.setAndDirty(slot, stack);
                    }
                    return class_1799.field_8037;
                }
                stack = stack.method_7972();
                class_1799 insert = stack.method_7971(limit);
                if (!simulate) {
                    this.setAndDirty(slot, insert);
                }
                return stack;
            }
            if (ItemStorage.areStackable(stack, existing)) {
                int limit = Math.min(existing.method_7914(), this.inventory.method_5444()) - existing.method_7947();
                if (limit <= 0) {
                    return stack;
                }
                if (stack.method_7947() < limit) {
                    if (!simulate) {
                        existing.method_7933(stack.method_7947());
                        this.setAndDirty(slot, existing);
                    }
                    return class_1799.field_8037;
                }
                stack = stack.method_7972();
                stack.method_7934(limit);
                if (!simulate) {
                    existing.method_7933(limit);
                    this.setAndDirty(slot, existing);
                }
                return stack;
            }
            return stack;
        }
    }

    public static class SidedInventoryWrapper
    extends InventoryWrapper {
        private final class_1278 inventory;
        private final class_2350 facing;

        SidedInventoryWrapper(class_1278 inventory, class_2350 facing) {
            super((class_1263)inventory);
            this.inventory = inventory;
            this.facing = facing;
        }

        @Override
        protected boolean canExtract(int slot, class_1799 stack) {
            return super.canExtract(slot, stack) && this.inventory.method_5493(slot, stack, this.facing);
        }

        @Override
        public int size() {
            return this.inventory.method_5494(this.facing).length;
        }

        @Override
        @Nonnull
        public class_1799 take(int slot, int limit, @Nonnull class_1799 filter, boolean simulate) {
            int[] slots = this.inventory.method_5494(this.facing);
            return slot >= 0 && slot < slots.length ? super.take(slots[slot], limit, filter, simulate) : class_1799.field_8037;
        }

        @Override
        @Nonnull
        public class_1799 store(int slot, @Nonnull class_1799 stack, boolean simulate) {
            int[] slots = this.inventory.method_5494(this.facing);
            if (slot < 0 || slot >= slots.length) {
                return stack;
            }
            int mappedSlot = slots[slot];
            if (!this.inventory.method_5492(slot, stack, this.facing)) {
                return stack;
            }
            return super.store(mappedSlot, stack, simulate);
        }
    }

    public static class View
    implements ItemStorage {
        private final ItemStorage parent;
        private final int start;
        private final int size;

        View(ItemStorage parent, int start, int size) {
            this.parent = parent;
            this.start = start;
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        @Nonnull
        public class_1799 getStack(int slot) {
            if (slot < this.start || slot >= this.start + this.size) {
                return class_1799.field_8037;
            }
            return this.parent.getStack(slot - this.start);
        }

        @Override
        public void setStack(int slot, class_1799 stack) {
            if (slot < this.start || slot >= this.start + this.size) {
                return;
            }
            this.parent.setStack(slot - this.start, stack);
        }

        @Override
        @Nonnull
        public class_1799 take(int slot, int limit, @Nonnull class_1799 filter, boolean simulate) {
            if (slot < this.start || slot >= this.start + this.size) {
                return class_1799.field_8037;
            }
            return this.parent.take(slot - this.start, limit, filter, simulate);
        }

        @Override
        @Nonnull
        public class_1799 store(int slot, @Nonnull class_1799 stack, boolean simulate) {
            if (slot < this.start || slot >= this.start + this.size) {
                return stack;
            }
            return this.parent.store(slot - this.start, stack, simulate);
        }

        @Override
        public ItemStorage view(int start, int size) {
            return new View(this.parent, this.start + start, size);
        }
    }
}

