/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.debug;

import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugState;

public class DebugHandler {
    public static final DebugHandler INSTANCE = new DebugHandler();

    public static DebugState getDebugState(LuaState state) {
        return state.getCurrentThread().getDebugState();
    }

    protected DebugHandler() {
    }

    public void onReturn(DebugState ds, DebugFrame di) throws LuaError, UnwindThrowable {
        try {
            if (!ds.inhook && ds.hookrtrn) {
                ds.hookReturn(di);
            }
        }
        catch (RuntimeException | LuaError e) {
            ds.popInfo();
            throw e;
        }
        ds.popInfo();
    }

    public void onReturnError(DebugState ds) {
        ds.popInfo();
    }

    public void onInstruction(DebugState ds, DebugFrame di, int pc) throws LuaError, UnwindThrowable {
        di.pc = pc;
        if (!ds.inhook) {
            if ((di.flags & 0x40) == 0) {
                if (ds.hookcount > 0 && ++ds.hookcodes >= ds.hookcount) {
                    ds.hookcodes = 0;
                    ds.hookInstruction(di);
                }
            } else {
                di.flags &= 0xFFFFFFBF;
            }
            if ((di.flags & 0x800) == 0) {
                if (ds.hookline && di.closure != null) {
                    Prototype prototype = di.closure.getPrototype();
                    int[] lineInfo = prototype.lineinfo;
                    int newLine = lineInfo != null && pc >= 0 && pc < lineInfo.length ? lineInfo[pc] : -1;
                    int oldPc = di.oldPc;
                    if (oldPc == -1 || pc <= oldPc || newLine != (lineInfo != null && oldPc >= 0 && oldPc < lineInfo.length ? lineInfo[oldPc] : -1)) {
                        ds.hookLine(di, newLine);
                    }
                }
            } else {
                di.flags &= 0xFFFFF7FF;
            }
            di.oldPc = pc;
        }
    }

    public void poll() throws LuaError {
    }
}

