/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib.doubles;

import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.checker.signedness.qual.Unsigned;
import org.checkerframework.common.value.qual.UnknownVal;
import org.squiddev.cobalt.lib.doubles.Assert;
import org.squiddev.cobalt.lib.doubles.UnsignedValues;

public class DiyFp {
    public static final @UnknownVal @Signed int SIGNIFICAND_SIZE = 64;
    private static final @UnknownVal @Signed long UINT_64_MSB = Long.MIN_VALUE;
    private @Unsigned @UnknownVal long f;
    private @UnknownVal @Signed int e;

    DiyFp() {
        this.f = 0L;
        this.e = 0;
    }

    DiyFp(@Unsigned @UnknownVal long significand, @UnknownVal @Signed int exponent) {
        this.f = significand;
        this.e = exponent;
    }

    public @UnknownVal @UnknownSignedness DiyFp copy() {
        return new DiyFp(this.f, this.e);
    }

    public void subtract(@UnknownVal @UnknownSignedness DiyFp other) {
        Assert.requireArg(this.e == other.e, "exponents must match");
        Assert.requireArg(UnsignedValues.ulongGE(this.f, other.f), "other.f must be greater than this.f");
        this.f -= other.f;
    }

    public static @UnknownVal @UnknownSignedness DiyFp minus(@UnknownVal @UnknownSignedness DiyFp a, @UnknownVal @UnknownSignedness DiyFp b) {
        DiyFp result = a.copy();
        result.subtract(b);
        return result;
    }

    public void multiply(@UnknownVal @UnknownSignedness DiyFp other) {
        @Unsigned long otherF = other.f;
        long kM32 = 0xFFFFFFFFL;
        long a = this.f >>> 32;
        long b = this.f & 0xFFFFFFFFL;
        long c = otherF >>> 32;
        long d = otherF & 0xFFFFFFFFL;
        long ac = a * c;
        long bc = b * c;
        long ad = a * d;
        long bd = b * d;
        long tmp = (bd >>> 32) + (ad & 0xFFFFFFFFL) + (bc & 0xFFFFFFFFL) + 0x80000000L;
        this.e += other.e + 64;
        this.f = ac + (ad >>> 32) + (bc >>> 32) + (tmp >>> 32);
    }

    public static @UnknownVal @UnknownSignedness DiyFp times(@UnknownVal @UnknownSignedness DiyFp a, @UnknownVal @UnknownSignedness DiyFp b) {
        DiyFp result = a.copy();
        result.multiply(b);
        return result;
    }

    public void normalize() {
        if (Assert.assertEnabled()) {
            Assert.assertThat(this.f != 0L);
        }
        @Unsigned long significand = this.f;
        int exponent = this.e;
        @Unsigned long k10MSBits = -18014398509481984L;
        while ((significand & 0xFFC0000000000000L) == 0L) {
            significand <<= 10;
            exponent -= 10;
        }
        while ((significand & Long.MIN_VALUE) == 0L) {
            significand <<= 1;
            --exponent;
        }
        this.f = significand;
        this.e = exponent;
    }

    public static @UnknownVal @UnknownSignedness DiyFp normalize(@UnknownVal @UnknownSignedness DiyFp a) {
        DiyFp result = a.copy();
        result.normalize();
        return result;
    }

    public @Unsigned @UnknownVal long f() {
        return this.f;
    }

    public @UnknownVal @Signed int e() {
        return this.e;
    }

    public void setF(@Unsigned @UnknownVal long new_value) {
        this.f = new_value;
    }

    public void setE(@UnknownVal @Signed int new_value) {
        this.e = new_value;
    }
}

