/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.samo_lego.fabrictailor.command.FabrictailorCommand;
import org.samo_lego.fabrictailor.command.SkinCommand;
import org.samo_lego.fabrictailor.config.TailorConfig;

public class FabricTailor
implements ModInitializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "fabrictailor";
    public static TailorConfig config;
    public static File configFile;
    public static final ExecutorService THREADPOOL;

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> {
            SkinCommand.register((CommandDispatcher<class_2168>)dispatcher, dedicated);
            FabrictailorCommand.register((CommandDispatcher<class_2168>)dispatcher, dedicated);
        });
        configFile = new File(FabricLoader.getInstance().getConfigDir() + "/fabrictailor.json");
        config = TailorConfig.loadConfigFile(configFile, new File("./server.properties").exists());
        config.save();
    }

    public static void errorLog(String error) {
        LOGGER.error("[FabricTailor] An error occurred: " + error);
    }

    public static void reloadConfig() {
        TailorConfig newConfig = TailorConfig.loadConfigFile(configFile, new File("./server.properties").exists());
        config.reload(newConfig);
    }

    static {
        THREADPOOL = Executors.newCachedThreadPool();
    }
}

