/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.screen.Badge;
import io.github.apace100.origins.util.PowerKeyManager;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class OriginDisplayScreen
extends class_437 {
    private static final class_2960 WINDOW = new class_2960("origins", "textures/gui/choose_origin.png");
    private Origin origin;
    private OriginLayer layer;
    private boolean isOriginRandom;
    private class_2561 randomOriginText;
    protected static final int windowWidth = 176;
    protected static final int windowHeight = 182;
    protected int scrollPos = 0;
    private int currentMaxScroll = 0;
    protected int guiTop;
    protected int guiLeft;
    protected final boolean showDirtBackground;
    private final List<RenderedBadge> renderedBadges = new LinkedList<RenderedBadge>();
    private boolean scrolling = false;
    private int scrollDragStart = 0;
    private double mouseDragStart = 0.0;

    public OriginDisplayScreen(class_2561 title, boolean showDirtBackground) {
        super(title);
        this.showDirtBackground = showDirtBackground;
    }

    public void showOrigin(Origin origin, OriginLayer layer, boolean isRandom) {
        this.origin = origin;
        this.layer = layer;
        this.isOriginRandom = isRandom;
        this.scrollPos = 0;
    }

    public void setRandomOriginText(class_2561 text) {
        this.randomOriginText = text;
    }

    protected void method_25426() {
        super.method_25426();
        this.guiLeft = (this.field_22789 - 176) / 2;
        this.guiTop = (this.field_22790 - 182) / 2;
    }

    public Origin getCurrentOrigin() {
        return this.origin;
    }

    public OriginLayer getCurrentLayer() {
        return this.layer;
    }

    public void method_25433(class_4587 matrices, int vOffset) {
        if (this.showDirtBackground) {
            super.method_25434(vOffset);
        } else {
            super.method_25433(matrices, vOffset);
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.renderedBadges.clear();
        this.method_25420(matrices);
        this.renderOriginWindow(matrices, mouseX, mouseY);
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.origin != null) {
            this.renderScrollbar(matrices, mouseX, mouseY);
            this.renderBadgeTooltip(matrices, mouseX, mouseY);
        }
    }

    private void renderScrollbar(class_4587 matrices, int mouseX, int mouseY) {
        if (!this.canScroll()) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)WINDOW);
        this.method_25302(matrices, this.guiLeft + 155, this.guiTop + 35, 188, 24, 8, 134);
        int scrollbarY = 36;
        int maxScrollbarOffset = 141;
        int u = 176;
        float part = (float)this.scrollPos / (float)this.currentMaxScroll;
        scrollbarY = (int)((float)scrollbarY + (float)(maxScrollbarOffset - scrollbarY) * part);
        if (this.scrolling) {
            u += 6;
        } else if (mouseX >= this.guiLeft + 156 && mouseX < this.guiLeft + 156 + 6 && mouseY >= this.guiTop + scrollbarY && mouseY < this.guiTop + scrollbarY + 27) {
            u += 6;
        }
        this.method_25302(matrices, this.guiLeft + 156, this.guiTop + scrollbarY, u, 24, 6, 27);
    }

    private boolean canScroll() {
        return this.origin != null && this.currentMaxScroll > 0;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.canScroll()) {
            this.scrolling = false;
            int scrollbarY = 36;
            int maxScrollbarOffset = 141;
            float part = (float)this.scrollPos / (float)this.currentMaxScroll;
            scrollbarY = (int)((float)scrollbarY + (float)(maxScrollbarOffset - scrollbarY) * part);
            if (mouseX >= (double)(this.guiLeft + 156) && mouseX < (double)(this.guiLeft + 156 + 6) && mouseY >= (double)(this.guiTop + scrollbarY) && mouseY < (double)(this.guiTop + scrollbarY + 27)) {
                this.scrolling = true;
                this.scrollDragStart = scrollbarY;
                this.mouseDragStart = mouseY;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            int delta = (int)(mouseY - this.mouseDragStart);
            int newScrollPos = Math.max(36, Math.min(141, this.scrollDragStart + delta));
            float part = (float)(newScrollPos - 36) / 105.0f;
            this.scrollPos = (int)(part * (float)this.currentMaxScroll);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void renderBadgeTooltip(class_4587 matrices, int mouseX, int mouseY) {
        for (RenderedBadge badge : this.renderedBadges) {
            if (mouseX < badge.x || mouseX >= badge.x + 9 || mouseY < badge.y || mouseY >= badge.y + 9) continue;
            String hoverText = badge.badge.getHoverText();
            String keyId = PowerKeyManager.getKeyIdentifier(badge.power);
            class_2561 keybindText = (class_2561)class_304.method_1419((String)keyId).get();
            if (keybindText.getString().isEmpty()) {
                keybindText = new class_2588(keyId).method_27692(class_124.field_1056);
            }
            class_5250 keyText = new class_2585("[").method_10852(keybindText).method_27693("]");
            int maxWidth = this.field_22789 - mouseX - 24;
            if (mouseX > this.field_22789 / 2) {
                maxWidth = mouseX - 24;
            }
            if (hoverText.contains("\n")) {
                String[] texts;
                LinkedList<class_5481> lines = new LinkedList<class_5481>();
                for (String text : texts = hoverText.split("\n")) {
                    class_2588 t = new class_2588(text, new Object[]{keyText});
                    if (this.field_22793.method_27525((class_5348)t) > maxWidth) {
                        List wrapped = this.field_22793.method_1728((class_5348)t, maxWidth);
                        lines.addAll(wrapped);
                        continue;
                    }
                    lines.add(t.method_30937());
                }
                this.method_25417(matrices, lines, mouseX, mouseY);
                break;
            }
            class_2588 text = new class_2588(hoverText, new Object[]{keyText});
            if (this.field_22793.method_27525((class_5348)text) > maxWidth) {
                List wrapped = this.field_22793.method_1728((class_5348)text, maxWidth);
                this.method_25417(matrices, wrapped, mouseX, mouseY);
                break;
            }
            this.method_25424(matrices, (class_2561)text, mouseX, mouseY);
            break;
        }
    }

    protected class_2561 getTitleText() {
        return new class_2585("Origins");
    }

    private void renderOriginWindow(class_4587 matrices, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        this.renderWindowBackground(matrices, 16, 0);
        if (this.origin != null) {
            this.renderOriginContent(matrices, mouseX, mouseY);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)WINDOW);
        this.method_25302(matrices, this.guiLeft, this.guiTop, 0, 0, 176, 182);
        if (this.origin != null) {
            this.renderOriginName(matrices);
            RenderSystem.setShaderTexture((int)0, (class_2960)WINDOW);
            this.renderOriginImpact(matrices, mouseX, mouseY);
            class_2561 title = this.getTitleText();
            OriginDisplayScreen.method_25300((class_4587)matrices, (class_327)this.field_22793, (String)title.getString(), (int)(this.field_22789 / 2), (int)(this.guiTop - 15), (int)0xFFFFFF);
        }
        RenderSystem.disableBlend();
    }

    private void renderOriginImpact(class_4587 matrices, int mouseX, int mouseY) {
        Impact impact = this.getCurrentOrigin().getImpact();
        int impactValue = impact.getImpactValue();
        int wOffset = impactValue * 8;
        for (int i = 0; i < 3; ++i) {
            if (i < impactValue) {
                this.method_25302(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176 + wOffset, 16, 8, 8);
                continue;
            }
            this.method_25302(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176, 16, 8, 8);
        }
        if (mouseX >= this.guiLeft + 128 && mouseX <= this.guiLeft + 158 && mouseY >= this.guiTop + 19 && mouseY <= this.guiTop + 27) {
            class_2588 ttc = (class_2588)new class_2588("origins.gui.impact.impact").method_27693(": ").method_10852((class_2561)impact.getTextComponent());
            this.method_25424(matrices, (class_2561)ttc, mouseX, mouseY);
        }
    }

    private void renderOriginName(class_4587 matrices) {
        class_5348 originName = this.field_22793.method_1714((class_5348)this.getCurrentOrigin().getName(), 140);
        OriginDisplayScreen.method_25303((class_4587)matrices, (class_327)this.field_22793, (String)originName.getString(), (int)(this.guiLeft + 39), (int)(this.guiTop + 19), (int)0xFFFFFF);
        class_1799 is = this.getCurrentOrigin().getDisplayItem();
        this.field_22788.method_27953(is, this.guiLeft + 15, this.guiTop + 15);
    }

    private void renderWindowBackground(class_4587 matrices, int offsetYStart, int offsetYEnd) {
        int border = 13;
        int endX = this.guiLeft + 176 - border;
        int endY = this.guiTop + 182 - border;
        RenderSystem.setShaderTexture((int)0, (class_2960)WINDOW);
        for (int x = this.guiLeft; x < endX; x += 16) {
            for (int y = this.guiTop + offsetYStart; y < endY + offsetYEnd; y += 16) {
                this.method_25302(matrices, x, y, 176, 0, Math.max(16, endX - x), Math.max(16, endY + offsetYEnd - y));
            }
        }
    }

    public boolean method_25401(double x, double y, double z) {
        boolean retValue = super.method_25401(x, y, z);
        int np = this.scrollPos - (int)z * 4;
        this.scrollPos = np < 0 ? 0 : Math.min(np, this.currentMaxScroll);
        return retValue;
    }

    private void renderOriginContent(class_4587 matrices, int mouseX, int mouseY) {
        int y;
        int textWidth = 128;
        Origin origin = this.getCurrentOrigin();
        int x = this.guiLeft + 18;
        int startY = y = this.guiTop + 50;
        int endY = y - 72 + 182;
        y -= this.scrollPos;
        class_2588 orgDesc = origin.getDescription();
        List descLines = this.field_22793.method_1728((class_5348)orgDesc, textWidth);
        for (class_5481 class_54812 : descLines) {
            if (y >= startY - 18 && y <= endY + 12) {
                this.field_22793.method_27528(matrices, class_54812, (float)(x + 2), (float)(y - 6), 0xCCCCCC);
            }
            y += 12;
        }
        if (this.isOriginRandom) {
            List drawLines = this.field_22793.method_1728((class_5348)this.randomOriginText, textWidth);
            for (class_5481 line : drawLines) {
                if ((y += 12) < startY - 24 || y > endY + 12) continue;
                this.field_22793.method_27528(matrices, line, (float)(x + 2), (float)y, 0xCCCCCC);
            }
            y += 14;
        } else {
            for (PowerType powerType : origin.getPowerTypes()) {
                if (powerType.isHidden()) continue;
                class_5481 name = class_2477.method_10517().method_30934(this.field_22793.method_1714((class_5348)powerType.getName().method_27692(class_124.field_1073), textWidth));
                class_2588 desc = powerType.getDescription();
                List drawLines = this.field_22793.method_1728((class_5348)desc, textWidth);
                if (y >= startY - 24 && y <= endY + 12) {
                    this.field_22793.method_27528(matrices, name, (float)x, (float)y, 0xFFFFFF);
                    int tw = this.field_22793.method_30880(name);
                    List<Badge> badges = Origins.badgeManager.getBadges(powerType.getIdentifier());
                    int xStart = x + tw + 4;
                    int bi = 0;
                    for (Badge badge : badges) {
                        RenderSystem.setShaderTexture((int)0, (class_2960)badge.getSpriteLocation());
                        OriginDisplayScreen.method_25290((class_4587)matrices, (int)(xStart + 10 * bi), (int)(y - 1), (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
                        RenderedBadge rb = new RenderedBadge();
                        rb.badge = badge;
                        rb.power = powerType.getIdentifier();
                        rb.x = xStart + 10 * bi;
                        rb.y = y - 1;
                        this.renderedBadges.add(rb);
                        ++bi;
                    }
                }
                for (class_5481 line : drawLines) {
                    if ((y += 12) < startY - 24 || y > endY + 12) continue;
                    this.field_22793.method_27528(matrices, line, (float)(x + 2), (float)y, 0xCCCCCC);
                }
                y += 14;
            }
        }
        this.currentMaxScroll = (y += this.scrollPos) - 14 - (this.guiTop + 158);
        if (this.currentMaxScroll < 0) {
            this.currentMaxScroll = 0;
        }
    }

    private static class RenderedBadge {
        class_2960 power;
        Badge badge;
        int x;
        int y;

        private RenderedBadge() {
        }
    }
}

