/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import virtuoel.kanos_config.api.MutableConfigEntry;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.util.ModLoaderUtils;

public class ConfigSyncUtils {
    private static final Map<String, SyncableConfigEntry<?>> SYNCED_CONFIGS = new HashMap();
    private static final Map<String, ConfigEntryCodec<?>> SYNCED_CONFIG_CODECS = new HashMap();
    private static final Map<String, ConfigEntryCodec<?>> CODECS = new HashMap();
    private static final boolean NETWORKING_API_LOADED;

    public static void resetSyncedConfigs() {
        SYNCED_CONFIGS.values().forEach(entry -> entry.setSyncedValue(null));
    }

    public static void writeConfigs(class_3244 networkHandler) {
        ConfigSyncUtils.syncConfigs(networkHandler, SYNCED_CONFIGS.values());
    }

    public static void syncConfigs(class_3244 networkHandler, String ... configEntryKeys) {
        ArrayList entries = new ArrayList();
        for (String key : configEntryKeys) {
            SyncableConfigEntry<?> entry;
            if (!SYNCED_CONFIGS.containsKey(key) || (entry = SYNCED_CONFIGS.get(key)) == null) continue;
            entries.add(entry);
        }
        ConfigSyncUtils.syncConfigs(networkHandler, entries);
    }

    public static void syncConfigs(class_3244 networkHandler, Collection<SyncableConfigEntry<?>> configEntries) {
        if (NETWORKING_API_LOADED && ServerPlayNetworking.canSend((class_3244)networkHandler, (class_2960)Pehkui.CONFIG_SYNC_PACKET)) {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            buffer.method_10804(configEntries.size());
            for (SyncableConfigEntry<?> entry : configEntries) {
                buffer.method_10814(entry.getName());
                SYNCED_CONFIG_CODECS.get(entry.getName()).write(buffer, entry);
            }
            networkHandler.method_14364((class_2596)new class_2658(Pehkui.CONFIG_SYNC_PACKET, buffer));
        }
    }

    public static Runnable readConfigs(class_2540 buffer) {
        int qty = buffer.method_10816();
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        for (int i = 0; i < qty; ++i) {
            String name = buffer.method_19772();
            SyncableConfigEntry<?> entry = SYNCED_CONFIGS.get(name);
            ConfigEntryCodec<?> codec = SYNCED_CONFIG_CODECS.get(name);
            if (entry == null) {
                Pehkui.LOGGER.warn("Received unknown config \"{}\" from server.", (Object)name);
                break;
            }
            if (codec == null) {
                Pehkui.LOGGER.warn("Codec \"{}\" not found. Could not parse config \"{}\" from server.", codec, (Object)name);
                break;
            }
            tasks.add(codec.read(buffer, entry));
        }
        return () -> tasks.forEach(Runnable::run);
    }

    public static <T> MutableConfigEntry<T> createSyncedConfig(String name, Supplier<T> supplier, Consumer<T> consumer) {
        if (SYNCED_CONFIGS.containsKey(name)) {
            SyncableConfigEntry<Object> entry = SYNCED_CONFIGS.get(name);
            if (entry == null) {
                entry = new SyncableConfigEntry<T>(name, supplier, consumer);
                SYNCED_CONFIGS.put(name, entry);
            }
            return entry;
        }
        return new NamedConfigEntry<T>(name, supplier, consumer);
    }

    public static void setupSyncableConfig(String name, String codecKey) {
        SYNCED_CONFIGS.put(name, null);
        SYNCED_CONFIG_CODECS.put(name, Objects.requireNonNull(CODECS.get(codecKey), String.format("Codec \"%s\" not found for config \"%s\"", codecKey, name)));
    }

    static {
        CODECS.put("double", new ConfigEntryCodec((b, e) -> b.writeDouble(((Double)e.getValue()).doubleValue()), (b, e) -> {
            double v = b.readDouble();
            return () -> e.setSyncedValue(v);
        }));
        CODECS.put("boolean", new ConfigEntryCodec((b, e) -> b.writeBoolean(((Boolean)e.getValue()).booleanValue()), (b, e) -> {
            boolean v = b.readBoolean();
            return () -> e.setSyncedValue(v);
        }));
        CODECS.put("string_list", new ConfigEntryCodec((b, e) -> {
            List list = (List)e.getValue();
            b.method_10804(list.size());
            for (String v : list) {
                b.method_10814(v);
            }
        }, (b, e) -> {
            ArrayList<String> v = new ArrayList<String>();
            int size = b.method_10816();
            for (int i = 0; i < size; ++i) {
                v.add(b.method_19772());
            }
            return () -> e.setSyncedValue(v);
        }));
        NETWORKING_API_LOADED = ModLoaderUtils.isModLoaded("fabric-networking-api-v1");
    }

    private static class SyncableConfigEntry<T>
    extends NamedConfigEntry<T> {
        protected T syncedValue = null;

        public SyncableConfigEntry(String name, Supplier<T> supplier, Consumer<T> consumer) {
            super(name, supplier, consumer);
        }

        public void setSyncedValue(T value) {
            this.syncedValue = value;
        }

        @Override
        public T get() {
            if (this.syncedValue != null) {
                return this.syncedValue;
            }
            return super.get();
        }

        @Override
        public T getValue() {
            if (this.syncedValue != null) {
                return this.syncedValue;
            }
            return super.getValue();
        }
    }

    private static class ConfigEntryCodec<T> {
        final BiConsumer<class_2540, SyncableConfigEntry<T>> writer;
        final BiFunction<class_2540, SyncableConfigEntry<T>, Runnable> reader;

        public ConfigEntryCodec(BiConsumer<class_2540, SyncableConfigEntry<T>> writer, BiFunction<class_2540, SyncableConfigEntry<T>, Runnable> reader) {
            this.writer = writer;
            this.reader = reader;
        }

        public void write(class_2540 buffer, SyncableConfigEntry<T> entry) {
            this.writer.accept(buffer, entry);
        }

        public Runnable read(class_2540 buffer, SyncableConfigEntry<T> entry) {
            return this.reader.apply(buffer, entry);
        }
    }

    private static class NamedConfigEntry<T>
    implements MutableConfigEntry<T> {
        protected final String name;
        protected final Supplier<T> supplier;
        protected final Consumer<T> consumer;

        public NamedConfigEntry(String name, Supplier<T> supplier, Consumer<T> consumer) {
            this.name = name;
            this.supplier = supplier;
            this.consumer = consumer;
        }

        public String getName() {
            return this.name;
        }

        public T get() {
            return this.supplier.get();
        }

        public void accept(T t) {
            this.consumer.accept(t);
        }

        public T getValue() {
            return this.supplier.get();
        }

        public void setValue(T t) {
            this.consumer.accept(t);
        }
    }
}

