/*
 * Decompiled with CFR 0.152.
 */
package com.eyezah.cosmetics;

import com.eyezah.cosmetics.Authentication;
import com.eyezah.cosmetics.CosmeticaConfig;
import com.eyezah.cosmetics.CosmeticaSkinManager;
import com.eyezah.cosmetics.DefaultSettingsConfig;
import com.eyezah.cosmetics.FabriStationConnector;
import com.eyezah.cosmetics.ThreadPool;
import com.eyezah.cosmetics.api.PlayerData;
import com.eyezah.cosmetics.cosmetics.Hat;
import com.eyezah.cosmetics.cosmetics.model.BakableModel;
import com.eyezah.cosmetics.cosmetics.model.Models;
import com.eyezah.cosmetics.utils.Debug;
import com.eyezah.cosmetics.utils.FormattedChatEncoder;
import com.eyezah.cosmetics.utils.NamedThreadFactory;
import com.eyezah.cosmetics.utils.Response;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1059;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_327;
import net.minecraft.class_3300;
import net.minecraft.class_412;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_591;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_898;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class Cosmetica
implements ClientModInitializer {
    public static class_412 connectScreen;
    public static String authServerHost;
    public static int authServerPort;
    public static String apiServerHost;
    public static String insecureApiServerHost;
    public static String displayNext;
    public static String websiteHost;
    public static String currentServerAddressCache;
    private static Map<UUID, PlayerData> playerDataCache;
    private static Set<UUID> lookingUp;
    public static final Logger LOGGER;
    private static final ExecutorService MAIN_POOL;
    private static CosmeticaConfig config;
    private static DefaultSettingsConfig defaultSettingsConfig;
    private static OptionalLong toto;
    private static final Pattern UNDASHED_UUID_GAPS;
    private static final String UUID_DASHIFIER_REPLACEMENT = "$1-$2-$3-$4-$5";

    public static CosmeticaConfig getConfig() {
        return config;
    }

    public static DefaultSettingsConfig getDefaultSettingsConfig() {
        return defaultSettingsConfig;
    }

    public void onInitializeClient() {
        config = new CosmeticaConfig(FabricLoader.getInstance().getConfigDir().resolve("cosmetica").resolve("cosmetica.properties"));
        defaultSettingsConfig = new DefaultSettingsConfig(FabricLoader.getInstance().getConfigDir().resolve("cosmetica").resolve("default-settings.properties"));
        try {
            config.initialize();
            defaultSettingsConfig.initialize();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load config, falling back to defaults!");
            e.printStackTrace();
        }
        Debug.clearImages();
        Cosmetica.runOffthread(() -> {
            File minecraftDir = Cosmetica.findDefaultInstallDir("minecraft").toFile();
            File file = new File(minecraftDir, "cosmetica_website_host_cache.txt");
            String apiGetHost = null;
            try (Response response = Response.request("https://raw.githubusercontent.com/EyezahMC/Cosmetica/master/api_provider_host.json?timestamp=" + System.currentTimeMillis());){
                if (response.getError().isEmpty()) {
                    Debug.info("Received response from Github CDN. We do not require a fallback (hopefully)!", new Object[0]);
                    apiGetHost = response.getAsJson().get("current_host").getAsString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            apiGetHost = Cosmetica.loadOrCache(file, apiGetHost);
            if (apiGetHost == null) {
                apiGetHost = "https://cosmetica.cc/getapi";
            }
            Debug.info("Finished retrieving GetAPI Url. Conclusion: we can get an API server from " + apiGetHost, new Object[0]);
            file = new File(minecraftDir, "cosmetica_get_api_cache.json");
            String apiGetData = null;
            try (Response apiGetResponse = Response.request(apiGetHost);){
                apiGetData = apiGetResponse.getAsString();
                Debug.info("Received API Url from Server", new Object[0]);
            }
            catch (Exception e) {
                LOGGER.warn("Connection error to API GET. Trying to retrieve from local cache...");
            }
            apiGetData = Cosmetica.loadOrCache(file, apiGetData);
            if (apiGetData == null) {
                LOGGER.error("Could not receive Cosmetica API host. Mod functionality will be disabled!");
            } else {
                try {
                    JsonObject data = new JsonParser().parse(apiGetData).getAsJsonObject();
                    apiServerHost = data.get("api").getAsString();
                    insecureApiServerHost = "http" + apiServerHost.substring(5);
                    websiteHost = data.get("website").getAsString();
                    JsonObject auth = data.get("auth-server").getAsJsonObject();
                    authServerHost = auth.get("hostname").getAsString();
                    authServerPort = auth.get("port").getAsInt();
                    LOGGER.info(data.get("message").getAsString());
                    Debug.info("Finished retrieving API Url. Conclusion: the API should be contacted at " + apiServerHost, new Object[0]);
                    Authentication.runAuthentication((class_437)new class_442(), 1);
                    String versionCheck = apiServerHost + "/get/versioncheck?modversion=" + Cosmetica.urlEncode(((ModContainer)FabricLoader.getInstance().getModContainer("cosmetica").get()).getMetadata().getVersion().getFriendlyString()) + "&mcversion=" + class_155.method_16673().getId();
                    Debug.checkedInfo(versionCheck, "always_print_urls");
                    try (Response response = Response.request(versionCheck);){
                        String s = response.getAsString();
                        if (!s.isEmpty()) {
                            displayNext = s;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Error checking version:");
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error reading JSON data for API Url. Mod functionality will be disabled!");
                    e.printStackTrace();
                }
            }
        }, ThreadPool.GENERAL_THREADS);
        ClientSpriteRegistryCallback.event((class_2960)class_1059.field_5275).register((atlasTexture, registry) -> {
            for (int i = 0; i < 128; ++i) {
                registry.register(new class_2960("cosmetica", "generated/reserved_" + i));
            }
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("cosmetica", "cache_clearer");
            }

            public void method_14491(class_3300 resourceManager) {
                Models.resetTextureBasedCaches();
            }
        });
        Authentication.runAuthenticationCheckThread();
    }

    public static boolean isProbablyNPC(UUID uuid) {
        return uuid.version() == 2;
    }

    private static String loadOrCache(File file, @Nullable String value) {
        block13: {
            try {
                if (value != null) {
                    file.createNewFile();
                    try (FileWriter writer = new FileWriter(file);){
                        writer.write(value);
                        break block13;
                    }
                }
                if (!file.isFile()) break block13;
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    value = reader.readLine().trim();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private static Path findDefaultInstallDir(String application) {
        Path dir;
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (os.contains("win") && System.getenv("APPDATA") != null) {
            dir = Paths.get(System.getenv("APPDATA"), new String[0]).resolve("." + application);
        } else {
            String home = System.getProperty("user.home", ".");
            Path homeDir = Paths.get(home, new String[0]);
            dir = os.contains("mac") ? homeDir.resolve("Library").resolve("Application Support").resolve(application) : homeDir.resolve("." + application);
        }
        return dir.toAbsolutePath().normalize();
    }

    public static void onShutdownClient() {
        try {
            MAIN_POOL.shutdownNow();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public static String getFabriStationActivity() {
        System.out.println("running activity check");
        if (FabricLoader.getInstance().isModLoaded("fabristation")) {
            System.out.println("Station is loaded");
            return FabriStationConnector.getFormatted();
        }
        System.out.println("Station isn't loaded");
        return "not connected";
    }

    public static String dashifyUUID(String uuid) {
        return UNDASHED_UUID_GAPS.matcher(uuid).replaceAll(UUID_DASHIFIER_REPLACEMENT);
    }

    public static String base64Ip(InetSocketAddress ip) {
        byte[] arr = (ip.getAddress().getHostAddress() + ":" + ip.getPort()).getBytes(StandardCharsets.UTF_8);
        return Base64.encodeBase64String((byte[])arr);
    }

    public static void safari(InetSocketAddress prideRock, boolean yourFirstRodeo) {
        if (!Authentication.getToken().isEmpty()) {
            String awimbawe = apiServerHost + "/get/everythirtysecondsinafricahalfaminutepasses?token=" + Authentication.getToken() + "&ip=" + Cosmetica.base64Ip(prideRock) + "&timestamp=";
            awimbawe = awimbawe + (yourFirstRodeo || !toto.isPresent() ? 0L : toto.getAsLong());
            Debug.checkedInfo(awimbawe, "always_print_urls");
            try (Response theLionSleepsTonight = Response.request(awimbawe);){
                JsonObject theMightyJungle = theLionSleepsTonight.getAsJson();
                if (theMightyJungle.has("error")) {
                    LOGGER.error("Server responded with error while checking for cosmetic updates : {}", (Object)theMightyJungle.get("error"));
                }
                if (theMightyJungle.has("notifications")) {
                    theMightyJungle.get("notifications").getAsJsonArray().forEach(elem -> {
                        try {
                            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)new class_2585("\u00a76\u00a7lCosmetica\u00a7f \u00a7l>\u00a77 ").method_10852(FormattedChatEncoder.chatEncode(elem.getAsString())));
                        }
                        catch (Exception e) {
                            LOGGER.error("Error sending cosmetica notification.", (Throwable)e);
                        }
                    });
                }
                JsonObject updates = theMightyJungle.getAsJsonObject("updates");
                toto = OptionalLong.of(updates.get("timestamp").getAsLong());
                if (!yourFirstRodeo) {
                    Debug.info("Processing updates found on the safari.", new Object[0]);
                    if (updates.has("list")) {
                        for (JsonElement element : updates.getAsJsonArray("list")) {
                            UUID serverUuid;
                            JsonObject individual = element.getAsJsonObject();
                            UUID uuid = UUID.fromString(Cosmetica.dashifyUUID(individual.get("uuid").getAsString()));
                            Debug.info("Your amazing lion king with expected uuid {} seems to be requesting we update his (or her, their, faer, ...) cosmetics! :lion:", uuid);
                            if (playerDataCache.containsKey(uuid)) {
                                Cosmetica.clearPlayerData(uuid);
                                if (!uuid.equals(class_310.method_1551().field_1724.method_5667())) continue;
                                Cosmetica.getPlayerData((class_1657)class_310.method_1551().field_1724);
                                continue;
                            }
                            Debug.info("Lol cringe they went scampering into a bush or something!", new Object[0]);
                            String username = individual.get("username").getAsString();
                            class_640 info = class_310.method_1551().method_1562().method_2874(username);
                            if (info == null || !playerDataCache.containsKey(serverUuid = info.method_2966().getId())) continue;
                            Debug.info("Found them :). They were hiding at uuid {}", serverUuid);
                            Cosmetica.clearPlayerData(serverUuid);
                            if (!username.equals(String.valueOf(class_310.method_1551().field_1724.method_5477()))) continue;
                            Cosmetica.getPlayerData((class_1657)class_310.method_1551().field_1724);
                        }
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Error checking for cosmetic updates on the remote server", (Throwable)e);
            }
        }
    }

    public static void runOffthread(Runnable runnable, ThreadPool pool) {
        if (Thread.currentThread().getName().startsWith("Cosmetica")) {
            runnable.run();
        } else {
            MAIN_POOL.execute(runnable);
        }
    }

    public static boolean shouldRenderUpsideDown(class_1657 player) {
        return Cosmetica.getPlayerData(player).upsideDown();
    }

    public static PlayerData getPlayerData(class_1657 player) {
        return Cosmetica.getPlayerData(player.method_5667(), player.method_5477().getString());
    }

    public static void clearPlayerData(UUID uuid) {
        playerDataCache.remove(uuid);
    }

    public static int getCacheSize() {
        return playerDataCache.size();
    }

    public static Collection<UUID> getCachedPlayers() {
        return playerDataCache.keySet();
    }

    public static boolean isPlayerCached(UUID uuid) {
        return playerDataCache.containsKey(uuid);
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlayerData getPlayerData(UUID uuid, String username) {
        if (Cosmetica.isProbablyNPC(uuid)) {
            return PlayerData.NONE;
        }
        class_638 level = class_310.method_1551().field_1687;
        Map<UUID, PlayerData> map = playerDataCache;
        synchronized (map) {
            return playerDataCache.computeIfAbsent(uuid, arg_0 -> Cosmetica.lambda$getPlayerData$4(uuid, (class_1937)level, username, arg_0));
        }
    }

    public static void onRenderNameTag(class_898 entityRenderDispatcher, class_1297 entity, class_591<class_742> playerModel, class_4587 stack, class_4597 multiBufferSource, class_327 font, int packedLight) {
        double d;
        class_1657 player;
        UUID lookupId;
        if (entity instanceof class_1657 && (lookupId = (player = (class_1657)entity).method_5667()) != null && !((d = entityRenderDispatcher.method_23168(entity)) > 4096.0)) {
            String lore;
            BakableModel hatModelData = Hat.overridden.get(() -> Cosmetica.getPlayerData(player).hat());
            if (!(hatModelData == null || (hatModelData.extraInfo() & 1) == 0 && player.method_6084(class_1304.field_6169))) {
                float hatTopY = hatModelData.bounds().get(1).getAsJsonArray().get(1).getAsFloat();
                float normalizedAngleMultiplier = (float)(-((double)Math.abs(playerModel.field_3398.field_3654) / 1.57 - 1.0));
                float lookAngleMultiplier = normalizedAngleMultiplier == 0.49974638f ? 0.0f : normalizedAngleMultiplier;
                stack.method_22904(0.0, (double)(hatTopY / 16.0f * lookAngleMultiplier), 0.0);
            }
            if (!(lore = Cosmetica.getPlayerData(lookupId, player.method_5477().getString()).lore()).equals("")) {
                class_2585 component = new class_2585(lore);
                boolean bl = !entity.method_21751();
                float height = entity.method_17682() + 0.25f;
                stack.method_22904(0.0, 0.1, 0.0);
                stack.method_22903();
                stack.method_22904(0.0, (double)height, 0.0);
                stack.method_22907(entityRenderDispatcher.method_24197());
                stack.method_22905(-0.025f, -0.025f, 0.025f);
                stack.method_22905(0.75f, 0.75f, 0.75f);
                class_1159 textModel = stack.method_23760().method_23761();
                float backgroundOpacity = class_310.method_1551().field_1690.method_19343(0.25f);
                int alphaARGB = (int)(backgroundOpacity * 255.0f) << 24;
                float xOffset = -font.method_27525((class_5348)component) / 2;
                font.method_30882((class_2561)component, xOffset, 0.0f, 0x20FFFFFF, false, textModel, multiBufferSource, bl, alphaARGB, packedLight);
                if (bl) {
                    font.method_30882((class_2561)component, xOffset, 0.0f, -1, false, textModel, multiBufferSource, false, 0, packedLight);
                }
                stack.method_22909();
            }
        }
    }

    private static class_1160 rotateVertex(class_1160 vertex, class_1160 origin, class_2350.class_2351 axis, float angle) {
        vertex.method_4944(origin);
        if (axis == class_2350.class_2351.field_11048) {
            return new class_1160(vertex.method_4943() + origin.method_4943(), (float)((double)vertex.method_4945() * Math.cos(angle) - (double)vertex.method_4947() * Math.sin(angle)) + origin.method_4945(), (float)((double)vertex.method_4947() * Math.cos(angle) + (double)vertex.method_4945() * Math.sin(angle)) + origin.method_4947());
        }
        if (axis == class_2350.class_2351.field_11052) {
            return new class_1160((float)((double)vertex.method_4943() * Math.cos(angle) + (double)vertex.method_4947() * Math.sin(angle)) + origin.method_4943(), vertex.method_4945() + origin.method_4945(), (float)((double)vertex.method_4947() * Math.cos(angle) - (double)vertex.method_4943() * Math.sin(angle)) + origin.method_4947());
        }
        if (axis == class_2350.class_2351.field_11051) {
            return new class_1160((float)((double)vertex.method_4943() * Math.cos(angle) - (double)vertex.method_4945() * Math.sin(angle)) + origin.method_4943(), (float)((double)vertex.method_4945() * Math.cos(angle) + (double)vertex.method_4943() * Math.sin(angle)) + origin.method_4945(), vertex.method_4947() + origin.method_4947());
        }
        throw new UnsupportedOperationException();
    }

    public static void clearAllCaches() {
        Debug.info("Clearing all Cosmetica Caches", new Object[0]);
        playerDataCache = new HashMap<UUID, PlayerData>();
        Models.resetCaches();
        CosmeticaSkinManager.clearCaches();
        System.gc();
    }

    private static /* synthetic */ PlayerData lambda$getPlayerData$4(UUID uuid, class_1937 level, String username, UUID uid) {
        if (!lookingUp.contains(uuid)) {
            lookingUp.add(uuid);
            Cosmetica.runOffthread(() -> {
                if (class_310.method_1551().field_1687 != level) {
                    lookingUp.remove(uuid);
                    return;
                }
                String target = insecureApiServerHost + "/get/info?username=" + Cosmetica.urlEncode(username) + "&uuid=" + uuid + "&token=" + Authentication.getLimitedToken();
                Debug.checkedInfo(target, "always_print_urls");
                try (Response response = Response.request(target);){
                    JsonObject jsonObject = response.getAsJson();
                    JsonObject hat = jsonObject.has("hat") ? jsonObject.get("hat").getAsJsonObject() : null;
                    JsonObject shoulderBuddy = jsonObject.has("shoulder-buddy") ? jsonObject.get("shoulder-buddy").getAsJsonObject() : null;
                    JsonObject cloak = jsonObject.has("cape") ? jsonObject.get("cape").getAsJsonObject() : null;
                    Map<UUID, PlayerData> map = playerDataCache;
                    synchronized (map) {
                        playerDataCache.put(uuid, new PlayerData(jsonObject.get("lore").getAsString(), jsonObject.get("upside-down").getAsBoolean(), jsonObject.get("prefix").getAsString(), jsonObject.get("suffix").getAsString(), hat == null ? null : Models.createBakableModel(hat), shoulderBuddy == null ? null : Models.createBakableModel(shoulderBuddy), cloak == null ? null : CosmeticaSkinManager.processCape(cloak)));
                        lookingUp.remove(uuid);
                    }
                }
                catch (IOException | ParseException e) {
                    new RuntimeException("Error connecting to " + target, e).printStackTrace();
                }
            }, ThreadPool.GENERAL_THREADS);
        }
        return PlayerData.NONE;
    }

    static {
        currentServerAddressCache = "";
        playerDataCache = new HashMap<UUID, PlayerData>();
        lookingUp = new HashSet<UUID>();
        LOGGER = LogManager.getLogger((String)"Cosmetica");
        MAIN_POOL = Executors.newFixedThreadPool(Integer.parseInt(System.getProperty("cosmetica.lookupThreads", "8")), new NamedThreadFactory("Cosmetica Lookup Thread"));
        toto = OptionalLong.empty();
        UNDASHED_UUID_GAPS = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
    }
}

