/*
 * Decompiled with CFR 0.152.
 */
package com.eyezah.cosmetics;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class CosmeticaConfig {
    private final Path propertiesPath;
    private boolean showNametagInThirdPerson = true;

    public CosmeticaConfig(Path propertiesPath) {
        this.propertiesPath = propertiesPath;
    }

    public void initialize() throws IOException {
        this.load();
        if (!Files.exists(this.propertiesPath, new LinkOption[0])) {
            this.save();
        }
    }

    public void load() throws IOException {
        if (!Files.exists(this.propertiesPath, new LinkOption[0])) {
            return;
        }
        Properties properties = new Properties();
        properties.load(Files.newInputStream(this.propertiesPath, new OpenOption[0]));
        this.showNametagInThirdPerson = Boolean.parseBoolean(properties.getProperty("show-nametag-in-third-person"));
    }

    public void save() throws IOException {
        File parentDir = this.propertiesPath.getParent().toFile();
        if (!parentDir.exists()) {
            parentDir.mkdir();
        }
        Properties properties = new Properties();
        properties.setProperty("show-nametag-in-third-person", String.valueOf(this.showNametagInThirdPerson));
        properties.store(Files.newOutputStream(this.propertiesPath, new OpenOption[0]), "Cosmetica Config");
    }

    public boolean shouldShowNametagInThirdPerson() {
        return this.showNametagInThirdPerson;
    }

    public void setShowNametagInThirdPerson(boolean showNametagInThirdPerson) {
        this.showNametagInThirdPerson = showNametagInThirdPerson;
    }
}

